% Skript-File MCTolBsp.m
%
%
% Aufruf:  MCTolBsp
%
%
% Das vorliegende Skript bestimmt die Verteilung der Makette
%
% M_s = M_1*M_2*(M_2-M_4)/((M_2-M_4)*M_1 + M_2*(M_1-M_3))
%
% mit Hilfe der MONTE-CARLO-METHODE !!
% 
% Die Mae sind dabei wie folgt verteilt:
% M_1 ist N(80, (0.075)^2)-verteilt
% M_2 ist dreiecksverteilt im Intervall [100.2, 100.7]
% M_3 ist gleichverteilt im Intervall [29.9, 30.1]
% M_4 ist gleichverteilt im Intervall [39.6, 40.0]
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 20.03.2003


% Vorinitialisierungen

EM1 = 80; sigmaM1 = 0.075;       % Verteilungsparameter
M2u = 100.2; M2o = 100.7;
M3u = 29.9; M3o = 30.1;
M4u = 39.6; M4o = 40.0;

Ms = [];                         % Werte fr die Schliemae

rand('state',sum(100*clock));    % Zufallsgenerator initialisieren
N = 50000;                       % Zahl der Versuche

for k=1:N                        % Zahl der Iterationen 
    m1 = normrndB(EM1,sigmaM1);  % Wert von Ma 1
    m2 = triangrnd(1, M2u, M2o); % Wert von Ma 2
    m3 = unifrndB(M3u, M3o);     % Wert von Ma 3
    m4 = unifrndB(M4u, M4o);     % Wert von Ma 4
    
                                 % neuen chliemawert berechnen
    Ms = [Ms, m1*m2*(m2-m4)/((m2-m4)*m1+m2*(m1-m3))];
end;


% Darstellung des Ergebnisses in Form eines Histogramms

                         % grter Wert zur Festlegung des Darstellungsbereichs
mBereicho = max(Ms);
                         % kleinster Wert zur Festlegung des Darstellungsbereichs
mBereichu = min(Ms);
                         % Bestimmung der Klassenanzahl und der Klassenmitten
KlAnz = max(5, floor(sqrt(N)));
KlAnz = min(KlAnz, 50);
dx = (mBereicho-mBereichu)/KlAnz;
bins = (mBereichu+dx/2:dx:mBereichu+KlAnz*dx-dx/2);

                         % Berechnung der Histogrammbalken
[M, X, emdist, cemdist] = distemp3(Ms, bins, 0);

                         % Plot des Histogramms
bar(X, emdist, 0.8);
hC = get(gca,'Children');
set(hC, 'FaceColor', [0.50,0.50,0.50])
set(gca, 'FontSize', 14);
xlabel('M_s/mm', 'FontSize', 14);
ylabel('Rel. Klassenh.', 'FontSize', 14);

    


