function [T, Pars] = MCWeibMixTestStat(paramsH0, N, M)
%
% Funktion MCWeibMixTestStat
%
% Aufruf: [T, Pars] = MCWeibMixTestStat(paramsH0, N, M)
%
% Funktion, die M Stichproben der Lnge N  einer Zufallsvariablen erzeugt, 
% deren Verteilung Mischverteilung einer berlagerung von ZWEI Weibull-verteilten 
% Zufallsvariablen nach dem
%
% Modell:  Y = B*X1 + (1-B)*X2
%
% ist.
%
% Dabei sind X1, X2 mit den Parametern b1, T1 und b2, T2 Weibull-verteilt sind
% und B eine Bernoulli-verteilte Zufallsgre ist mit (Anteils-)Wahrschein-
% lichkeit p.
%
% Aus den Stichproben werden nach der Methode der Kleinsten Quadrate
% mit Hilfe der Funktion nlinfit Werte fr die Verteilungsparameter
% geschtzt, aus denen der Wert T der Testvariablen
%
%         T = |p-p_0|/p + |b1-b1_0|/b1 + ... |T2-T2_0|/T2
%
% berechnet wird.
%
% Eingabeparameter:    paramsH0  Parameter-Vektor p_0,b1_0,T1_0 und b_0,T2_0
%                                der Nullhypothese
%
%                      N         Lnge der Stichprobe
%
%                      M         Zahl der Stichproben
%
% Ausgabeparameter:    T         Werte der Testvariablen T
%
%                      Pars      Mx5-Matrix der gefundenen Schtzungen
%                                (zu Testzwecken)
%
%
% Es werden sonst KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 28.01.2004

% Zuordnung der Parameter

p_0 = paramsH0(1);  b1_0 = paramsH0(2); T1_0 = paramsH0(3);
b2_0 = paramsH0(4); T2_0 = paramsH0(5);

% M Stichproben der Lnge N  entsprechend Nullhypothesenparametern
% mit Zufallsgenerator erzeugen

Zwerte = WeibullCombrnd([b1_0, T1_0, b2_0, T2_0], p_0, N, M)';

% Berechnung der Statistik T fr jede Stichprobe (Zeile)

T = []; Pars = [];

for k=1:M
    % Schtzung der Parameter fr diese Stichprobe
    [params] = FTWeibullComb(Zwerte(k,:), paramsH0);
    params = params(:)';   % Zeilenvektor erzeugen
    Pars = [Pars; params];
    
    % Berechnung und Speicherung der Teststatistik T
    p = params(1);  b1 = params(2); T1 = params(3);
    b2 = params(4); T2 = params(5);
    
    Taktuell = abs((p-p_0)/(p+eps)) + abs((b1-b1_0)/(b1+eps)) ...
        + abs((T1-T1_0)/(T1+eps)) + abs((b2-b2_0)/(b2+eps)) ...
        + abs((T2-T2_0)/(T1+eps));  % eps wird addiert um /0 zu vermeiden
    T = [T, Taktuell];
end;

