function [mu2] = MModal2(daten)
%
% Aufruf:  [mu2] = MModal2(daten)
% 
% Beispielaufruf: [mu2] = MModal2(verbrauch)
%
% Spezielle Version von LsgAufgMModal fr die Klasseneinteilung 7.5:0.1:11.5
% und den Parameterstartvektor [1/3, 8.5, 1/3, 10, 1/3]!!
%
% Die Funktion dient zur Anpassung der Dichte einer Mischverteilung zweier Normalverteilungen
% mit den Parametern lambda, mu_1, sigma_1, mu_2, sigma_2 an die empirische
% Verteilung, die sich aus den Daten aus daten und den Klassenmitten 
% ergibt.
%
% Eingangsdaten:	  daten      Datenvektor (Stichprobe)
%
% Ausgangsdaten:	  mu2        gefundener Parameter mu_2, 
%                                der Mischverteilung
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 4.1.2004

klmitten = (7.5:0.1:11.5);          % fest fr diese Funktion
beta0 = [1/3, 8.5, 1/3, 10, 1/3];   % fest fr diese Funktion

% Bestimmung der relativen Klassenhufigkeiten fr die
% gewhlte Klasseneinteilung mit Hilfe der Funktion
% distempStetig. Der Parameter Hfg enthlt die absoluten
% Hufigkeiten, aus denen die relativen Klassenhufig-
% keiten in diesem Fall berechnet werden mssen, da in
% emdist die um die Klassenbreite normierten relativen
% Klassenhufigkeiten enthlt

[Hfg, X, emdist, cemdist] = distempStetig(daten, klmitten, 0);

RelH = Hfg/length(daten);
RelH = RelH(:);            % Spaltenvektor
klmitten = klmitten(:);

% Anpassung des Modells mit Hilfe der Funktion nlinfitB

fprintf('Die Berechnung kann u.U. sehr lange dauern!');
[beta,R,J] = nlinfitB(klmitten,RelH,@AufgMModalfun,beta0,klmitten);

% Berechneter Modalwert 

mu2 = beta(4);

