function [mu2] = MModal3(daten, klmitten)
%
% Aufruf:  [mu2] = MModal3(daten, klmitten)
% 
% Beispielaufruf: [mu2] = MModal3(verbrauch, (7.5:0.1:11.5))
%
% Die Funktion dient zur Anpassung der Dichte einer Mischverteilung zweier Normalverteilungen
% mit den Parametern lambda, mu_1, sigma_1, mu_2, sigma_2 an die empirische
% Verteilung, die sich aus den Daten aus daten und den Klassenmitten 
% ergibt. Dabei sind lambda, mu_1, sigma_1, sigma_2 fest vorgegeben.
% Variiert (angepasst) wird lediglich der Parameter mu_2.
% Diese Parameter mssen der Funktion ber eine GLOBALE VARIABLE
% beta0 zur Verfgung gestellt werden.
%
% Beispiel:   global beta0
%
%             beta0 = [1/3, 8.5, 1/3, 9, 1/3];
%
%
% Eingangsdaten:	  daten      Datenvektor (Stichprobe)
%                     klmitten   Klassenmitten der Klasseneinteilung
%
% Ausgangsdaten:	  mu2        gefundener Parameter mu_2, 
%                                der Mischverteilung
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 6.1.2004

% Global-Deklaration fr beta0

global beta0

% Bestimmung der relativen Klassenhufigkeiten fr die
% gewhlte Klasseneinteilung mit Hilfe der Funktion
% distempStetig. Der Parameter Hfg enthlt die absoluten
% Hufigkeiten, aus denen die relativen Klassenhufig-
% keiten in diesem Fall berechnet werden mssen, da in
% emdist die um die Klassenbreite normierten relativen
% Klassenhufigkeiten enthlt

[Hfg, X, emdist, cemdist] = distempStetig(daten, klmitten, 0);

RelH = Hfg/length(daten);
RelH = RelH(:);            % Spaltenvektor
klmitten = klmitten(:);
mu2_0 = beta0(4);

% Anpassung des Modells mit Hilfe der Funktion nlinfit

[mu2,R,J] = nlinfitB(klmitten,RelH,@Mu2Modalfun,mu2_0,klmitten);



