% Script-File MWTestNV.m
%
% Aufruf:  MWTestNV
%
% Dieses Script-File fhrt fr die im Vektor daten (innerhalb des
% Skript-Files zu editieren) angegebenen Werte einen Mittelwerttest
% fr die Normalverteilung bei gegebener Varianz (Z-Test), bei unbekannter
% Varianz (T-Test) durch. Es werden die Toolbox-Funktionen ztest und ttest
% verwendet (vgl. Beispiel 3.29ff).
%
% Die Werte fr die Nullhypothese mu0 und die varianz sigma, sowie
% fr das Signifikanzniveau sind innerhalb des  Skripts zu editieren.
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 7.03.2003

% Datenvektor

daten = [100.1, 101.2, 99.5, 99.0, 100.7, 100.0, 101.2, 99.2, 99.0, 98.7];

% Parameter

mu0 = 100;                 % Nullhypothese
alpha = 0.05;              % Signifikanzniveau
sigma = 0.5;               % fr Test mit bbekannter Varianz


tail = 0;                  % zweiseitiger Test

                           % Test bei bekannter Varianz
[Testergebnis,p,KonfInt,stats] = ztestB(daten,mu0,sigma,alpha,tail);

fprintf('\nZweiseitiger Z-Test:');
fprintf('\nTestergebnis (0=Annahme von H0, 1=Zurckweisung):         %d',Testergebnis);
fprintf('\nBeobachtungswahrscheinlichkeit des Testwertes bei H0:     %f',p);
fprintf('\nKonfidenzintervall zum Niveau 1-alpha fr den Mittelwert: [%f,%f]',KonfInt(1),KonfInt(2));
fprintf('\nWert der Testvariablen:                                   %f\n\n', stats.Testvariable_Z);


                           % Test bei unbekannter Varianz
[Testergebnis,p,KonfInt,stats] = ttestB(daten,mu0,alpha,tail);

fprintf('\nZweiseitiger T-Test:');
fprintf('\nTestergebnis (0=Annahme von H0, 1=Zurckweisung):         %d',Testergebnis);
fprintf('\nBeobachtungswahrscheinlichkeit des Testwertes bei H0:     %f',p);
fprintf('\nKonfidenzintervall zum Niveau 1-alpha fr den Mittelwert: [%f,%f]',KonfInt(1),KonfInt(2));
fprintf('\nWert der Testvariablen:                                   %f', stats.Testvariable_T);
fprintf('\nFreiheitsgrade:                                           %d\n\n', stats.Freiheitsgrade_T );

tail = 1;                  % einseitiger Test 

[Testergebnis,p,KonfInt,stats] = ttestB(daten,mu0,alpha,tail);

fprintf('\nEinseitiger T-Test:');
fprintf('\nTestergebnis (0=Annahme von H0, 1=Zurckweisung):         %d',Testergebnis);
fprintf('\nBeobachtungswahrscheinlichkeit des Testwertes bei H0:     %f',p);
fprintf('\nKonfidenzintervall zum Niveau 1-alpha fr den Mittelwert: [%f,%f]',KonfInt(1),KonfInt(2));
fprintf('\nWert der Testvariablen:                                   %f', stats.Testvariable_T);
fprintf('\nFreiheitsgrade:                                           %d', stats.Freiheitsgrade_T );
