% Script-File MoivreLaplace.m
%
% Aufruf:  MoivreLaplace
%
% Grafische Illustration zum Satz von Moivre-Laplace
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 7.03.2003


n = 100; p = 0.2; q = 1- p;
mu = n*p; sigma = sqrt(n*p*q);

x=(4:1:36);                     % Wertebereich von X
binov = binopdfB(x,n,p);        % Binomialverteilung

dichte = normpdfB(x, mu, sigma);% Normalverteilung
                                % grafische Darstellung
bar(x, binov, 1); hold;
plot(x,dichte,'r-','LineWidth',3);
set(gca, 'FontSize', 12);
xlabel('Wert der Zufallsvariablen X');
ylabel('Wert der Verteilung/Dichte');
mx = max(max(binov),max(dichte));
axis([8,32,0,mx])