% Script-File PoissonVert.m
%
% Aufruf:   PoissonVert
%
% Grafische Darstellung der Poisson-Verteilung
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 13.5.2002/26.6.2004


mu = 3;            % Parameter der Poisson-Verteilung
n = 20;            % erste n mgliche Werte der Zufallsvariablen 
k = (-2:1:n+2);    % Wertebereich der Darstellung
                   % Berechnung der Werte der Verteilung 
poiss = poisspdfB(k,mu);

                   % Plot der Werte in Form eines Stabdiagramms
stem(k, poiss, 'r-'); 
xlabel('k','FontSize', 14); ylabel('f_P(k)','FontSize', 14);
mx = max(poiss);
axis([-2,n+2,0,mx])

clds = get(gca, 'Children');
set(clds(1), 'LineWidth',3);
set(clds(2), 'LineWidth',3);
set(gca, 'FontSize',14);
