% Script File QRKdraehte.m
%
% Aufruf: QRKdraehte
%
% bungsaufgabe zur Berechnung von Qualittsregelkarten
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 11.02.2004

% Messwerte laden

load draehte.dat

% Parameter der Karte fr eine Vorlaufberechnung

alpha = 0.0027;               % Signifikanzniveau
conf = 1-alpha;
                              % technische Toleranzen
                              % laut Vorgabe
Tolgrenzen = [0.56-0.006, 0.56+0.006];        
                              % Schtzverfahren fr
                              % die Streuung einstellen
verfahren = 'std';

% Berechnung der Mittelwertkarte

[outliersX, avg, s, UEGX, OEGX] ...
             = xbarplotD(draehte,conf,Tolgrenzen,verfahren)
         
% Berechnung der Streuungskarte

figure
[outliersS, sbar, UEGS, OEGS] = schartD(draehte,conf)