% Script-File RegressKoeffTest.m
%
% Aufruf:  RegressKoeffTest
%
% Beispiel zum Hypothesentest fr den Regressionskoeffizienten.
% Es wird ein Test der Nullhypothese
%
%        H0: a=0
%
% der Fahrzeugbreite-Wendekreisradius-Beziehung des Datensatzes CarDATA93cars.dat
% gegen die zweiseitige Alternative durchgefhrt!
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 16.10.2003


% Laden des Datensatzes CarDATA93cars.dat

ReadCarData

% Zahl der Datenpunkte

n = length(Breite);

% "Fehler"quadratsumme der Einflusgre "Breite"
% (var berechnet empirische Varianz; siehe Definition)

ssx = (n-1)*var(Breite);

% Berechnung des arithmetischen Mittels der Einflussgren

xquer = mean(Breite);

% Berechnung der Regressionsparameter

X = [Breite, ones(length(Breite),1)];
beta = regressB(Wendekreis,X);

a = beta(1); b = beta(2);

% Berechnung der Residuenquadratsumme

ssr = sum( (Wendekreis - a*Breite - b).^2 );

% Berechnung des zweiseitigen alpha-Quantils der t-Verteilung
% mit (n-2) Freiheitsgeraden

alpha = 0.05;                    % Signifikanzniveau 5%
utilde = tinvB(1-alpha/2, n-2);

% Test, ob beobachteter Wert von a der Nullhypothese entspricht

a_0 = 0;                         % ist die Nullhypothese !

H = abs(a) >  utilde*sqrt(ssr/((n-2)*ssx));

% Bestimmung des p-Wertes bei Gltigkeit von H0
      
                                 % Wert der Testvariablen
atilde = sqrt((n-2)*ssx/ssr)*(a-a_0);   
                                 % Wkt abs(atilde) und grer
p = tcdfB(-abs(atilde),n-2) + (1-tcdfB(abs(atilde),n-2));


% Ausgabe des Ergebnisses

if H
    fprintf('\nDie Nullhypothese fr den Regressionskoeffizienten a wird abgelehnt!\n');
else
    fprintf('\nDie Nullhypothese fr den Regressionskoeffizienten a wird nicht abgelehnt!\n');
end;
    
fprintf('Der p-Wert ist %7.4f\n\n', p);
