function [Tw, kwpdf] = UebKruskwallpdf()
%
% Funktion UebKruskwallpdf
%
% Aufruf:  [Tw, kwpdf] = UebKruskwallpdf
%
% bung zur Verteilung der Testvariablen T des Kruskall-Wallis-Tests
% fr Stichproben OHNE BINDUNGEN. Berechnet wird die Verteilung
% fr n=7 Stichprobenwerte, aufgeteilt in k=3 Faktorgruppen
% zu je m_1=3, m_2=2 und m_3=2 Werten.
% (Dies ergibt 7! = 5040 mgliche Rangkombinationen und 
% 7!/(3!*2!*2!) = 210 mgliche verschiedene Werte der Kruskall-Wallis
% Testvariablen T)
%
% Eingangsparameter:            keine (da nur ein spezielles Beispiel
%                                      berechnet wird)
%
% Ausgangsparameter:            Tw     aufsteigend geordnete Werte der 
%                                      Tesvariablen
%                               kwpdf  zugehrige relative Hufigkeit 
%                                      (Werte der Verteilung)
%
% Es wird ein Stabdiagrammplot mit dem Ergebnis (Verteilung von T) erzeugt!
%
% Es werden keine Fehleingaben abgefangen!
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 10.9.2003


global n m

% Zahl der Rnge und Zahl der Werte pro Faktorgruppe
n = 7; m = [3 2 2];

% Mgliche Rangkombinationen des Tests fr das vorliegende
% Beispiel bestimmen

[RnkKombi] = getRankKombi;

% Fr jede Permutation den Wert der Kruskal-Wallis-Testvariablen
% bestimmen

A = [ 1 0 0; ...             % Hilfsmatrix zur Berechnung der
      1 0 0; ...             % Rangsummen der Faktorgruppen
      1 0 0; ...
      0 1 0; ...
      0 1 0; ...
      0 0 1; ...
      0 0 1];

rksumGrp = RnkKombi*A;       % Rangsummen der Faktorgruppen
dim = size(rksumGrp);
v = m*(n+1)/2;               % Gewichtete Rangsummenmittel
RgM = repmat(v, dim(1),1);
Ttilde = ((rksumGrp-RgM).^2)*((1./m)');
T = (12/(n*(n+1)))*Ttilde;   % Wert(e) der Testvariablen fr
                             % jede Rangkombination

T = sort(T);                 % Werte von T aufsteigend sortiert
y = [1; diff(T)>0.00001];    % nderunsstellen
Tw = T(logical(y));          % verschiedene Werte von T

df = [find(y>0); length(y)]; % Index, fr die die T-Werte sich ndern

anz = diff(df);              % absolute Hufigkeiten
anz(end) = anz(end)+1;

kwpdf = anz/length(RnkKombi);% relative Hufigkeit (Wahrscheinlichkeit)

stem(Tw, kwpdf, 'r-')
hndls = get(gca, 'Children');
set(hndls(1), 'LineWidth',4)
set(hndls(2), 'LineWidth',4)


% Subfunction zur Erzeugung der Rangkombinationen 
% fr dieses spezielle Beispiel
%-------------------------------------------------------

function [RnkKombi] = getRankKombi()

global n m

prnks = [1 2 3 4 5 6 7];
kombGr1 = nchoosek(prnks,m(1));

Y1 = [];
for k=1:length(kombGr1)
    v = prnks;
    v(kombGr1(k,:))=[];
    Y1 = [Y1;v];
end;

kombGr2 = nchoosek([1 2 3 4],m(2));

Y2 = [];
for k=1:length(Y1)
    z = Y1(k,:);
    
    for j=1:length(kombGr2)
    v = z;
    v(kombGr2(j,:))=[];
    
    Y2 = [Y2; [kombGr1(k,:), v]];
    end;  
end;

RnkKombi = [];
for k=1:length(Y2)
    z = Y2(k,:);
    v = prnks;
    v(z) = [];
    RnkKombi = [RnkKombi; [Y2(k,:), v]];
end;
    




