function [ElEreig, Anz] = UrnenExp2(n, k)
%
% Funktion [ElEreig, Anz] = UrnenExp2(n, k)
%
% Beispielaufruf:  [ElEreig, Anz] = UrnenExp2(4, 2)
%
% Illustration zum Urnenexperiment "Ziehen MIT Zurcklegen und OHNE
% Bercksichtigung der Reihenfolge. Sollte nur fr kleinere n un k
% verwendet werden, da sonst der Speicherplatz nicht ausreicht.
%
% Eingabeparameter:            n         Elemente der Urne [1,2,3,..,n]
%                              k         Zahl der Ziehungen
%
% Ausgabeparameter:            ElEreig   Matrix mit smtlichen 
%                                        Elementarereignissen
%                              Anz       Zahl der Elementarereignisse
%
%
% Es werden keine Fehleingaben abgefangen!
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.9.2003

% Erste Ziehung vorinitialisieren
ElEreig = cumsum(ones(n,1));

for j=2:k                    % fr jede weitere Ziehung
    ElEreigNeu = [];
    for m=1:length(ElEreig)  % und fr alle bisher gezogenen
                             % Kombinationen
        for r = ElEreig(m,j-1):n
                             % und die verbleibenden mglichen
                             % Ziehungen ElEreig vergrern
            ElEreigNeu = [ElEreigNeu; [ElEreig(m,:),r]];
        end;
    end;
    ElEreig = ElEreigNeu;
end;
                             % Zahl der Elemente berechnen
[Anz, indx] = size(ElEreig);