function [relH] = UrnenExp4StabHfg(V, trials, n, k)
%
% Funktion [relH] = UrnenExp2StabHfg(V, trials, n, k)
%
% Beispielaufruf:  [relH] = UrnenExp2StabHfg([1 2 3], 100, 5, 3)
%
% Illustration zum Thema "Stabilisierung der Hufigkeiten" mit dem
% Urnenexperiment "Ziehen OHNE Zurcklegen und OHNE
% Bercksichtigung der Reihenfolge. Die Funktion fhrt mit Hilfe eines
% MATLAB-Zufallsgenerators trials mal k Ziehungen aus der "Urne" [1,2,3,..,n]
% durch und prft, ob das Ergebnis einer Zeile der Matrix V entspricht, welche
% ein vorgegebenes Ereignis reprsentiert.
%
% Nach trials Versuchen wird die relative Hufigkeit des Ereignisses V
% (Vorkommen eines Zuges in V in bezug zu trials) zurckgeliefert.
%
% Eingabeparameter:            n            Elemente der Urne [1,2,3,..,n]
%                              k            Zahl der Ziehungen
%                              V            Ereignis des Urnenexperimentes
%                                           in Form von Elementarereignissen
%                                           als Zeilen der Matrix V
%                              trials       Zahl der Versuche
%
% Ausgabeparameter:            relH         Relative Hufigkeit von V
%
%
% Es werden keine Fehleingaben abgefangen!
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 2.9.2003

% Trefferanzahl vorinitialisieren (absolute Hufigkeit)
treffer = 0;
[zeilen, sp] = size(V);         % Zahl der Elementarereignisse von V

for m=1:trials                  % Versuche durchspielen
                                % Ziehung(en) durchfhren
    [ElEreignis] = UrnenExp2Ziehung(n, k);
    for j=1:zeilen              % Elementarereignisse von V durchprfen
                                % falls Zeile gleich ElEreignis
        if sum(ElEreignis==V(j,:))==k
            treffer = treffer+1;
        end;
    end;
end;

relH = treffer/trials;          % relative Hufigkeit berechnen

