function [ElEreig, Anz] = UrnenExp4(n, k)
%
% Funktion [ElEreig, Anz] = UrnenExp4(n, k)
%
% Beispielaufruf:  [ElEreig, Anz] = UrnenExp4(4, 2)
%
% Illustration zum Urnenexperiment "Ziehen ohne Zurcklegen und OHNE
% Bercksichtigung der Reihenfolge. Sollte nur fr kleinere n 
% (empfohlen werden fr die intern verwendete Funktion nchoosek
% Werte kleiner als 15) und k(<=n) verwendet werden, da sonst der 
% Speicherplatz nicht ausreicht.
%
% Eingabeparameter:            n         Elemente der Urne [1,2,3,..,n]
%                              k(<=n)    Zahl der Ziehungen
%
% Ausgabeparameter:            ElEreig   Matrix mit smtlichen 
%                                        Elementarereignissen
%                              Anz       Zahl der Elementarereignisse
%
%
% Es werden keine Fehleingaben abgefangen!
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.02
% Datum: 12.8.2004

% Vektor mit Elementen von 1 bis n erzeugen

elems = cumsum(ones(1,n));

% Funktion nchoosek aufrufen

ElEreig = nchoosek(elems, k);

% Anzahl der Werte des Ereignisraums bestimmen

[Anz, indx] = size(ElEreig);
