function [ElEreignis] = UrnenExp4Ziehung(n, k)
%
% Funktion [ElEreignis] = UrnenExp4Ziehung(n, k)
%
% Beispielaufruf:  [ElEreignis] = UrnenExp4Ziehung(5, 3)
%
% Illustration zum Urnenexperiment "Ziehen OHNE Zurcklegen und OHNE
% Bercksichtigung der Reihenfolge. Die Funktion liefert mit Hilfe eines
% MATLAB-Zufallsgenerators das Ergebnis eines Experiments mit k Ziehungen.
%
% Eingabeparameter:            n            Elemente der Urne [1,2,3,..,n]
%                              k            Zahl der Ziehungen
%
% Ausgabeparameter:            ElEreignis   Elementarereignis
%
%
% Es werden keine Fehleingaben abgefangen!
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.9.2003

% "Urne" mit n Elementen vorinitialisieren
elems = cumsum(ones(1,n));

% Elementarereignis leer vorinitialisieren
ElEreignis = [];


for j=1:k                    % fr jede Ziehung
                             % Zufallsgenerator aufrufen 
    index = unidrndB(length(elems));                         
                             % Wert der "Urne entnehmen"
    wert = elems(index);
    elems(index) = [];
                             % Wert hinzufgen
    ElEreignis = [ElEreignis, wert];                      
end;

                             % Werte aufsteigend sortieren
ElEreignis = sort(ElEreignis);   