function [TestErg, stat, kritVals] = VARtest(sigma0, daten, alpha)
%
% Funktion VARtest
%
% Aufrufbeispiel: [TestErg, stat, kritVals] = VARtest(3, daten, 0.05)
%
% Fhrt einen ZWEISEITIGEN Test der Varianz sigma^2 fr NORMALVERTEILTE
% Zufallsvariablen durch.
%
% Eingabeparameter:    sigma0    Streuung entsprechend Nullhypothese H0
%                      daten     Stichprobe
%                      alpha     Signifikanzniveau des zweiseitigen Tests
%
% Ausgabeparameter:    TestErg   Ergebnis des Tests (0=nicht abgelehnt, 1=abgelehnt)
%                      stat      Wert der Testvariablen S^2
%                      kritVals  Grenzen des Annahmebereiches
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 31.10.2002

% Parameter des Tests ermitteln

n = length(daten);                   % Stichprobenlnge
chialpha2 = chi2invB(alpha/2, n-1);  % Quantile der Chi-Quadrat-Verteilung
chi1alpha2 = chi2invB(1-alpha/2, n-1);  

% kritische Werte berechnen

kritVals  = [chialpha2*sigma0^2/(n-1), chi1alpha2*sigma0^2/(n-1)];

% Testvariable berechnen

stat = var(daten);

% Testergebnis

TestErg = ~((kritVals(1) <= stat)&(stat<=kritVals(2)));
