function [dabg, dang] = bedienSys(vers, Knl, bz, lambda, Tmax)
%
% Funktion bedienSys
%
% Aufruf:  [dabg, dang] = bedienSys(vers, Knl, bz, lambda, Tmax)
%
% Aufrufbeispiel:    [dabg, dang] = bedienSys(10, 10, 2, 1/3, 1000)
%
% In dieser Funktion wird mit Hilfe des MONTE-CARLO-Ansatzes ein N-kanaliges
% Bediensystem mit einer festen Bedienzeit simuliert.
% Das Beispiel entstammt dem Buch von Sobol ber die Monte-Carlo-Methode
% (Seite 50 ff).
%
%
% Eingabeparameter: 		    vers       Zahl der Simulationen
%
%                               Knl        Anzahl(>0) der Bedienkanle
%
%                               bz         feste Bedienzeit
%
%                               lambda     Parameter der Exponentialverteilung;
%                                          die BedienwunschABSTNDE sollen exponentiell
%                                          verteilt sein (Poisson-Strom)
%
%                               Tmax       Simulationsdauer
%
% Ausgabeparameter: 		    dabg       Durchschnittliche Zahl der abgelehnten Bedienwnsche
%
%                               dang       Durchschnittliche Zahl der angenommenen Bedienwnsche
%
%                                      					
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 5.03.2003


% Vorinitialisierungen

dang = 0;  dabg = 0;


for k=1:vers                         % vers Simulationen durchfhren

    abg = 0; ang = 0;
    rand('state',sum(100*clock));    % Zufallsgenerator initialisieren

    time = zeros(1,Knl);             % Bedienzeit fr die Kanle
    T = 0;                           % aktueller Zeitpunkt
    T = exprndB(1/lambda);           % man beachte die MATLAB-Definition des Parameters!

    while T < Tmax                   % solange Simulationszeit nicht abgelaufen
        i = 1;                       % der erste Wunsch wird stets von ersten Kanal
                                     % bearbeitet
        while i<=Knl                 % solange noch nach freien Kanlen zu suchen ist
            if time(i)<=T            % Kanal frei
                time(i) = T + bz;    % belege Kanal i bz Zeiteinheiten
                ang = ang + 1;       % Zhler fr angenommene Bedienwnsche hochzhlen
                                     % und berechne Zeitpunkt fr den nchsten Bedienwunsch
                T = T + exprndB(1/lambda); 
            else                     % Kanal i war belegt
                i = i+1;             % gehe zum nchsten Kanal
            end;
        end;
        
        if i>Knl                     % hier sind alle Kanle belegt
            abg = abg + 1;           % Zhler fr die abgelehnten Bedienwnsche hochzhlen
                                     % und berechne Zeitpunkt fr den nchsten Bedienwunsch
            T = T + exprndB(1/lambda); 
        end;    
    end;

dang = dang + ang;  dabg = dabg + abg;

end; % Ende Simulationsschleife

dang = dang/vers;
dabg = dabg/vers;