% Script-File chi2Beispiel.m
%
% Aufruf:  chi2Beispiel
%
% Beispiel fr die Chi-Quadrat-Verteilung
% Grafische Darstellung und Berechnung der Kennwerte
% 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 18.8.2002

x=(0:0.001:30);           % Wertebereich von X
n = 6;                    % Parameter der Chi-Quadrat-Verteilung
                          % (Zahl der Freiheitsgrade)

                          % Verteilungsdichte der Chi-Quadrat-Verteilung
pdfchi2 = chi2pdfB(x, n);   
                          % grafische Darstellung
plot(x, pdfchi2,'r-','LineWidth',4);
set(gca, 'FontSize', 14);
xlabel('x', 'FontSize', 14);
ylabel('f_{\chi^2}(x)', 'FontSize', 14);
axis([0,30,0,1.1*max(pdfchi2)])

                          % Berechnung von Erwartungswert und
                          % Varianz
[EW, Var] = chi2statB(n)
                          % Berechnung des Medianwertes
u_50 = chi2invB(0.5,n)                     
                          % Berechnung des Modalwertes
[m,i] = max(pdfchi2); 
m=x(i)


