function [erg, kritwert, chiqwert]= ...
          chiquad(daten, K, us, os, niveau, mu, sigma)
%
% Funktion chiquad(daten, K, us, os, niveau, mu, sigma)
%
% Aufruf:  [erg, kritwert, chiqwert]=
%               chiquad(daten, K, us, os, niveau, mu, sigma)
%
% Fhrt einen Chi-Quadrat-Test fr Hypothesen ber die
% NORMALVERTEILUNG durch.
%
%
% Eingabeparameter:    daten       Stichprobe
%                      K           Anzahl der Klassen
%                      us          Untere Schranke fr die
%                                  Klassenbildung
%                      os          Obere Schranke fr die
%                                  Klassenbildung
%                      niveau      Signifikanzniveau (1%,5% etc.)
%                      mu          Mittelwert der Normalverteilung
%                                  entsprechend der
%                                  Nullhypothese H0
%                      sigma       Streuung der Normalverteilung
%                                  entsprechend der
%                                  Nullhypothese H0
%
% Ausgabeparameter:    erg         Ergebnis des Tests:
%                                 'H0 abgelehnt'
%                                  oder 'H0 nicht abgelehnt'
%                      kritwert    Der intern berechnete kritische
%                                  Wert fr das gegebene
%                                  Signifikanzniveau
%                      chiqwert    Der aus der Stichprobe
%                                  resultierende Wert von
%                                  Chi-Quadrat
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 6.12.2002


% Feststellen, wieviel Stichprobenwerte in den
% Bereich [us,os] fallen

uswrt = daten >= us*ones(size(daten));
dat1 = daten(uswrt);
oswrt= dat1 <= os*ones(size(dat1));
tststichprobe = dat1(oswrt);

n=length(tststichprobe);

% Bestimmung der absoluten Klassenhufigkeiten
% mit MATLABs hist-Kommando

dx = (os-us)/(2*K);               % Klassenbreite/2
Klassenmitten = (us+dx:2*dx:os-dx);
[AKH,Klassenmitten] = hist(tststichprobe,Klassenmitten);


% Bestimmung der theoretischen Klassenhufigkeiten

TKH = n*(normcdfB(Klassenmitten+dx,mu,sigma)-...
               normcdfB(Klassenmitten-dx,mu,sigma));

% Bestimmung der Testgre Chi-Quadrat

chiqwert = sum( ((AKH-TKH).^2)./TKH );


% Bestimmung des Kritischen Wertes

kritwert = chi2invB(1-niveau/100,K-1);


% Entscheidung des Hypothesentests

if chiqwert > kritwert
   erg ='H0 wird abgelehnt';
else
   erg ='H0 wird nicht abgelehnt';
end;