function [werte] = dWeibull(x, params)
%
% Funktion, die fr alle x die Werte der Weibull-Verteilungsdichte
% zurckliefert.
%
% Eingabeparameter:    x      Vektor der Abzissenwerte (reell)
%
%                      Params Weibull-Parameter b, T
%
% Ausgabeparameter:    werte  Werte der Verteilungsfunktion
%
%
% Es werden sonst KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 19.8.2003

b = params(1);
T = params(2);

a = 1/(T^b);              % Anpassung der Parameter auf die MATLAB-Definition
                          % Berechnung Weibull-Verteilungsdichte
werte = weibpdfB(x, a, b);

