function [maxdiff] = diffChiNV(n)
%
% Funktion diffChiNV
%
% Aufruf:  [maxdiff] = diffChiNV(n)
%
%
% Diese Funktion berechnet die Differenz der Dichten
% einer Chi-Quadrat-Verteilung mit n Freiheitgraden und einer
% N(n,2n)-Verteilung auf dem Intervall [n-4*sqrt(2*n), n+4*sqrt(2*n)]
% (4-sigma-Grenzen, Kriterium:maximaler Absolutbetrag)
% 
%
% Eingabeparameter:    n         Freiheitsgrad der Chi-Quadrat-Verteilung
%
% Ausgabeparameter:    maxdiff   Differenz (Betrag)
%
%
% Es werden KEINE Fehleingaben abgefangen !!
%
% Vorlesung: Mathematik III
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 4.9.2002

% Intervall fr die Berechnung der Differenz festlegen

intv = linspace(n-4*sqrt(2*n), n+4*sqrt(2*n));

% Werte der Verteilungsdichten berechnen

chi2vals = chi2pdfB(intv, n);
nvvals = normpdfB(intv, n, sqrt(2*n));

% maximale Differenz berechnen

maxdiff = max(abs(chi2vals-nvvals));

