function [N, X, emdist, cemdist]= distempStetig(data, bins, plotten)
%
% Funktion distempStetig(data, bins, plotten)
%
% Aufruf:  [N, X, emdist, cemdist] = distempStetig(data, bins, plotten)
%
% Berechnet die empirische Verteilung und die empirische Verteilungsfunktion
% fr den Eingangsdatenvektor data und stellt diese auf Wunsch grafisch dar.
% Dabei wird die Klassenbreite bestimmt und die Balkenhhen des Histogramms
% werden so angepasst, dass die Balkenflche mit dem Wert der relativen Klassen-
% hufigkeit bereinstimmt. Dies geschieht zur besseren Vergleichbarkeit mit
% den Werten einer STETIGEN Verteilungsdichte.
% 
% Eingangsdaten:	  data      Datenvektor (Stichprobe)
%                     bins      Punkte ber denen Histogrammbalken bestimmt werden
%				                (Klassenmitten fr stetige Merkmale);
%                               durch die Abstnde werden die Klassenbreiten bestimmt!
%			          plotten   0 falls Ergebnis nicht geplottet werden soll, 
%                                 sonst wird geplottet.
%
% Ausgangsdaten:	  N         Hufigkeiten
%                     X         Bin-Mitten
%			          emdist    rel. Hufigkeit/Klassenbreite !!!!!
%			          cemdist   kumulative re. Hufigkeit
%
%
% Es werden KEINE Fehleingaben abgefangen !!
% 		
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 3.01
% Datum: 5.3.2003


% Absolute Hufigkeiten bestimmen (N)

[N,X] = hist(data, bins);

% Klassenbreiten bestimmen (siehe Code von hist; type hist)

xx = bins(:)';
miny = min(min(data));
maxy = max(max(data));
binwidth = [diff(xx) 0]; % Klassenbestimmung wie bei hist
xx = [xx(1)-binwidth(1)/2 xx+binwidth/2];
xx(1) = min(xx(1),miny);
xx(end) = max(xx(end),maxy);
breite = diff(xx);

% relative Hufigkeiten bestimmen und
% kumulative Hufigkeiten bestimmen

emdist = N/length(data);
cemdist = [0, cumsum(emdist), 1];

% Histogrammbalken auf Klassenbreite normieren

emdist = emdist./breite;

% Plot von Verteilung (Histogramm)
% und Verteilungsfunktion, falls gewnscht

if plotten
    subplot(211)
    bar(X, emdist, 0.8);
    set(gca, 'FontSize', 12);
    xlabel('Werte von X');
    ylabel('Rel. Klassenh.');
    axis([xx(1), xx(end), 0, max(emdist)]);
    
    subplot(212)
    stairs([xx(1), X, xx(end)], cemdist);
    axis([xx(1), xx(end), 0, 1]);
    set(gca, 'FontSize', 12);
    hndl = get(gca, 'Children');
    set(hndl, 'LineWidth', 4);
    set(hndl, 'Color','r');
    xlabel('Werte von X');
    ylabel('kumul. rel. Klassenh.');
end;