function [y] = expModell(beta, x)
%
% Funktion expModell
%
% Aufruf:  [y] = expModell(beta, x)
%
% Beispiel zur NICHTLINEAREN Regression.
% Diese Funktion definiert die Vorschrift eines EXPONENTIELLEN Modells
% fr die Daten aus VWGolf.dat. Mit diesem Modell werden die Gebrauchtwagenpreise
% in Abhngigkeit vom Alter des Wagens dargestellt.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.12.2003

% Modellparameter

b0 = beta(1); b1 = beta(2); b2 = beta(3);

% Modell der nichtlinearen Regressionsfunktion

y = b0 + b1*exp(-b2*x);

