function [ZZahlen] = getFBspVar(fBsp, N)
%
% Funktion getFBspVar
%
% Aufruf:  [ZZahlen] = getFBspVar(fBsp, N)
%
% Aufrufbeispiel:    [ZZahlen] = getFBspVar(@FBspVertFkt, 200)
%
% Mit dieser Funktion knnen N Zufallszahlen erzeugt werden, die nach 
% der stetigen Verteilungsfunktion in fBsp verteilt sind.
%
%
% Eingabeparameter: 		    N           Anzahl(>0) der Zufallspunkte 
%
%                               fBsp        handle auf die Funktionsvorschrift der
%                                           Verteilungsfunktion
%
% Ausgabeparameter: 		    ZZahlen     Erzeugte Zufallszahlen
%                                      					
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 7.03.2003


% Vorinitialisierungen

warning off
ZZahlen = [];
rand('state',sum(100*clock));    % Zufallsgenerator initialisieren

for k=1:N                        % Zahl der Iterationen 
                                 % (Gleichverteilten) Zufallspunkt im Intervall 
                                 % [0,1] bestimmen
    c = rand(1,1);
                                 % Transformationsgleichung lsen
                                 % (0 ist immer Startwert)       
    y = fzero(@NsProb, 0, [], fBsp, c);
                                 % Wert speichern
    ZZahlen = [ZZahlen; y];  
end;
