function [PoissZahlen] = getPoissVar(mu, N)
%
% Funktion getPoissVar
%
% Aufruf:  [PoissZahlen] = getPoissVar(mu, N)
%
% Aufrufbeispiel:    [PoissZahlen] = getPoissVar(3, 100)
%
% Mit dieser Funktion knnen N Poisson-verteilte Zufallszahlen erzeugt werden.
% Die Erzeugung erfolgt dabei mit Hilfe des Zufallsgenerators fr GLEICHVERTEILTE
% Zufallszahlen und eines geeigneten Transformationsalgorithmus.
%
%
% Eingabeparameter: 		    N             Anzahl(>0) der Zufallspunkte 
%
%                               mu            Parameter der Poisson-Verteilung 
%
% Ausgabeparameter: 		    PoissZahlen   Erzeugte Zufallszahlen
%                                      					
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 7.03.2003


% Vorinitialisierungen

PoissZahlen = [];
                                 % Bereich abschtzen, in dem 99.99%
                                 % der Poisson-Werte fr diesen Parameter
                                 % liegen
M = poissinvB(0.9999,mu);
k = (0:1:M);                     % die mglichen (ganzzahligen) Werte
PoissVertFkt = poisscdfB(k, mu); % die Werte der Verteilungsfunktion
                                 % (=Einteilung F(y)-Achse)

rand('state',sum(100*clock));    % Zufallsgenerator initialisieren

for k=1:N                        % Zahl der Iterationen 
                                 % (Gleichverteilten) Zufallspunkt im Intervall 
                                 % [0,1] bestimmen
    x = rand(1,1);
                                 % Bereich von F(y) in dem x liegt 
                                 % feststellen
    oberh = find(x>=PoissVertFkt);  
      
    if isempty(oberh)
        y = 0;
    else
        y = oberh(end);          % Wert speichern
    end;
    PoissZahlen = [PoissZahlen; y];  
end;
