function [arithM] = ggzchin(n)
%
% Funktion ggzchin
%
% Aufruf:  [arithM] = ggzchin(n)
%
%
% Diese Funktion erzeugt n N(3,1)-verteilte Zufallszahlen und
% bestimmt das arithmetische Mittel dieser Zahlen.
%
% Die Funktion wird fr die Illustration des Chintchin'schen
% Satzes verwendet.
% 
%
% Eingabeparameter:    n         Anzahl der erzeugten Zufallszahlen (Experimente)
%
% Ausgabeparameter:    arithM    berechnetes arithmetisches Mittel
%
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 2.6.2004


randn('state',sum(100*clock));   % Zufallsgenerator neu
                                 % initialisieren
y = randn(1,n);                  % n standard-normalverteilte
                                 % Zufallszahlen erzeugen
x = (y + 3)/1;                   % transformieren in n N(3,1)-
                                 % verteilte Zufallszahlen
arithM = sum(x)/n;               % arithmetisches Mittel
                                 % zurckliefern
