function [erg] = istDrin(X,a,b,polygon)
%
% Funktion istDrin
%
% Aufruf:  [erg] = istDrin(X,a,b,polygon)
%
% Aufrufbeispiel:    [erg] = istDrin([0.5,0.5],1,1,polygon)
%
% Die vorliegende Funktion berechnet, ob der Punkt (x,y) INNERHALB oder
% AUSSERHALB des Polygons liegt, das durch den Polygonzug polygon 
% INNERHALB des Rechtecks definiert wird.
%
% Die Kanten des Polygonzuges mssen IM UHRZEIGERSINN durchlaufen werden.
% Die zkizzierte FLCHE MUSS KONVEX sein!
%
% Das Prinzip des Algorithmus beruht darauf, dass man fr alle Kanten des 
% Polygons berechnet, ob (x,y) RECHTS von dieser Kante liegt.
% Ist dies der Fall, so ist (x,y) INNERHALB des Polygons!
%
% An Ende wird 1 zurckgeliefert, wenn der Punkt (x,y) innerhalb liegt und
% 0, wenn er auerhalb liegt.
%
% Eingabeparameter: 		    a,b         Seitenlngen des Rechtecks (Werte > 0)
%
%                               ploygon     Polygonzug innerhalb des durch a,b bestimmten
%                                           Rechtecks
%
%                               X           Koordinaten des zu untersuchenden Punkts
%
% Ausgabeparameter: 		    erg         1, falls X innerhalb, 0, falls X auerhalb
%                                           des Polygons
%
%								
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 4.03.2003

if X(1)<0 | X(1)>a | X(2)<0 | X(2)>b
    error('Fehler: Punkt X liegt nicht im Rechteck [0,a]x[0,b]. Abbruch!');
end;

% Vorinitialisierungen

eps = 10^-10;
N = size(polygon,1);     % Zeilenzahl = Anzahl der Punkte
vorzeichen = [];

for k=1:N-1              % durchlaufe alle Kanten des Polygonzuges
    kante = polygon(k+1,:)-polygon(k,:);
                         % normiere den Richtungsvektor der Kante
    if norm(kante)>eps                     
        nkante = kante/norm(kante);
    else
        error('Fehler: Polygonzug enthlt Kante der Lnge~0! Abbruch!');
    end;
                         % Bestimme den Fusspunktvektor (von polygon(k,:) aus)
                         % fr das Lot von X auf die Kantenrichtung
    ptilde = ((X-polygon(k,:))*nkante')*nkante;
                         % Bestimme den negativen Lotvektor von X auf die Kantenrichtung
    lvekt = -(ptilde - (X-polygon(k,:)));
                         % normiere diesen Vektor
    if norm(lvekt)>eps
        nlvekt = lvekt/norm(lvekt);
    else
        nlvekt = 0*lvekt;
    end;
                         % berechne die 3. Komponente des Vektorprodukts von nlvekt mit nptilde
    if norm(ptilde)>eps  % (in Richtung der Kante!!)
        nptilde = sign((ptilde*nkante'))*ptilde/norm(ptilde);    
    else
        nptilde = 0*ptilde;
    end;
    vp = -nptilde(1)*nlvekt(2)+nlvekt(1)*nptilde(2);
                         % und prfe das Vorzeichen
    vorzeichen = [vorzeichen, vp>=0];
end;

                         % Punkt liegt im INNERN, falls er RECHTS von allen
                         % Kantenrichtungsvektoren liegt.
erg = all(vorzeichen==1);