function [polygon, axhndl] = polyput(a,b)
%
% Funktion polyput2
%
% Aufruf:  [polygon, axhndl] = polyput(a,b)
%
% Aufrufbeispiel:    [polygon, axhndl] = polyput(1,1)
%
% Die vorliegende Funktion erlaubt die INTERAKTIVE Erzeugung eines KONVEXEN Polygons 
% innerhalb eines Rechtecks der Seitenlngen a und b. Die Eckpunkte des Polygons
% werden dabei IM UHRZEIGERSINN mit der Maus durch Klick der LINKEN MAUSTASTE in 
% einer Grafik erzeugt.
% Der letzte Punkt wird mit der RECHTEN MAUSTASTE erzeut. Von diesem Punkt aus wird
% der Polygonzug automatisch geschlossen.
%
% An Ende wird das entstandene Polygon angezeigt und die Matrix der Eckpunkte
% wird an den Workspace zurckgeliefert.
%
% Punkte, die NICHT IM UHRZEIGERSINN gesetzt werden oder nicht
% zu einem KONVEXEN POLYGON fhren, werden bei der interaktiven
% Eingabe nicht akzeptiert.
%
% Eingabeparameter: 		    a,b         Seitenlngen des Rechtecks (Werte > 0)
%
%
% Ausgabeparameter: 		    polygon     der konstruierte Polygonzug
%
%                               axhndl      Axis-Handle des Plots
%
%								
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 23.08.2004


% Grafik mit Rechteck der genannten Gre aufmachen

axis([0 a 0 b])
hold on


% polygon und Message-Text initialisieren

polygon = [];
strg = ['Der Polygonzug muss im Uhrzeigersinn gezeichnet'; ...
           'werden und das Gebiet muss konvex sein!        ';...
           'Whlen Sie einen neuen Punkt!                  '];
strg2 = ['Es mssen mindestens 3 Punkte bei Bettigung';...
         'der rechten Maustaste (Ende) gesetzt sein!  '];

% Punkte markieren, bis rechte Maustaste gedrckt wird

[x,y,taste] = ginput(1);   % ersten Punkt setzen und markieren
plot(x,y,'ro');
polygon = [x,y];
kante1gesetzt = 0;         % Kante 1 wurde noch nicht gesetzt
noend = 1;                 % Schleifenende noch nicht erreicht

                           % es wird die linke Maustaste verwendet
while noend                % nchsten Punkt markieren
    [x,y,taste] = ginput(1);
    
 if taste~=1 & ~kante1gesetzt% rechte Maustaste wird gedrckt,
                           % bevor eine Kante erzeugt wurde
   uiwait(msgbox(strg2,'Hinweis','help','modal'));
 elseif taste==1 & ~kante1gesetzt% Linke Maustaste, aber noch keine erste Kante

                           % Winkel zur horizontalen berechnen
                           % Der Winkel wird dabei im Gegenuhrzeigersinn
                           % bezogen auf die Horizontale angegeben
        kante = [x-polygon(1,1), y-polygon(1,2)];
        w = complex(kante(1),kante(2));
                           % Winkel
        [Arg]= AngKomplex(w);
        Arg_old = Arg;     % ersten Winkel merken
        alpha = Arg;
        kante1gesetzt = 1; % Kante 1 wurde gesetzt
            
        plot(x,y,'ro');    % Verbindungslinie zeichnen
        hndl = line([polygon(end,1),x], [polygon(end,2),y]);
        set(hndl, 'Color', 'r', 'LineWidth', 2);
                           % in die Punktliste aufnehmen
        polygon = [polygon; [x,y]];
  elseif taste==1 & kante1gesetzt% Linke Maustaste und Kante 1 ist schon gesetzt
                           % weitere Kanten mssen untersucht werden
                           % Summenwinkel zur Horizontalen berechnen
                           % Der Winkel wird dabei im Gegenuhrzeigersinn
                           % bezogen auf die Horizontale angegeben
        summenkante = [x-polygon(1,1), y-polygon(1,2)];
        w = complex(summenkante(1),summenkante(2));
                           % Winkel
        [Arg]= AngKomplex(w);
        
        if Arg > Arg_old   % kein konvexes Gebiet bzw. kein Gegenuhrzeiger 
            uiwait(msgbox(strg,'Hinweis','help','modal'));
        else
                           % prfe,ob Gebiet konvex geschlossen werden kann
                           % dies geht, wenn der Summenwinkel den Ausgangs-
                           % winkel alpha der ersten Kante -pi nicht unterschreitet        
          if Arg < alpha-pi
            uiwait(msgbox(strg,'Hinweis','help','modal'));
          else             % akzeptiere den neuen Punkt
             plot(x,y,'ro');% Verbindungslinie zeichnen
             hndl = line([polygon(end,1),x], [polygon(end,2),y]);
             set(hndl, 'Color', 'r', 'LineWidth', 2);
                           % in die Punktliste aufnehmen
             polygon = [polygon; [x,y]];
             Arg_old = Arg;% Summenwinkel merken
          end         
        end
  else % der Fall taste~=1 & kante1gesetzt (Rechte Maustaste fr Ende)
                           % Prfung, ob Gebiet damit konvex geschlossen
                           % werden kann
        summenkante = [x-polygon(1,1), y-polygon(1,2)];
        w = complex(summenkante(1),summenkante(2));
                           % Winkel
        [Arg]= AngKomplex(w);
        
        if Arg < alpha-pi | Arg > Arg_old % kein konvexes Gebiet beim Schlieen 
            uiwait(msgbox(strg,'Hinweis','help','modal'));
        else               % ja, kann geschlossen werden
            plot(x,y,'ro');% Verbindungslinie zeichnen
            hndl = line([polygon(end,1),x], [polygon(end,2),y]);
            set(hndl, 'Color', 'r', 'LineWidth', 2);
                           % in die Punktliste aufnehmen
            polygon = [polygon; [x,y]];
                           % und raus aus der Schleife
            noend = 0;               
        end
  end;
end

                           % Polygonzug schlieen
polygon = [polygon; polygon(1,:)];


                           % Polygon mit Farbe fllen
patch(polygon(:,1), polygon(:,2), [1,1,0.6]);
                           % Rnder nachzeichnen
for k=1:length(polygon)-1
    hndl = line([polygon(k,1),polygon(k+1,1)],[polygon(k,2), polygon(k+1,2)]);
    set(hndl, 'Color', 'r', 'LineWidth', 3);
end;

hold off
axhndl = gca;
