% Script-File sumExpVertUebung.m
%
% Aufruf:   sumExpVertUebung
%
% bung zur Summenverteilung zweier unabhngiger Exponentialverteilungen
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.02
% Datum: 14.8.2004

% Sttzstellen fr die Verteilungsdichten im
% Zeitintervall [0, 10] (Beispiel)

dt = 0.1;
z = (0:dt:10);

% Erste Parameterkombination

lambda_1 = 1/4; lambda_2 = 3;

% Berechnung der Werte der Summenverteilungsdichte
% laut hergeleiteter exakter Formel

fakt = (lambda_1*lambda_2)/(lambda_2-lambda_1);
ExpVS1 = fakt*( exp(-lambda_1*z) - exp(-lambda_2*z) );

% Zweite Parameterkombination

lambda_1 = 1/4; lambda_2 = 1/3;

% Berechnung der Werte der Summenverteilungsdichte
% laut hergeleiteter exakter Formel

fakt = (lambda_1*lambda_2)/(lambda_2-lambda_1);
ExpVS2 = fakt*( exp(-lambda_1*z) - exp(-lambda_2*z) );


% Plot der Summenverteilungsdichten

plot(z, ExpVS1, 'r-', z, ExpVS2, 'b-','LineWidth', 4);
set(gca, 'FontSize', 12);
axis([0, 10, 0, max(max(ExpVS1),max(ExpVS2))]);
text(3, ExpVS1(3/dt)+0.005, '\lambda_1 = 1/4, \lambda_2 = 3');
text(6, ExpVS2(6/dt)+0.005, '\lambda_1 = 1/4, \lambda_2 = 1/3');
xlabel('x')
ylabel('f(x)')