function [vdichte] = triangpdf(x,a,b)
%
% Aufruf: [vdichte] = triangpdf(x,a,b)
%
% Berechnung der Verteilungsdichte der Dreiecksverteilung 
% im Intervall [a,b].
%
% Eingabeparameter:    x           Vektor von Werten, fr die die
%                                  Dichte berechnet werden soll
%
%                      a           untere Wertegrenze 
%
%                      b           obere Wertegrenze 
%
% Ausgabeparameter:    vdichte     Werte der Verteilungsdichte 
%
%
% Es werden sonst KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 21.3.2002


vdichte =   (4/(b-a)^2)*(x-a).*(x>=a & x<(a+b)/2) ...
          + (4/(b-a)^2)*(b-x).*((a+b)/2<=x & x<=b);






