function [anz, lngabs, lngrel, wlngen]= txtstat(datei)
%
% Funktion [anz, lngabs, lngrel, wlngen]= txtstat(datei)
%
% Aufruf:  [anz, lngabs, lngrel, wlngen]= txtstat(datei)
%
% Berechnet fr eine ASCII-Textdatei datei die Wortlngen der darin enthaltenen
% Worte (nur Buchstaben), zhlt sie und berechnet die relativen Hufigkeiten.
% Zahlen und Sonderzeichen werden ignoriert. 
% 
% Eingangsdaten:	  data      ASCII-Datei
%
% Ausgangsdaten:	  anz       Zahl der Worte
%			          lngabs    Matrix der Wortlngen; erste Zeile Wortlngen,
%                               zweite Zeile absolute Hufigkeiten
%			          lngrel    wie lngabs nur mit relativen Hufigkeiten
%
%                     wlngen    gemessene Wortlngen
%
%
% Es werden KEINE Fehleingaben abgefangen !!
% 		
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 14.9.2002

% Datei mit textread lesen und in cell array schreiben

file = textread(datei,'%s','delimiter',' \t\b\n\r','whitespace','');

% Hilfsvariablen initialisieren

anz = 0; wlngen = [];

% Satz- und Sonderzeichen entfernen 

N = length(file);

for k=1:N
    % Prfe, ob Grobuchstabe
    isgross = (file{k}>=64 & file{k}<=90);
    
    % Prfe, ob Kleinbuchstabe
    isklein = (file{k}>=97 & file{k}<=122);
    
    % Prfe, ob Zahl
    iszahl = (file{k}>=48 & file{k}<=57);
    
    % Prfe, ob deutscher Umlaut oder Sonderzeichen
    % anderer Sprachen
    
    isszeichen = (file{k}>=192 & file{k}<=255);
    
    % zulssige Zeichen
    istextzeichen = isgross|isklein|iszahl|isszeichen;
    
    % eliminiere nicht zulssige Zeichen
    file{k} = file{k}(istextzeichen);
    
    if ~isempty(file{k})
        anz = anz + 1;   % Wort zhlen
        wlngen = [wlngen, length(file{k})];
    end;
end;

% maximale Wortlnge ermitteln

mxwlng = max(wlngen);

% Histogramm berechnen

lngen = (1:1:mxwlng);
[N,X] = hist(wlngen, lngen);

% Ausgabevariablen berechnen

lngabs = [X;N];
lngrel = [X;N/anz];
