% Script-File Ueb1Anova1.m
%
% Aufruf:  Ueb1Anova1
%
% Beispiel zur EINFACHEN Varianzanalyse mit einem balancierten Versuchsplan. 
% Das Beispiel "Zugfestigkeit von Folien" entstammt dem Buch von E. Kreyszig.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 18.7.2003


% Definition der Werte der Zugfestigkeiten. Die untersuchte Einflussgre ist 
% die Messstelle. Die Zugfestigkeitswerte sind bezglich der Einflussgre
% SPALTENWEISE zu organisieren!
% 
% Untersuchtes Merkmal Zugstelle (Messstelle)  
%        Ecke   Mitte    Kante
 
zfw =    [137,   150,    142;...    % Folie 1
          142,   159,    140;...    % Folie 2
          128,   137,    133;...    % Folie 3
          137,   157,    141];      % Folie 4

% Durchfhrung einer Varianzanalyse mit der Funktion anova1

gruppen = cell(3,1);                   % Namen fr die untersuchten Gruppen
gruppen{1} = 'Ecke'; gruppen{2} = 'Mitte';
gruppen{3} = 'Kante';

% Aufruf der Funktion

[pWert, AnovTab, TestStatistik] = anova1B(zfw, gruppen)