% Script-File uebPaarTtest.m
%
% Aufruf:  uebPaarTtest
%
% bung zur EINFACHEN Varianzanalyse mit einem unbancierten Versuchsplan.
%
% Es soll der Unterschied zwischen dem ANOVA-Test zu einem Niveau alpha
% und dem PAARWEISEN t-Tests zum Niveau alpha untersucht werden.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 9.9.2003/12.9.2004

% Stichprobenwerte 
 
% Sprengstoff I:   
probe1 =    [ 13 9 15 5 25 15 3 9 6 12 ];

% Sprengstoff II:    
probe2 =    [ 22 24 21 19 17  ];

% Sprengstoff III:    
probe3 =    [ 8 24 9 18 9 24 12 4 ];

% Sprengstoff IV:    
probe4 =    [ 9 12 7 18 2 18 ];


alpha = 0.05;                       % Testniveau 95%

% Varianzanalyse zu Signifikanzniveau alpha durchfhren

indx = cumsum([length(probe1), length(probe2), ...
                             length(probe3), length(probe4)]);

Gr1 = repmat('Sprengstoff I', indx(1), 1); 
Gr2 = repmat('Sprengstoff II', indx(2)-indx(1), 1);   
Gr3 = repmat('Sprengstoff III', indx(3)-indx(2), 1);   
Gr4 = repmat('Sprengstoff IV', indx(4)-indx(3), 1);  
klassen = strvcat(Gr1,Gr2,Gr3,Gr4);
gruppe = cellstr(klassen);
      
% Neudefinition der Stichprobenwerte ALS VEKTOR fr die Funktion anova1     
      
probe = [probe1, probe2, probe3, probe4];      
      
% Aufruf der Funktion

[pWert, AnovTab, TestStatistik] = anova1B(probe, gruppe, 'off');
pWert
H = pWert<alpha             % Testentscheidung

% ACHTUNG: multcompare WIRD NICHT DURCHGEFHRT, da keine Ersatzfunktion existiert
%
% [vgl, mws] = multcompare(TestStatistik, alpha, 'off');
% vgl

% Paarweise zweiseitige t-Tests durchfhren

tail = 0;                           % zweiseitige Tests

% t-Test zum 95%-Niveau fr Sprengstoff I und II

[H12,p12,ci12,stats12] = ttest2B(probe1, probe2, alpha, tail);

% t-Test zum 95%-Niveau fr Sprengstoff I und III

[H13,p13,ci13,stats13] = ttest2B(probe1, probe3, alpha, tail);

% t-Test zum 95%-Niveau fr Sprengstoff I und IV

[H14,p14,ci14,stats14] = ttest2B(probe1, probe4, alpha, tail);

% t-Test zum 95%-Niveau fr Sprengstoff II und III

[H23,p23,ci23,stats23] = ttest2B(probe2, probe3, alpha, tail);

% t-Test zum 95%-Niveau fr Sprengstoff II und IV

[H24,p24,ci24,stats24] = ttest2B(probe2, probe4, alpha, tail);

% t-Test zum 95%-Niveau fr Sprengstoff III und IV

[H34,p34,ci34,stats34] = ttest2B(probe3, probe4, alpha, tail);

% Ergebnis zusammenstellen

Erg = [ [1,2], ci12(1), 0, ci12(2), H12,p12; ...
        [1,3], ci13(1), 0, ci13(2), H13,p13; ...
        [1,4], ci14(1), 0, ci14(2), H14,p14; ...
        [2,3], ci23(1), 0, ci23(2), H23,p23; ...
        [2,4], ci24(1), 0, ci24(2), H24,p24; ...
        [3,4], ci34(1), 0, ci34(2), H34,p34]



%
