% Script-File uebungHisto.m
%
% Aufruf:  uebungHisto
%
% bung zur Berechnung eines Histogramms
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 13.12.2002

% Stichprobe angeben

benzin = [10.1,10.6,10.9,10.0,10.4,10.5,9.7,10.5,...
          10.4,10.1,10.8,9.2 ,10.2,10.3,10.5,9.2,...
          10.2,10.5,9.4 ,10.2,9.6 ,10.2,9.7,10.2,...
          10.8,9.9 ,10.5,10.6,9.8 ,10.7,11.2,10.8,...
          9.0 ,10.0,10.5,10.4,11.4,10.4,10.1,10.4];

% Klassenmitten festsetzen

bins = [9.25, 9.75, 10.25, 10.75, 11.25];

% Absolute Klassenhufigkeiten mit hist bestimmen

[anz, x] = hist(benzin, bins);

% Relative Klassenhufigkeiten

relH = anz/length(benzin);

% Aufruf von distemp3

[emdist, cemdist]= distempStetig(benzin, bins, 1);