% Script-File uebungHisto2.m
%
% Aufruf:  uebungHisto2
%
% bung zur Berechnung eines Histogramms
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 13.12.2002

% Stichprobe angeben

nvwerte = [  -0.4326   -1.6656    0.1253    0.2877   -1.1465 ...
              1.1909    1.1892   -0.0376    0.3273    0.1746 ...
             -0.1867    0.7258   -0.5883    2.1832   -0.1364 ...
              0.1139    1.0668    0.0593   -0.0956   -0.8323];
% Klassenmitten festsetzen

bins = [-4 -2 0 2 4];

% Absolute Klassenhufigkeiten mit hist bestimmen

[anz, x] = hist(nvwerte, bins);

% Relative Klassenhufigkeiten

relH = anz/length(nvwerte);

% Grafische Darstellung

bar(x, relH, 0.8);