% Script-File uebungKennwerte.m
%
% Aufruf:  uebungKennwerte
%
% bung zur Berechnung empirischer Kennwerte
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 17.11.2002

% Stichprobe angeben

benzin = [10.1,10.6,10.9,10.0,10.4,10.5,9.7,10.5,...
          10.4,10.1,10.8,9.2 ,10.2,10.3,10.5,9.2,...
          10.2,10.5,9.4 ,10.2,9.6 ,10.2,9.7,10.2,...
          10.8,9.9 ,10.5,10.6,9.8 ,10.7,11.2,10.8,...
          9.0 ,10.0,10.5,10.4,11.4,10.4,10.1,10.4];

% Stichprobenmittel berechnen

m = mean(benzin);

% Standardabweichung berechnen

s = std(benzin);

% Modalwert berechnen

[N,x] = hist(benzin, sort(benzin));
[mx,i] = max(N);
modal = x(i);

% Medianwert berechnen

med = median(benzin);

% Wertebereich berechnen

wertebereich = range(benzin);

% mittlere absolute Abweichung berechnen

maw = mad(benzin);

% getrimmtes 10%-Mittel berechnen

gm = trimmean(benzin, 10);

% Ergebnisausgabe

fprintf('\n%s:\t %10.4f', 'Mittelwert               ', m);
fprintf('\n%s:\t %10.4f', 'Standardabweichung       ', s);
fprintf('\n%s:\t %10.4f', 'Varianz                  ', s^2);
fprintf('\n%s:\t %10.4f', 'Modalwert                ', modal);
fprintf('\n%s:\t %10.4f', 'Medianwert               ', med);
fprintf('\n%s:\t %10.4f', 'Wertebereich             ', wertebereich);
fprintf('\n%s:\t %10.4f', 'mittlere abs. Abweichung ', maw);
fprintf('\n%s:\t %10.4f', 'getrimmter 10%-Mittelwert', gm);

