% Script-File uebungSumNV.m
%
% Aufruf:  uebungSumNV
%
% bung zur Berechnung der Verteilungsdichte der Summe zweier
% unabhngiger normalverteilter Zufallsvariablen
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 5.9.2003

% Wertebereiche diskretisieren (4-Sigma-Grenzen)

delta_x = 0.01;
x = (-7:delta_x:8); y =(-4.657:delta_x:6.657);

% Werte der Dichte der normalverteilten Zufallsvariablen 
% berechnen

pdfX = normpdfB(x,1,sqrt(4));        % X ist N(1,4)-verteilt
pdfY = normpdfB(y,1,sqrt(2));        % X ist N(1,2)-verteilt

% Verteilung der Summenvariablen  (Diskretisierungsintervall
% beachten !!!)

z = (-7-4.657:delta_x:8+6.657);      % Wertebereich fr Faltung!
pdfS = delta_x*conv(pdfX,pdfY);
[pdfSmax,index]=max(pdfS);           % Dichtemaximum (fr Plot)
mxStelle = min(z)+delta_x*(index-1)  % Maximalstelle

% Verteilungsdichte der Summenvariablen plotten

plot(z, pdfS, 'r-', 'LineWidth',3);
set(gca, 'FontSize', 12);
xlabel ('Wertebereich')
ylabel('W-Dichte')
axis([min(z), max(z), 0, max(pdfS)])

