(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     71181,       1350]*)
(*NotebookOutlinePosition[     71942,       1377]*)
(*  CellTagsIndexPosition[     71898,       1373]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\( (*\(\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\)\(*\)***********) \)\(\[IndentingNewLine]\)\( (*\ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( \
(*\ Generalized\ Collocation\ \(Methods : 
          Solutions\ to\ Nonlinear\ Problems\)\ \
*) \)\(\[IndentingNewLine]\)\( (*\ Bellomo, \(\(N\)\(.\)\), 
      Lods, \(\(B\)\(.\)\), Revelli, \(\(R\)\(.\)\), 
      Ridolfi, \(\(L\)\(.\)\)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
*) \)\(\[IndentingNewLine]\)\( (*\ 
      A\ Birkh\[ADoubleDot]user\ book\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\
\[IndentingNewLine]\)\( (*\ 
      ISBN : 978 - 0 - 8176 - 4525 - 
          0\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ 
      Program\ EvolPatt\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\
\( (*******************************************************************) \)\)\
\)], "Input"],

Cell[BoxData[{
    \(\($TextStyle = {FontFamily -> "\<Times\>", 
          FontSize \[Rule] 12};\)\), "\[IndentingNewLine]", 
    \(Off[General::"\<spell\>", General::"\<spell1\>"]\)}], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{\(EvolPatt[BoundDataUX_, BoundDataVX_, BoundDataUY_, 
            BoundDataVY_, IniData_, NodesX_, NodesY_, TypeX_, TypeY_]\), ":=",
           "\[IndentingNewLine]", 
          RowBox[{"Module", "[", 
            
            RowBox[{\({}\), ",", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \( (*\(\(**\)\(\ \)\(INITIAL\)\)\ \
CONDITION\ ***) \), "\[IndentingNewLine]", "\[IndentingNewLine]", 
              
              RowBox[{\(\[CurlyPhi]U[x_, y_] := IniData[\([1]\)]\), ";", 
                "\[IndentingNewLine]", \(\[CurlyPhi]V[x_, y_] := 
                  IniData[\([2]\)]\), ";", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(hhX = 1\/\(NodesX - 1\)\), ";", 
                "\[IndentingNewLine]", \(hhY = 1\/\(NodesX - 1\)\), ";", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"Which", "[", 
                  
                  RowBox[{\(TypeX === Sinc\), 
                    ",", \(x1\_i_ := \((i - 1)\)*hhX\), 
                    ",", \(TypeX === Lagrange\), 
                    StyleBox[",",
                      FontColor->RGBColor[1, 0, 0]], 
                    
                    StyleBox[\(x1\_i_ := \(-\(1\/2. \)\) \((Cos[\((i - 
                                      1)\)*\[Pi]\/\(NodesX - 1\)] - 1)\)\),
                      FontColor->GrayLevel[0]]}], "]"}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"Which", "[", 
                  
                  RowBox[{\(TypeY === Sinc\), 
                    ",", \(y1\_i_ := \((i - 1)\)*hhY\), 
                    ",", \(TypeY === Lagrange\), 
                    StyleBox[",",
                      FontColor->RGBColor[1, 0, 0]], 
                    StyleBox[
                      RowBox[{
                        SubscriptBox[
                          StyleBox[
                            RowBox[{
                              StyleBox["y",
                                FontColor->GrayLevel[0]], "1"}]], "i_"], 
                        ":=", \(\(-\(1\/2. \)\) \((Cos[\((i - 
                                      1)\)*\[Pi]\/\(NodesY - 1\)] - 1)\)\)}],
                      FontColor->GrayLevel[0]]}], "]"}], ";", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                  RowBox[{\(TypeX === Lagrange\), ",", 
                    
                    StyleBox[\(LagrX[j_, 
                          x_] := \[Product]\+\(p = 1\)\%NodesX\((If[
                              p \[NotEqual] 
                                j, \(x - x1\_p\)\/\(x1\_j - x1\_p\), 1])\)\),
                      FontColor->GrayLevel[0]]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{"If", "[", 
                  RowBox[{\(TypeY === Lagrange\), ",", 
                    
                    StyleBox[\(LagrY[j_, 
                          y_] := \[Product]\+\(p = 1\)\%NodesY\((If[
                              p \[NotEqual] 
                                j, \(y - y1\_p\)\/\(y1\_j - y1\_p\), 1])\)\),
                      FontColor->GrayLevel[0]]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{"If", "[", 
                  RowBox[{\(TypeX === Sinc\), ",", 
                    
                    StyleBox[\(SincX[j_, x_] := 
                        Which[0 \[LessEqual] x \[LessEqual] 1\  && \ 
                            x \[NotEqual] \((j - 1)\)*hhX, 
                          Sin[\(\[Pi]*\((x - \((j - 1)\)*hhX)\)\)\/hhX]/\((\(\
\[Pi]*\((x - \((j - 1)\)*hhX)\)\)\/hhX)\), x == \((j - 1)\)*hhX, \ 1]\),
                      FontColor->GrayLevel[0]]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{"If", "[", 
                  RowBox[{\(TypeY === Sinc\), ",", 
                    StyleBox[\(SincY[j_, y_] := 
                        Which[0 \[LessEqual] y \[LessEqual] 1\  && \ 
                            y \[NotEqual] \((j - 1)\)*hhY, 
                          Sin[\(\[Pi]*\((y - \((j - 1)\)*hhY)\)\)\/hhY]/\((\(\
\[Pi]*\((y - \((j - 1)\)*hhY)\)\)\/hhY)\), y == \((j - 1)\)*hhY, \ 1]\),
                      FontColor->GrayLevel[0]]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{
                  StyleBox["If",
                    FontColor->GrayLevel[0]], 
                  StyleBox["[",
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    
                    StyleBox[\(TypeX === Lagrange\  && \ TypeY === Lagrange\),
                      
                      FontColor->GrayLevel[0]], 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    RowBox[{
                      RowBox[{\(InitValueU[x_, y_]\), ":=", 
                        RowBox[{\(\[Sum]\+\(m = 1\)\%NodesX\), 
                          RowBox[{
                            StyleBox[\(\[Sum]\+\(n = 1\)\%NodesY\),
                              FontColor->GrayLevel[0]], 
                            RowBox[{
                              StyleBox["(",
                                FontColor->GrayLevel[0]], 
                              RowBox[{
                                RowBox[{
                                  StyleBox["(",
                                    FontColor->GrayLevel[0]], 
                                  RowBox[{
                                    StyleBox[\(\[CurlyPhi]U[x, y]\),
                                      FontColor->GrayLevel[0]], 
                                    StyleBox["/.",
                                      FontColor->GrayLevel[0]], 
                                    RowBox[{
                                      StyleBox["{",
                                        FontColor->GrayLevel[0]], 
                                      RowBox[{
                                        StyleBox[\(x \[Rule] \ x1\_m\),
                                        FontColor->GrayLevel[0]], 
                                        StyleBox[",",
                                        FontColor->GrayLevel[0]], 
                                        RowBox[{
                                        StyleBox["y",
                                        FontColor->GrayLevel[0]], "\[Rule]", 
                                        " ", \(y1\_n\)}]}], "}"}]}], 
                                  StyleBox[")",
                                    FontColor->GrayLevel[0]]}], 
                                StyleBox["*",
                                  FontColor->GrayLevel[0]], 
                                StyleBox[\(LagrX[m, x]\),
                                  FontColor->GrayLevel[0]], 
                                StyleBox["*",
                                  FontColor->GrayLevel[0]], 
                                StyleBox[\(LagrY[n, y]\),
                                  FontColor->GrayLevel[0]]}], 
                              StyleBox[")",
                                FontColor->GrayLevel[0]]}]}]}]}], 
                      StyleBox[";",
                        FontColor->GrayLevel[0]], 
                      StyleBox["\[IndentingNewLine]",
                        FontColor->GrayLevel[0]], 
                      RowBox[{\(InitValueV[x_, y_]\), ":=", 
                        RowBox[{\(\[Sum]\+\(m = 1\)\%NodesX\), 
                          RowBox[{
                            StyleBox[\(\[Sum]\+\(n = 1\)\%NodesY\),
                              FontColor->GrayLevel[0]], 
                            RowBox[{
                              StyleBox["(",
                                FontColor->GrayLevel[0]], 
                              RowBox[{
                                RowBox[{
                                  StyleBox["(",
                                    FontColor->GrayLevel[0]], 
                                  RowBox[{
                                    StyleBox[\(\[CurlyPhi]V[x, y]\),
                                      FontColor->GrayLevel[0]], 
                                    StyleBox["/.",
                                      FontColor->GrayLevel[0]], 
                                    RowBox[{
                                      StyleBox["{",
                                        FontColor->GrayLevel[0]], 
                                      RowBox[{
                                        StyleBox[\(x \[Rule] \ x1\_m\),
                                        FontColor->GrayLevel[0]], 
                                        StyleBox[",",
                                        FontColor->GrayLevel[0]], 
                                        RowBox[{
                                        StyleBox["y",
                                        FontColor->GrayLevel[0]], "\[Rule]", 
                                        " ", \(y1\_n\)}]}], "}"}]}], 
                                  StyleBox[")",
                                    FontColor->GrayLevel[0]]}], 
                                StyleBox["*",
                                  FontColor->GrayLevel[0]], 
                                StyleBox[\(LagrX[m, x]\),
                                  FontColor->GrayLevel[0]], 
                                StyleBox["*",
                                  FontColor->GrayLevel[0]], 
                                StyleBox[\(LagrY[n, y]\),
                                  FontColor->GrayLevel[0]]}], 
                              StyleBox[")",
                                FontColor->GrayLevel[0]]}]}]}]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{
                  StyleBox["If",
                    FontColor->GrayLevel[0]], 
                  StyleBox["[",
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    StyleBox[\(TypeX === Lagrange\  && \ TypeY === Sinc\),
                      FontColor->GrayLevel[0]], 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    RowBox[{\(InitValue[x_, y_]\), ":=", 
                      RowBox[{\(\[Sum]\+\(m = 1\)\%NodesX\), 
                        RowBox[{
                          StyleBox[\(\[Sum]\+\(n = 1\)\%NodesY\),
                            FontColor->GrayLevel[0]], 
                          RowBox[{
                            StyleBox["(",
                              FontColor->GrayLevel[0]], 
                            RowBox[{
                              RowBox[{
                                StyleBox["(",
                                  FontColor->GrayLevel[0]], 
                                RowBox[{
                                  StyleBox[\(\[CurlyPhi][x, y]\),
                                    FontColor->GrayLevel[0]], 
                                  StyleBox["/.",
                                    FontColor->GrayLevel[0]], 
                                  RowBox[{
                                    StyleBox["{",
                                      FontColor->GrayLevel[0]], 
                                    RowBox[{
                                      StyleBox[\(x \[Rule] \ x1\_m\),
                                        FontColor->GrayLevel[0]], 
                                      StyleBox[",",
                                        FontColor->GrayLevel[0]], 
                                      RowBox[{
                                        StyleBox["y",
                                        FontColor->GrayLevel[0]], "\[Rule]", 
                                        " ", \(y1\_n\)}]}], "}"}]}], 
                                StyleBox[")",
                                  FontColor->GrayLevel[0]]}], 
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(LagrX[m, x]\),
                                FontColor->GrayLevel[0]], 
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(SincY[n, y]\),
                                FontColor->GrayLevel[0]]}], 
                            StyleBox[")",
                              FontColor->GrayLevel[0]]}]}]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{
                  StyleBox["If",
                    FontColor->GrayLevel[0]], 
                  StyleBox["[",
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    StyleBox[\(TypeX === Sinc\  && \ TypeY === Lagrange\),
                      FontColor->GrayLevel[0]], 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    RowBox[{\(InitValue[x_, y_]\), ":=", 
                      RowBox[{\(\[Sum]\+\(m = 1\)\%NodesX\), 
                        RowBox[{
                          StyleBox[\(\[Sum]\+\(n = 1\)\%NodesY\),
                            FontColor->GrayLevel[0]], 
                          RowBox[{
                            StyleBox["(",
                              FontColor->GrayLevel[0]], 
                            RowBox[{
                              RowBox[{
                                StyleBox["(",
                                  FontColor->GrayLevel[0]], 
                                RowBox[{
                                  StyleBox[\(\[CurlyPhi][x, y]\),
                                    FontColor->GrayLevel[0]], 
                                  StyleBox["/.",
                                    FontColor->GrayLevel[0]], 
                                  RowBox[{
                                    StyleBox["{",
                                      FontColor->GrayLevel[0]], 
                                    RowBox[{
                                      StyleBox[\(x \[Rule] \ x1\_m\),
                                        FontColor->GrayLevel[0]], 
                                      StyleBox[",",
                                        FontColor->GrayLevel[0]], 
                                      RowBox[{
                                        StyleBox["y",
                                        FontColor->GrayLevel[0]], "\[Rule]", 
                                        " ", \(y1\_n\)}]}], "}"}]}], 
                                StyleBox[")",
                                  FontColor->GrayLevel[0]]}], 
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(SincX[m, x]\),
                                FontColor->GrayLevel[0]], 
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(LagrY[n, y]\),
                                FontColor->GrayLevel[0]]}], 
                            StyleBox[")",
                              FontColor->GrayLevel[0]]}]}]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{
                  StyleBox["If",
                    FontColor->GrayLevel[0]], 
                  StyleBox["[",
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    StyleBox[\(TypeX === Sinc\  && \ TypeY === Sinc\),
                      FontColor->GrayLevel[0]], 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    RowBox[{
                      RowBox[{\(InitValueU[x_, y_]\), ":=", 
                        RowBox[{\(\[Sum]\+\(m = 1\)\%NodesX\), 
                          RowBox[{
                            StyleBox[\(\[Sum]\+\(n = 1\)\%NodesY\),
                              FontColor->GrayLevel[0]], 
                            RowBox[{
                              StyleBox["(",
                                FontColor->GrayLevel[0]], 
                              RowBox[{
                                RowBox[{
                                  StyleBox["(",
                                    FontColor->GrayLevel[0]], 
                                  RowBox[{
                                    StyleBox[\(\[CurlyPhi]U[x, y]\),
                                      FontColor->GrayLevel[0]], 
                                    StyleBox["/.",
                                      FontColor->GrayLevel[0]], 
                                    RowBox[{
                                      StyleBox["{",
                                        FontColor->GrayLevel[0]], 
                                      RowBox[{
                                        StyleBox[\(x \[Rule] \ x1\_m\),
                                        FontColor->GrayLevel[0]], 
                                        StyleBox[",",
                                        FontColor->GrayLevel[0]], 
                                        RowBox[{
                                        StyleBox["y",
                                        FontColor->GrayLevel[0]], "\[Rule]", 
                                        " ", \(y1\_n\)}]}], "}"}]}], 
                                  StyleBox[")",
                                    FontColor->GrayLevel[0]]}], 
                                StyleBox["*",
                                  FontColor->GrayLevel[0]], 
                                StyleBox[\(SincX[m, x]\),
                                  FontColor->GrayLevel[0]], 
                                StyleBox["*",
                                  FontColor->GrayLevel[0]], 
                                StyleBox[\(SincY[n, y]\),
                                  FontColor->GrayLevel[0]]}], 
                              StyleBox[")",
                                FontColor->GrayLevel[0]]}]}]}]}], 
                      StyleBox[";",
                        FontColor->GrayLevel[0]], 
                      RowBox[{\(InitValueV[x_, y_]\), ":=", 
                        RowBox[{\(\[Sum]\+\(m = 1\)\%NodesX\), 
                          RowBox[{
                            StyleBox[\(\[Sum]\+\(n = 1\)\%NodesY\),
                              FontColor->GrayLevel[0]], 
                            RowBox[{
                              StyleBox["(",
                                FontColor->GrayLevel[0]], 
                              RowBox[{
                                RowBox[{
                                  StyleBox["(",
                                    FontColor->GrayLevel[0]], 
                                  RowBox[{
                                    StyleBox[\(\[CurlyPhi]V[x, y]\),
                                      FontColor->GrayLevel[0]], 
                                    StyleBox["/.",
                                      FontColor->GrayLevel[0]], 
                                    RowBox[{
                                      StyleBox["{",
                                        FontColor->GrayLevel[0]], 
                                      RowBox[{
                                        StyleBox[\(x \[Rule] \ x1\_m\),
                                        FontColor->GrayLevel[0]], 
                                        StyleBox[",",
                                        FontColor->GrayLevel[0]], 
                                        RowBox[{
                                        StyleBox["y",
                                        FontColor->GrayLevel[0]], "\[Rule]", 
                                        " ", \(y1\_n\)}]}], "}"}]}], 
                                  StyleBox[")",
                                    FontColor->GrayLevel[0]]}], 
                                StyleBox["*",
                                  FontColor->GrayLevel[0]], 
                                StyleBox[\(SincX[m, x]\),
                                  FontColor->GrayLevel[0]], 
                                StyleBox["*",
                                  FontColor->GrayLevel[0]], 
                                StyleBox[\(SincY[n, y]\),
                                  FontColor->GrayLevel[0]]}], 
                              StyleBox[")",
                                FontColor->GrayLevel[0]]}]}]}]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\t",
                  FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
                StyleBox["\t",
                  FontColor->GrayLevel[0]], 
                "\[IndentingNewLine]", \(Print["\<Initial condition \
interpolation:\>"]\), ";", 
                "\[IndentingNewLine]", \(Plot3D[
                  Evaluate[InitValueU[x, y]], {x, 0, 1}, {y, 0, 1}, 
                  PlotRange \[Rule] All, AxesLabel \[Rule] {x, y, u}]\), ";", 
                "\[IndentingNewLine]", \(Plot3D[
                  Evaluate[InitValueV[x, y]], {x, 0, 1}, {y, 0, 1}, 
                  PlotRange \[Rule] {Automatic, Automatic, {0, 2}}, 
                  AxesLabel \[Rule] {x, y, v}]\), ";", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Print["\<Don't worry! I'm \
working\>"]\), ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{
                  StyleBox["(*",
                    FontColor->GrayLevel[0]], 
                  StyleBox[\(\(\(**\)\(\ \)\(Derivative\)\)\ Matrices\)], 
                  StyleBox[" "], 
                  StyleBox["***)"]}], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[0, 0, 1]], \(If[
                  TypeX === Lagrange, \[IndentingNewLine]FDMX[j_, i_] := 
                    Which[i == 
                        j, \[Sum]\+\(k = 1\)\%NodesX If[k == i, 0, 
                          1\/\(x1\_i - x1\_k\)], 
                      i != j, \(\[Product]\+\(p = 1\)\%NodesX\((If[p \[Equal] \
i, 1, x1\_i - x1\_p])\)\)\/\(\((x1\_i - x1\_j)\) \(\[Product]\+\(p = \
1\)\%NodesX\((If[p \[Equal] j, 1, x1\_j - x1\_p])\)\)\)]; \
\[IndentingNewLine]FirstDerX = 
                    Table[FDMX[j, i], {j, 1, NodesX}, {i, 1, 
                        NodesX}]; \[IndentingNewLine]SecondDerX = 
                    Table[If[i \[NotEqual] j, 
                        2 \((FirstDerX[\([j, i]\)]*FirstDerX[\([i, i]\)] - 
                              FirstDerX[\([j, i]\)]\/\(x1\_i - x1\_j\))\), 
                        0], {j, 1, NodesX}, {i, 1, 
                        NodesX}]; \[IndentingNewLine]Do[
                    SecondDerX[\([i, 
                          i]\)] = \(-\(\[Sum]\+\(k = 1\)\%NodesX 
                            SecondDerX[\([k, i]\)]\)\), {i, 1, NodesX}]]\), 
                ";", 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[0, 0, 1]], \(If[
                  TypeY === Lagrange, \[IndentingNewLine]FDMY[j_, i_] := 
                    Which[i == 
                        j, \[Sum]\+\(k = 1\)\%NodesY If[k == i, 0, 
                          1\/\(y1\_i - y1\_k\)], 
                      i != j, \(\[Product]\+\(p = 1\)\%NodesY\((If[p \[Equal] \
i, 1, y1\_i - y1\_p])\)\)\/\(\((y1\_i - y1\_j)\) \(\[Product]\+\(p = \
1\)\%NodesY\((If[p \[Equal] j, 1, y1\_j - y1\_p])\)\)\)]; \
\[IndentingNewLine]FirstDerY = 
                    Table[FDMY[j, i], {j, 1, NodesY}, {i, 1, 
                        NodesY}]; \[IndentingNewLine]SecondDerY = 
                    Table[If[i \[NotEqual] j, 
                        2 \((FirstDerY[\([j, i]\)]*FirstDerY[\([i, i]\)] - 
                              FirstDerY[\([j, i]\)]\/\(y1\_i - y1\_j\))\), 
                        0], {j, 1, NodesY}, {i, 1, 
                        NodesY}]; \[IndentingNewLine]Do[
                    SecondDerY[\([i, 
                          i]\)] = \(-\(\[Sum]\+\(k = 1\)\%NodesY 
                            SecondDerY[\([k, i]\)]\)\), {i, 1, NodesY}]]\), 
                ";", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(If[
                  TypeX === Sinc, \[IndentingNewLine]FDMX[j_, i_] := 
                    Which[i != 
                        j, \((\(-1\))\)\^\(i - j\)\/\(hhX*\((i - j)\)\), 
                      i == j, 0]; \[IndentingNewLine]SDMX[j_, i_] := 
                    Which[i != 
                        j, \(2*\((\(-1\))\)\^\(i - j + 1\)\)\/\(hhX\^2*\((i - \
j)\)\^2\), i == j, \(-\(\[Pi]\^2\/\(3*
                              hhX\^2\)\)\)]; \[IndentingNewLine]\
\[IndentingNewLine]FirstDerX = 
                    Table[FDMX[j, i], {j, 1, NodesX}, {i, 1, 
                        NodesX}]; \[IndentingNewLine]SecondDerX = 
                    Table[SDMX[j, i], {j, 1, NodesX}, {i, 1, NodesX}]]\), ";",
                 "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(If[
                  TypeY === Sinc, \[IndentingNewLine]FDMY[j_, i_] := 
                    Which[i != 
                        j, \((\(-1\))\)\^\(i - j\)\/\(hhY*\((i - j)\)\), 
                      i == j, 0]; \[IndentingNewLine]SDMY[j_, i_] := 
                    Which[i != 
                        j, \(2*\((\(-1\))\)\^\(i - j + 1\)\)\/\(hhY\^2*\((i - \
j)\)\^2\), i == j, \(-\(\[Pi]\^2\/\(3*
                              hhY\^2\)\)\)]; \[IndentingNewLine]FirstDerY = 
                    Table[FDMY[j, i], {j, 1, NodesY}, {i, 1, 
                        NodesY}]; \[IndentingNewLine]SecondDerY = 
                    Table[SDMY[j, i], {j, 1, NodesY}, {i, 1, NodesY}]]\), ";",
                 "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \( (*\(\(**\)\(\ \)\(Nodal\)\)\ \
Equations\ ***) \), "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{\(NdEqU[i_, j_]\), ":=", " ", 
                  RowBox[{
                    RowBox[{\(\(CU\_\(i, j\)'\)[t]\), "==", 
                      RowBox[{"TT", 
                        RowBox[{"(", 
                          RowBox[{
                            RowBox[{"D1", 
                              RowBox[{"(", 
                                RowBox[{
                                  RowBox[{"(", 
                                    RowBox[{\(\[Sum]\+\(k = 1\)\%NodesX\), 
                                      
                                      RowBox[{\(SecondDerX[\([k, i]\)]\), "*",
                                         
                                        RowBox[{
                                        StyleBox[
                                        SubscriptBox[
                                        StyleBox[
                                        RowBox[{
                                        StyleBox["C",
                                        FontColor->GrayLevel[0]], 
                                        "U"}]], \(k, j\)],
                                        FontColor->GrayLevel[0]], "[", "t", 
                                        "]"}]}]}], ")"}], 
                                  "+", \((\[Sum]\+\(k = 1\)\%NodesY 
                                        SecondDerY[\([k, j]\)]*
                                        CU\_\(i, k\)[t])\)}], ")"}]}], 
                            "+", \(\[Kappa] \((a - CU\_\(i, j\)[t] + 
                                  CU\_\(i, j\)[t]\^2*CV\_\(i, j\)[t])\)\)}], 
                          ")"}]}]}], 
                    "/.", \({x -> \ x1\_i, y -> \ y1\_j}\)}]}], ";", 
                "\[IndentingNewLine]", \(NdEqV[i_, 
                    j_] := \ \(CV\_\(i, j\)'\)[t] == 
                      TT \((D2 \((\((\[Sum]\+\(k = 1\)\%NodesX 
                                        SecondDerX[\([k, i]\)]*
                                        CV\_\(k, j\)[
                                        t])\) + \((\[Sum]\+\(k = 1\)\%NodesY 
                                        SecondDerY[\([k, j]\)]*
                                        CV\_\(i, k\)[
                                        t])\))\) + \[Kappa]*\((b - 
                                  CU\_\(i, j\)[t]\^2*
                                    CV\_\(i, j\)[t])\))\) /. {x -> \ x1\_i, 
                      y -> \ y1\_j}\), ";", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \( (*\(\(**\)\(\ \)\(Neumann\)\)\ \
Condition\ Calculus\ ***) \), "\[IndentingNewLine]", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Do[{aa, 
                      bb} = {FirstDerX[\([1, 1]\)], 
                      FirstDerX[\([NodesX, 1]\)]}; \[IndentingNewLine]{dd, 
                      ee} = {FirstDerX[\([1, NodesX]\)], 
                      FirstDerX[\([NodesX, 
                          NodesX]\)]}; \[IndentingNewLine]{cc, 
                      ff} = {\((\[Sum]\+\(k = 2\)\%\(NodesX - \
1\)FirstDerX[\([k, 1]\)]*CU\_\(k, j\)[
                              t])\), \((\[Sum]\+\(k = 2\)\%\(NodesX - \
1\)FirstDerX[\([k, NodesX]\)]*CU\_\(k, j\)[t])\)}; \[IndentingNewLine]{gg, 
                      hh} = {BoundDataUX[\([1]\)], 
                      BoundDataUX[\([2]\)]}; \[IndentingNewLine]\
\[IndentingNewLine]u\_\(1, j\) = 
                    Simplify[\(cc*ee - bb*ff - ee*gg + bb*hh\)\/\(bb*dd - \
aa*ee\)]; \[IndentingNewLine]u\_\(NodesX, j\) = 
                    Simplify[\(-\(\(cc*dd - aa*ff - dd*gg + 
                              aa*hh\)\/\(bb*dd - 
                              aa*ee\)\)\)], \[IndentingNewLine]{j, 1, 
                    NodesY}]\), ";", 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[1, 0, 0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[1, 0, 
                  0]], \(Do[{aa, bb} = {FirstDerY[\([1, 1]\)], 
                      FirstDerY[\([NodesY, 1]\)]}; \[IndentingNewLine]{dd, 
                      ee} = {FirstDerY[\([1, NodesY]\)], 
                      FirstDerY[\([NodesY, 
                          NodesY]\)]}; \[IndentingNewLine]{cc, 
                      ff} = {\((\[Sum]\+\(k = 2\)\%\(NodesY - \
1\)FirstDerY[\([k, 1]\)]*CU\_\(i, k\)[
                              t])\), \((\[Sum]\+\(k = 2\)\%\(NodesY - \
1\)FirstDerY[\([k, NodesY]\)]*CU\_\(i, k\)[t])\)}; \[IndentingNewLine]{gg, 
                      hh} = {BoundDataUY[\([1]\)], 
                      BoundDataUY[\([2]\)]}; \[IndentingNewLine]\
\[IndentingNewLine]u\_\(i, 1\) = 
                    Simplify[\(cc*ee - bb*ff - ee*gg + bb*hh\)\/\(bb*dd - \
aa*ee\)]; \[IndentingNewLine]u\_\(i, NodesY\) = 
                    Simplify[\(-\(\(cc*dd - aa*ff - dd*gg + 
                              aa*hh\)\/\(bb*dd - 
                              aa*ee\)\)\)], \[IndentingNewLine]{i, 2, 
                    NodesX - 1}]\), ";", 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[1, 0, 0]], 
                "\[IndentingNewLine]", \(Do[{aa, 
                      bb} = {FirstDerX[\([1, 1]\)], 
                      FirstDerX[\([NodesX, 1]\)]}; \[IndentingNewLine]{dd, 
                      ee} = {FirstDerX[\([1, NodesX]\)], 
                      FirstDerX[\([NodesX, 
                          NodesX]\)]}; \[IndentingNewLine]{cc, 
                      ff} = {\((\[Sum]\+\(k = 2\)\%\(NodesX - \
1\)FirstDerX[\([k, 1]\)]*CV\_\(k, j\)[
                              t])\), \((\[Sum]\+\(k = 2\)\%\(NodesX - \
1\)FirstDerX[\([k, NodesX]\)]*CV\_\(k, j\)[t])\)}; \[IndentingNewLine]{gg, 
                      hh} = {BoundDataVX[\([1]\)], 
                      BoundDataVX[\([2]\)]}; \[IndentingNewLine]\
\[IndentingNewLine]v\_\(1, j\) = 
                    Simplify[\(cc*ee - bb*ff - ee*gg + bb*hh\)\/\(bb*dd - \
aa*ee\)]; \[IndentingNewLine]v\_\(NodesX, j\) = 
                    Simplify[\(-\(\(cc*dd - aa*ff - dd*gg + 
                              aa*hh\)\/\(bb*dd - 
                              aa*ee\)\)\)], \[IndentingNewLine]{j, 1, 
                    NodesY}]\), ";", 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[1, 0, 0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[1, 0, 
                  0]], \(Do[{aa, bb} = {FirstDerY[\([1, 1]\)], 
                      FirstDerY[\([NodesY, 1]\)]}; \[IndentingNewLine]{dd, 
                      ee} = {FirstDerY[\([1, NodesY]\)], 
                      FirstDerY[\([NodesY, 
                          NodesY]\)]}; \[IndentingNewLine]{cc, 
                      ff} = {\((\[Sum]\+\(k = 2\)\%\(NodesY - \
1\)FirstDerY[\([k, 1]\)]*CV\_\(i, k\)[
                              t])\), \((\[Sum]\+\(k = 2\)\%\(NodesY - \
1\)FirstDerY[\([k, NodesY]\)]*CV\_\(i, k\)[t])\)}; \[IndentingNewLine]{gg, 
                      hh} = {BoundDataVY[\([1]\)], 
                      BoundDataVY[\([2]\)]}; \[IndentingNewLine]\
\[IndentingNewLine]v\_\(i, 1\) = 
                    Simplify[\(cc*ee - bb*ff - ee*gg + bb*hh\)\/\(bb*dd - \
aa*ee\)]; \[IndentingNewLine]v\_\(i, NodesY\) = 
                    Simplify[\(-\(\(cc*dd - aa*ff - dd*gg + 
                              aa*hh\)\/\(bb*dd - 
                              aa*ee\)\)\)], \[IndentingNewLine]{i, 2, 
                    NodesX - 1}]\), ";", 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[1, 0, 0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[1, 0, 0]], \(cond1U = 
                  Table[{CU\_\(1, j\)[t] \[Rule] u\_\(1, j\)}, {j, 1, 
                      NodesY}]\), ";", 
                "\[IndentingNewLine]", \(cond2U = 
                  Table[{CU\_\(NodesX, j\)[t] \[Rule] u\_\(NodesX, j\)}, {j, 
                      1, NodesY}]\), ";", "\[IndentingNewLine]", 
                RowBox[{"cond3U", "=", 
                  RowBox[{"Table", "[", 
                    RowBox[{
                      RowBox[{"{", 
                        RowBox[{
                          RowBox[{
                            StyleBox[
                              SubscriptBox[
                                StyleBox[
                                  RowBox[{
                                    StyleBox["C",
                                      FontColor->GrayLevel[0]], "U"}]], \(i, 
                                1\)],
                              FontColor->GrayLevel[0]], "[", "t", "]"}], 
                          "\[Rule]", \(u\_\(i, 1\)\)}], "}"}], 
                      ",", \({i, 2, NodesX - 1}\)}], "]"}]}], ";", 
                "\[IndentingNewLine]", \(cond4U = 
                  Table[{CU\_\(i, NodesY\)[t] \[Rule] u\_\(i, NodesY\)}, {i, 
                      2, NodesX - 1}]\), ";", 
                "\[IndentingNewLine]", \(condTabU = 
                  Flatten[Join[cond1U, cond2U, cond3U, cond4U]]\), ";", 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[1, 0, 0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[1, 0, 0]], \(cond1V = 
                  Table[{CV\_\(1, j\)[t] \[Rule] v\_\(1, j\)}, {j, 1, 
                      NodesY}]\), ";", 
                "\[IndentingNewLine]", \(cond2V = 
                  Table[{CV\_\(NodesX, j\)[t] \[Rule] v\_\(NodesX, j\)}, {j, 
                      1, NodesY}]\), ";", 
                "\[IndentingNewLine]", \(cond3V = 
                  Table[{CV\_\(i, 1\)[t] \[Rule] v\_\(i, 1\)}, {i, 2, 
                      NodesX - 1}]\), ";", 
                "\[IndentingNewLine]", \(cond4V = 
                  Table[{CV\_\(i, NodesY\)[t] \[Rule] v\_\(i, NodesY\)}, {i, 
                      2, NodesX - 1}]\), ";", 
                "\[IndentingNewLine]", \(condTabV = 
                  Flatten[Join[cond1V, cond2V, cond3V, cond4V]]\), ";", 
                "\[IndentingNewLine]", 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[1, 0, 0]], \(EqsSysU = 
                  Flatten[
                    Table[{NdEqU[i, j] /. condTabU, 
                        CU\_\(i, j\)[
                            0] == \((\[CurlyPhi]U[x, 
                                y] /. {x \[Rule] \ x1\_i, 
                                y \[Rule] \ y1\_j})\)}, {i, 2, 
                        NodesX - 1}, {j, 2, NodesY - 1}]]\), ";", 
                "\[IndentingNewLine]", \(EqsSysV = 
                  Flatten[
                    Table[{NdEqV[i, j] /. condTabV, 
                        CV\_\(i, j\)[
                            0] == \((\[CurlyPhi]V[x, 
                                y] /. {x \[Rule] \ x1\_i, 
                                y \[Rule] \ y1\_j})\)}, {i, 2, 
                        NodesX - 1}, {j, 2, NodesY - 1}]]\), ";", 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[1, 0, 0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[1, 0, 0]], \(NdEqsSys = 
                  Flatten[Join[EqsSysU, EqsSysV]]\), ";", 
                "\[IndentingNewLine]", \(UnKnown = 
                  Flatten[
                    Join[Table[
                        CU\_\(i, j\), {i, 2, NodesX - 1}, {j, 2, 
                          NodesY - 1}], 
                      Table[CV\_\(i, j\), {i, 2, NodesX - 1}, {j, 2, 
                          NodesY - 1}]]]\), ";", 
                "\[IndentingNewLine]", \(NumSol = 
                  NDSolve[NdEqsSys, UnKnown, {t, 0, 1}, \ 
                      MaxSteps \[Rule] 10000000] // Flatten\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \( (*\(**\)\(\ \)\(Solution\)\ ***) \),
                 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[0, 0, 1]], \(aaa = 
                  Partition[NumSol, NodesY - 2]\), ";", "\[IndentingNewLine]",
                 
                RowBox[{
                  StyleBox["If",
                    FontColor->GrayLevel[0]], 
                  StyleBox["[",
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    
                    StyleBox[\(TypeX === Lagrange\  && \ TypeY === Lagrange\),
                      
                      FontColor->GrayLevel[0]], 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    RowBox[{
                      RowBox[{
                        StyleBox["TotSolU",
                          FontColor->GrayLevel[0]], "[", \(x_, y_, t_\), 
                        "]"}], ":=", 
                      RowBox[{
                        RowBox[{
                          RowBox[{
                            RowBox[{\(\[Sum]\+\(m = 1\)\%\(NodesX - 2\)\), 
                              RowBox[{
                                
                                StyleBox[\(\[Sum]\+\(n = 1\)\%\(NodesY - 
                                        2\)\),
                                  FontColor->GrayLevel[0]], 
                                RowBox[{
                                  StyleBox["(",
                                    FontColor->GrayLevel[0]], 
                                  RowBox[{
                                    RowBox[{
                                      RowBox[{
                                        StyleBox["aaa",
                                        FontColor->GrayLevel[0]], 
                                        "[", \([m, n, 2]\), "]"}], "[", "t", 
                                      "]"}], 
                                    StyleBox["*",
                                      FontColor->GrayLevel[0]], 
                                    StyleBox[\(LagrX[m + 1, x]\),
                                      FontColor->GrayLevel[0]], 
                                    StyleBox["*",
                                      FontColor->GrayLevel[0]], 
                                    StyleBox[\(LagrY[n + 1, y]\),
                                      FontColor->GrayLevel[0]]}], 
                                  StyleBox[")",
                                    FontColor->GrayLevel[0]]}]}]}], "+", 
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{\(\[Sum]\+\(j = 1\)\%NodesY\), 
                                  RowBox[{"(", 
                                    RowBox[{\(u\_\(1, j\)\), "*", 
                                      StyleBox[\(LagrX[1, x]\),
                                        FontColor->GrayLevel[0]], 
                                      StyleBox["*",
                                        FontColor->GrayLevel[0]], 
                                      StyleBox[\(LagrY[j, y]\),
                                        FontColor->GrayLevel[0]]}], 
                                    StyleBox[")",
                                      FontColor->GrayLevel[0]]}]}], 
                                StyleBox["+",
                                  FontColor->GrayLevel[0]], 
                                RowBox[{\(\[Sum]\+\(j = 1\)\%NodesY\), 
                                  RowBox[{"(", 
                                    RowBox[{\(u\_\(NodesX, j\)\), "*", 
                                      StyleBox[\(LagrX[NodesX, x]\),
                                        FontColor->GrayLevel[0]], 
                                      StyleBox["*",
                                        FontColor->GrayLevel[0]], 
                                      StyleBox[\(LagrY[j, y]\),
                                        FontColor->GrayLevel[0]]}], 
                                    StyleBox[")",
                                      FontColor->GrayLevel[0]]}]}], 
                                StyleBox["+",
                                  FontColor->GrayLevel[0]], 
                                
                                RowBox[{\(\[Sum]\+\(i = 2\)\%\(NodesX - 1\)\),
                                   
                                  RowBox[{"(", 
                                    RowBox[{\(u\_\(i, 1\)\), "*", 
                                      StyleBox[\(LagrX[i, x]\),
                                        FontColor->GrayLevel[0]], 
                                      StyleBox["*",
                                        FontColor->GrayLevel[0]], 
                                      StyleBox[\(LagrY[1, y]\),
                                        FontColor->GrayLevel[0]]}], 
                                    StyleBox[")",
                                      FontColor->GrayLevel[0]]}]}], 
                                StyleBox["+",
                                  FontColor->GrayLevel[0]], 
                                
                                RowBox[{\(\[Sum]\+\(i = 2\)\%\(NodesX - 1\)\),
                                   
                                  RowBox[{"(", 
                                    RowBox[{\(u\_\(i, NodesY\)\), "*", 
                                      StyleBox[\(LagrX[i, x]\),
                                        FontColor->GrayLevel[0]], 
                                      StyleBox["*",
                                        FontColor->GrayLevel[0]], 
                                      StyleBox[\(LagrY[NodesY, y]\),
                                        FontColor->GrayLevel[0]]}], 
                                    StyleBox[")",
                                      FontColor->GrayLevel[0]]}]}]}], 
                              StyleBox[")",
                                FontColor->GrayLevel[0]]}]}], 
                          StyleBox["/.",
                            FontColor->GrayLevel[0]], 
                          StyleBox["condTabU",
                            FontColor->GrayLevel[0]]}], 
                        StyleBox["/.",
                          FontColor->GrayLevel[0]], 
                        StyleBox["NumSol",
                          FontColor->GrayLevel[0]]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{
                  StyleBox["If",
                    FontColor->GrayLevel[0]], 
                  StyleBox["[",
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    StyleBox[\(TypeX === Lagrange\  && \ TypeY === Sinc\),
                      FontColor->GrayLevel[0]], 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    RowBox[{
                      RowBox[{
                        StyleBox["TotSolU",
                          FontColor->GrayLevel[0]], "[", \(x_, y_, t_\), 
                        "]"}], ":=", 
                      RowBox[{
                        RowBox[{
                          RowBox[{
                            RowBox[{\(\[Sum]\+\(m = 1\)\%\(NodesX - 2\)\), 
                              RowBox[{
                                
                                StyleBox[\(\[Sum]\+\(n = 1\)\%\(NodesY - 
                                        2\)\),
                                  FontColor->GrayLevel[0]], 
                                RowBox[{
                                  StyleBox["(",
                                    FontColor->GrayLevel[0]], 
                                  RowBox[{
                                    RowBox[{
                                      RowBox[{
                                        StyleBox["aaa",
                                        FontColor->GrayLevel[0]], 
                                        "[", \([m, n, 2]\), "]"}], "[", "t", 
                                      "]"}], 
                                    StyleBox["*",
                                      FontColor->GrayLevel[0]], 
                                    StyleBox[\(LagrX[m + 1, x]\),
                                      FontColor->GrayLevel[0]], 
                                    StyleBox["*",
                                      FontColor->GrayLevel[0]], 
                                    StyleBox[\(SincY[n + 1, y]\),
                                      FontColor->GrayLevel[0]]}], 
                                  StyleBox[")",
                                    FontColor->GrayLevel[0]]}]}]}], "+", 
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{\(\[Sum]\+\(j = 1\)\%NodesY\), 
                                  RowBox[{
                                    RowBox[{"(", 
                                      RowBox[{\(u\_\(1, j\)\), "*", 
                                        StyleBox[\(LagrX[1, x]\),
                                        FontColor->GrayLevel[0]], 
                                        StyleBox["*",
                                        FontColor->GrayLevel[0]], 
                                        StyleBox[\(SincY[j, y]\),
                                        FontColor->GrayLevel[0]]}], 
                                      StyleBox[")",
                                        FontColor->GrayLevel[0]]}]}]}], 
                                StyleBox["+",
                                  FontColor->GrayLevel[0]], 
                                RowBox[{\(\[Sum]\+\(j = 1\)\%NodesY\), 
                                  RowBox[{
                                    RowBox[{"(", 
                                      RowBox[{\(u\_\(NodesX, j\)\), "*", 
                                        StyleBox[\(LagrX[NodesX, x]\),
                                        FontColor->GrayLevel[0]], 
                                        StyleBox["*",
                                        FontColor->GrayLevel[0]], 
                                        StyleBox[\(SincY[j, y]\),
                                        FontColor->GrayLevel[0]]}], 
                                      StyleBox[")",
                                        FontColor->GrayLevel[0]]}]}]}], 
                                StyleBox["+",
                                  FontColor->GrayLevel[0]], 
                                
                                RowBox[{\(\[Sum]\+\(i = 2\)\%\(NodesX - 1\)\),
                                   
                                  RowBox[{
                                    RowBox[{"(", 
                                      RowBox[{\(u\_\(i, 1\)\), "*", 
                                        StyleBox[\(LagrX[i, x]\),
                                        FontColor->GrayLevel[0]], 
                                        StyleBox["*",
                                        FontColor->GrayLevel[0]], 
                                        StyleBox[\(SincY[1, y]\),
                                        FontColor->GrayLevel[0]]}], 
                                      StyleBox[")",
                                        FontColor->GrayLevel[0]]}]}]}], 
                                StyleBox["+",
                                  FontColor->GrayLevel[0]], 
                                
                                RowBox[{\(\[Sum]\+\(i = 2\)\%\(NodesX - 1\)\),
                                   
                                  RowBox[{
                                    RowBox[{"(", 
                                      RowBox[{\(u\_\(i, NodesY\)\), "*", 
                                        StyleBox[\(LagrX[i, x]\),
                                        FontColor->GrayLevel[0]], 
                                        StyleBox["*",
                                        FontColor->GrayLevel[0]], 
                                        StyleBox[\(SincY[NodesY, y]\),
                                        FontColor->GrayLevel[0]]}], 
                                      StyleBox[")",
                                        FontColor->GrayLevel[0]]}]}]}]}], 
                              StyleBox[")",
                                FontColor->GrayLevel[0]]}]}], 
                          StyleBox["/.",
                            FontColor->GrayLevel[0]], 
                          StyleBox["condTabU",
                            FontColor->GrayLevel[0]]}], 
                        StyleBox["/.",
                          FontColor->GrayLevel[0]], 
                        StyleBox["NumSol",
                          FontColor->GrayLevel[0]]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{
                  StyleBox["If",
                    FontColor->GrayLevel[0]], 
                  StyleBox["[",
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    StyleBox[\(TypeX === Sinc\  && \ TypeY === Lagrange\),
                      FontColor->GrayLevel[0]], 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    RowBox[{
                      RowBox[{
                        StyleBox["TotSolU",
                          FontColor->GrayLevel[0]], "[", \(x_, y_, t_\), 
                        "]"}], ":=", 
                      RowBox[{
                        RowBox[{
                          RowBox[{
                            RowBox[{\(\[Sum]\+\(m = 1\)\%\(NodesX - 2\)\), 
                              RowBox[{
                                
                                StyleBox[\(\[Sum]\+\(n = 1\)\%\(NodesY - 
                                        2\)\),
                                  FontColor->GrayLevel[0]], 
                                RowBox[{
                                  StyleBox["(",
                                    FontColor->GrayLevel[0]], 
                                  RowBox[{
                                    RowBox[{
                                      RowBox[{
                                        StyleBox["aaa",
                                        FontColor->GrayLevel[0]], 
                                        "[", \([m, n, 2]\), "]"}], "[", "t", 
                                      "]"}], 
                                    StyleBox["*",
                                      FontColor->GrayLevel[0]], 
                                    StyleBox[\(SincX[m + 1, x]\),
                                      FontColor->GrayLevel[0]], 
                                    StyleBox["*",
                                      FontColor->GrayLevel[0]], 
                                    StyleBox[\(LagrY[n + 1, y]\),
                                      FontColor->GrayLevel[0]]}], 
                                  StyleBox[")",
                                    FontColor->GrayLevel[0]]}]}]}], "+", 
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{\(\[Sum]\+\(j = 1\)\%NodesY\), 
                                  RowBox[{
                                    RowBox[{"(", 
                                      RowBox[{\(u\_\(1, j\)\), "*", 
                                        StyleBox[\(SincX[1, x]\),
                                        FontColor->GrayLevel[0]], 
                                        StyleBox["*",
                                        FontColor->GrayLevel[0]], 
                                        StyleBox[\(LagrY[j, y]\),
                                        FontColor->GrayLevel[0]]}], 
                                      StyleBox[")",
                                        FontColor->GrayLevel[0]]}]}]}], 
                                StyleBox["+",
                                  FontColor->GrayLevel[0]], 
                                RowBox[{\(\[Sum]\+\(j = 1\)\%NodesY\), 
                                  RowBox[{
                                    RowBox[{"(", 
                                      RowBox[{\(u\_\(NodesX, j\)\), "*", 
                                        StyleBox[\(SincX[NodesX, x]\),
                                        FontColor->GrayLevel[0]], 
                                        StyleBox["*",
                                        FontColor->GrayLevel[0]], 
                                        StyleBox[\(LagrY[j, y]\),
                                        FontColor->GrayLevel[0]]}], 
                                      StyleBox[")",
                                        FontColor->GrayLevel[0]]}]}]}], 
                                StyleBox["+",
                                  FontColor->GrayLevel[0]], 
                                
                                RowBox[{\(\[Sum]\+\(i = 2\)\%\(NodesX - 1\)\),
                                   
                                  RowBox[{
                                    RowBox[{"(", 
                                      RowBox[{\(u\_\(i, 1\)\), "*", 
                                        StyleBox[\(SincX[i, x]\),
                                        FontColor->GrayLevel[0]], 
                                        StyleBox["*",
                                        FontColor->GrayLevel[0]], 
                                        StyleBox[\(LagrY[1, y]\),
                                        FontColor->GrayLevel[0]]}], 
                                      StyleBox[")",
                                        FontColor->GrayLevel[0]]}]}]}], 
                                StyleBox["+",
                                  FontColor->GrayLevel[0]], 
                                
                                RowBox[{\(\[Sum]\+\(i = 2\)\%\(NodesX - 1\)\),
                                   
                                  RowBox[{
                                    RowBox[{"(", 
                                      RowBox[{\(u\_\(i, NodesY\)\), "*", 
                                        StyleBox[\(SincX[i, x]\),
                                        FontColor->GrayLevel[0]], 
                                        StyleBox["*",
                                        FontColor->GrayLevel[0]], 
                                        StyleBox[\(LagrY[NodesY, y]\),
                                        FontColor->GrayLevel[0]]}], 
                                      StyleBox[")",
                                        FontColor->GrayLevel[0]]}]}]}]}], 
                              StyleBox[")",
                                FontColor->GrayLevel[0]]}]}], 
                          StyleBox["/.",
                            FontColor->GrayLevel[0]], 
                          StyleBox["condTabU",
                            FontColor->GrayLevel[0]]}], 
                        StyleBox["/.",
                          FontColor->GrayLevel[0]], 
                        StyleBox["NumSol",
                          FontColor->GrayLevel[0]]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{
                  StyleBox["If",
                    FontColor->GrayLevel[0]], 
                  StyleBox["[",
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    StyleBox[\(TypeX === Sinc\  && \ TypeY === Sinc\),
                      FontColor->GrayLevel[0]], 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    RowBox[{
                      RowBox[{
                        StyleBox["TotSolV",
                          FontColor->GrayLevel[0]], "[", \(x_, y_, t_\), 
                        "]"}], ":=", 
                      RowBox[{
                        RowBox[{
                          RowBox[{
                            RowBox[{\(\[Sum]\+\(m = 1\)\%\(NodesX - 2\)\), 
                              RowBox[{
                                
                                StyleBox[\(\[Sum]\+\(n = 1\)\%\(NodesY - 
                                        2\)\),
                                  FontColor->GrayLevel[0]], 
                                RowBox[{
                                  StyleBox["(",
                                    FontColor->GrayLevel[0]], 
                                  RowBox[{
                                    RowBox[{
                                      RowBox[{
                                        StyleBox["aaa",
                                        FontColor->GrayLevel[0]], 
                                        "[", \([m, n, 2]\), "]"}], "[", "t", 
                                      "]"}], 
                                    StyleBox["*",
                                      FontColor->GrayLevel[0]], 
                                    StyleBox[\(SincX[m + 1, x]\),
                                      FontColor->GrayLevel[0]], 
                                    StyleBox["*",
                                      FontColor->GrayLevel[0]], 
                                    StyleBox[\(SincY[n + 1, y]\),
                                      FontColor->GrayLevel[0]]}], 
                                  StyleBox[")",
                                    FontColor->GrayLevel[0]]}]}]}], "+", 
                            RowBox[{"(", 
                              RowBox[{
                                RowBox[{\(\[Sum]\+\(j = 1\)\%NodesY\), 
                                  RowBox[{
                                    RowBox[{"(", 
                                      RowBox[{\(u\_\(1, j\)\), "*", 
                                        StyleBox[\(SincX[1, x]\),
                                        FontColor->GrayLevel[0]], 
                                        StyleBox["*",
                                        FontColor->GrayLevel[0]], 
                                        StyleBox[\(SincY[j, y]\),
                                        FontColor->GrayLevel[0]]}], 
                                      StyleBox[")",
                                        FontColor->GrayLevel[0]]}]}]}], 
                                StyleBox["+",
                                  FontColor->GrayLevel[0]], 
                                RowBox[{\(\[Sum]\+\(j = 1\)\%NodesY\), 
                                  RowBox[{
                                    RowBox[{"(", 
                                      RowBox[{\(u\_\(NodesX, j\)\), "*", 
                                        StyleBox[\(SincX[NodesX, x]\),
                                        FontColor->GrayLevel[0]], 
                                        StyleBox["*",
                                        FontColor->GrayLevel[0]], 
                                        StyleBox[\(SincY[j, y]\),
                                        FontColor->GrayLevel[0]]}], 
                                      StyleBox[")",
                                        FontColor->GrayLevel[0]]}]}]}], 
                                StyleBox["+",
                                  FontColor->GrayLevel[0]], 
                                
                                RowBox[{\(\[Sum]\+\(i = 2\)\%\(NodesX - 1\)\),
                                   
                                  RowBox[{
                                    RowBox[{"(", 
                                      RowBox[{\(u\_\(i, 1\)\), "*", 
                                        StyleBox[\(SincX[i, x]\),
                                        FontColor->GrayLevel[0]], 
                                        StyleBox["*",
                                        FontColor->GrayLevel[0]], 
                                        StyleBox[\(SincY[1, y]\),
                                        FontColor->GrayLevel[0]]}], 
                                      StyleBox[")",
                                        FontColor->GrayLevel[0]]}]}]}], 
                                StyleBox["+",
                                  FontColor->GrayLevel[0]], 
                                
                                RowBox[{\(\[Sum]\+\(i = 2\)\%\(NodesX - 1\)\),
                                   
                                  RowBox[{
                                    RowBox[{"(", 
                                      RowBox[{\(u\_\(i, NodesY\)\), "*", 
                                        StyleBox[\(SincX[i, x]\),
                                        FontColor->GrayLevel[0]], 
                                        StyleBox["*",
                                        FontColor->GrayLevel[0]], 
                                        StyleBox[\(SincY[NodesY, y]\),
                                        FontColor->GrayLevel[0]]}], 
                                      StyleBox[")",
                                        FontColor->GrayLevel[0]]}]}]}]}], 
                              StyleBox[")",
                                FontColor->GrayLevel[0]]}]}], 
                          StyleBox["/.",
                            FontColor->GrayLevel[0]], 
                          StyleBox["condTabU",
                            FontColor->GrayLevel[0]]}], 
                        StyleBox["/.",
                          FontColor->GrayLevel[0]], 
                        StyleBox["NumSol",
                          FontColor->GrayLevel[0]]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                "\[IndentingNewLine]", \(Print["\<Solution:\>"]\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(plot1 = 
                  Evaluate[TotSolU[x, y, t] /. t \[Rule] 1]\), ";", 
                "\[IndentingNewLine]", 
                RowBox[{"Plot3D", "[", 
                  RowBox[{
                  "plot1", ",", \({x, 0, 1}\), ",", \({y, 0, 1}\), 
                    ",", \(PlotRange \[Rule] {Automatic, Automatic, {0, 3}}\),
                     ",", 
                    RowBox[{"AxesLabel", "\[Rule]", 
                      RowBox[{"TraditionalForm", "/@", 
                        RowBox[{"{", 
                          RowBox[{
                            StyleBox["x",
                              FontSlant->"Italic"], ",", 
                            StyleBox["y",
                              FontSlant->"Italic"], ",", "\"\<\!\(\*
StyleBox[\"u\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"(\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"x\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\",\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"y\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\")\",\nFontSlant->\"Italic\"]\)\>\""}], "}"}]}]}], 
                    ",", \(Ticks \[Rule] {{0, 1}, {0, 1}, {0, 3}}\), 
                    ",", \(PlotPoints \[Rule] 51\)}], "]"}], ";"}]}], 
            "\[IndentingNewLine]", "]"}]}], ";"}], 
      "\[IndentingNewLine]"}]], "Input"],

Cell[BoxData[{
    \(\({NodesX, NodesY} = {51, 51};\)\), "\n", 
    \(\({D1, D2, \[Kappa], a, b, TT} = {0.05, 1, 100, 0.1305, 0.7695, 
          2};\)\), "\n", 
    \(\(concinizV = b\/\((a + b)\)\^2;\)\), "\n", 
    \(\(concinizU = 
        a + b + \(10\^\(-3\)\) 
            Exp[\(-100\) \((\((x - 1\/3)\)\^2 + \((y - 1\/2)\)\^2)\)];\)\), "\
\n", 
    \(\(BDataUX = {0, 0};\)\), "\n", 
    \(\(BDataUY = {0, 0};\)\), "\[IndentingNewLine]", 
    \(\(BDataVX = {0, 0};\)\), "\n", 
    \(\(BDataVY = {0, 0};\)\), "\[IndentingNewLine]", 
    \(\(IData = {concinizU, concinizV};\)\), "\[IndentingNewLine]", 
    \(\({TypeX, TypeY} = {Lagrange, Lagrange};\)\)}], "Input"],

Cell[BoxData[
    \(EvolPatt[BDataUX, BDataVX, BDataUY, BDataVY, IData, NodesX, NodesY, 
      TypeX, TypeY]\)], "Input"]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1280}, {0, 701}},
Evaluator->"Local",
WindowSize->{1231, 899},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowCellLabel->False,
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 1654, 25, 204, "Input"],
Cell[3411, 78, 194, 3, 52, "Input"],
Cell[3608, 83, 66775, 1245, 5242, "Input"],
Cell[70386, 1330, 667, 14, 270, "Input"],
Cell[71056, 1346, 121, 2, 33, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

