(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     40277,        811]*)
(*NotebookOutlinePosition[     41039,        838]*)
(*  CellTagsIndexPosition[     40995,        834]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\( (*\(\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\)\(*\)***********) \)\(\[IndentingNewLine]\)\( (*\ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( \
(*\ Generalized\ Collocation\ \(Methods : 
          Solutions\ to\ Nonlinear\ Problems\)\ \
*) \)\(\[IndentingNewLine]\)\( (*\ Bellomo, \(\(N\)\(.\)\), 
      Lods, \(\(B\)\(.\)\), Revelli, \(\(R\)\(.\)\), 
      Ridolfi, \(\(L\)\(.\)\)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
*) \)\(\[IndentingNewLine]\)\( (*\ 
      A\ Birkh\[ADoubleDot]user\ book\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\
\[IndentingNewLine]\)\( (*\ 
      ISBN : 978 - 0 - 8176 - 4525 - 
          0\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ 
      Program\ HeatTwoDim\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\(\
 (*******************************************************************) \)\)\)]\
, "Input"],

Cell[BoxData[{
    \(\($TextStyle = {FontFamily -> "\<Times\>", 
          FontSize \[Rule] 12};\)\), "\[IndentingNewLine]", 
    \(Off[General::"\<spell\>", General::"\<spell1\>"]\)}], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{\(HeatTwoDim[InitBoundDataX_, InitBoundDataY_, NodesX_, 
            NodesY_, TypeX_, TypeY_]\), ":=", 
          RowBox[{"Module", "[", 
            
            RowBox[{\({}\), ",", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \( (*\(\(**\)\(\ \)\(INITIAL\)\)\ \
CONDITION\ ***) \), "\[IndentingNewLine]", "\[IndentingNewLine]", 
              
              RowBox[{\(\[CurlyPhi][x_, y_] := InitBoundDataX[\([2]\)]\), ";",
                 "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(hhX = 1\/\(NodesX - 1\)\), ";", 
                "\[IndentingNewLine]", \(hhY = 1\/\(NodesX - 1\)\), ";", 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[1, 0, 0]], "\[IndentingNewLine]", 
                RowBox[{"Which", "[", 
                  
                  RowBox[{\(TypeX === Sinc\), 
                    ",", \(x1\_i_ := \((i - 1)\)*hhX\), 
                    ",", \(TypeX === Lagrange\), ",", 
                    
                    StyleBox[\(x1\_i_ := \(-\(1\/2. \)\) \((Cos[\((i - 
                                      1)\)*\[Pi]\/\(NodesX - 1\)] - 1)\)\),
                      FontColor->GrayLevel[0]]}], "]"}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"Which", "[", 
                  
                  RowBox[{\(TypeY === Sinc\), 
                    ",", \(y1\_i_ := \((i - 1)\)*hhY\), 
                    ",", \(TypeY === Lagrange\), ",", 
                    
                    StyleBox[\(y1\_i_ := \(-\(1\/2. \)\) \((Cos[\((i - 
                                      1)\)*\[Pi]\/\(NodesY - 1\)] - 1)\)\),
                      FontColor->GrayLevel[0]]}], "]"}], ";", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                  RowBox[{\(TypeX === Lagrange\), ",", 
                    
                    StyleBox[\(LagrX[j_, 
                          x_] := \[Product]\+\(p = 1\)\%NodesX\((If[
                              p \[NotEqual] 
                                j, \(x - x1\_p\)\/\(x1\_j - x1\_p\), 1])\)\),
                      FontColor->GrayLevel[0]]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{"If", "[", 
                  RowBox[{\(TypeY === Lagrange\), ",", 
                    
                    StyleBox[\(LagrY[j_, 
                          y_] := \[Product]\+\(p = 1\)\%NodesY\((If[
                              p \[NotEqual] 
                                j, \(y - y1\_p\)\/\(y1\_j - y1\_p\), 1])\)\),
                      FontColor->GrayLevel[0]]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{"If", "[", 
                  RowBox[{\(TypeX === Sinc\), ",", 
                    
                    StyleBox[\(SincX[j_, x_] := 
                        Which[0 \[LessEqual] x \[LessEqual] 1\  && \ 
                            x \[NotEqual] \((j - 1)\)*hhX, 
                          Sin[\(\[Pi]*\((x - \((j - 1)\)*hhX)\)\)\/hhX]/\((\(\
\[Pi]*\((x - \((j - 1)\)*hhX)\)\)\/hhX)\), x == \((j - 1)\)*hhX, \ 1]\),
                      FontColor->GrayLevel[0]]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{"If", "[", 
                  RowBox[{\(TypeY === Sinc\), ",", 
                    
                    StyleBox[\(SincY[j_, y_] := 
                        Which[0 \[LessEqual] y \[LessEqual] 1\  && \ 
                            y \[NotEqual] \((j - 1)\)*hhY, 
                          Sin[\(\[Pi]*\((y - \((j - 1)\)*hhY)\)\)\/hhY]/\((\(\
\[Pi]*\((y - \((j - 1)\)*hhY)\)\)\/hhY)\), y == \((j - 1)\)*hhY, \ 1]\),
                      FontColor->GrayLevel[0]]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{
                  StyleBox["If",
                    FontColor->GrayLevel[0]], 
                  StyleBox["[",
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    
                    StyleBox[\(TypeX === Lagrange\  && \ TypeY === Lagrange\),
                      
                      FontColor->GrayLevel[0]], 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    RowBox[{\(InitValue[x_, y_]\), ":=", 
                      RowBox[{\(\[Sum]\+\(m = 1\)\%NodesX\), 
                        RowBox[{
                          StyleBox[\(\[Sum]\+\(n = 1\)\%NodesY\),
                            FontColor->GrayLevel[0]], 
                          RowBox[{
                            StyleBox["(",
                              FontColor->GrayLevel[0]], 
                            RowBox[{
                              RowBox[{
                                StyleBox["(",
                                  FontColor->GrayLevel[0]], 
                                RowBox[{
                                  StyleBox[\(\[CurlyPhi][x, y]\),
                                    FontColor->GrayLevel[0]], 
                                  StyleBox["/.",
                                    FontColor->GrayLevel[0]], 
                                  RowBox[{
                                    StyleBox["{",
                                      FontColor->GrayLevel[0]], 
                                    RowBox[{
                                      StyleBox[\(x \[Rule] \ x1\_m\),
                                        FontColor->GrayLevel[0]], 
                                      StyleBox[",",
                                        FontColor->GrayLevel[0]], 
                                      RowBox[{
                                        StyleBox["y",
                                        FontColor->GrayLevel[0]], "\[Rule]", 
                                        " ", \(y1\_n\)}]}], "}"}]}], 
                                StyleBox[")",
                                  FontColor->GrayLevel[0]]}], 
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(LagrX[m, x]\),
                                FontColor->GrayLevel[0]], 
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(LagrY[n, y]\),
                                FontColor->GrayLevel[0]]}], 
                            StyleBox[")",
                              FontColor->GrayLevel[0]]}]}]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{
                  StyleBox["If",
                    FontColor->GrayLevel[0]], 
                  StyleBox["[",
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    StyleBox[\(TypeX === Lagrange\  && \ TypeY === Sinc\),
                      FontColor->GrayLevel[0]], 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    RowBox[{\(InitValue[x_, y_]\), ":=", 
                      RowBox[{\(\[Sum]\+\(m = 1\)\%NodesX\), 
                        RowBox[{
                          StyleBox[\(\[Sum]\+\(n = 1\)\%NodesY\),
                            FontColor->GrayLevel[0]], 
                          RowBox[{
                            StyleBox["(",
                              FontColor->GrayLevel[0]], 
                            RowBox[{
                              RowBox[{
                                StyleBox["(",
                                  FontColor->GrayLevel[0]], 
                                RowBox[{
                                  StyleBox[\(\[CurlyPhi][x, y]\),
                                    FontColor->GrayLevel[0]], 
                                  StyleBox["/.",
                                    FontColor->GrayLevel[0]], 
                                  RowBox[{
                                    StyleBox["{",
                                      FontColor->GrayLevel[0]], 
                                    RowBox[{
                                      StyleBox[\(x \[Rule] \ x1\_m\),
                                        FontColor->GrayLevel[0]], 
                                      StyleBox[",",
                                        FontColor->GrayLevel[0]], 
                                      RowBox[{
                                        StyleBox["y",
                                        FontColor->GrayLevel[0]], "\[Rule]", 
                                        " ", \(y1\_n\)}]}], "}"}]}], 
                                StyleBox[")",
                                  FontColor->GrayLevel[0]]}], 
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(LagrX[m, x]\),
                                FontColor->GrayLevel[0]], 
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(SincY[n, y]\),
                                FontColor->GrayLevel[0]]}], 
                            StyleBox[")",
                              FontColor->GrayLevel[0]]}]}]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{
                  StyleBox["If",
                    FontColor->GrayLevel[0]], 
                  StyleBox["[",
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    StyleBox[\(TypeX === Sinc\  && \ TypeY === Lagrange\),
                      FontColor->GrayLevel[0]], 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    RowBox[{\(InitValue[x_, y_]\), ":=", 
                      RowBox[{\(\[Sum]\+\(m = 1\)\%NodesX\), 
                        RowBox[{
                          StyleBox[\(\[Sum]\+\(n = 1\)\%NodesY\),
                            FontColor->GrayLevel[0]], 
                          RowBox[{
                            StyleBox["(",
                              FontColor->GrayLevel[0]], 
                            RowBox[{
                              RowBox[{
                                StyleBox["(",
                                  FontColor->GrayLevel[0]], 
                                RowBox[{
                                  StyleBox[\(\[CurlyPhi][x, y]\),
                                    FontColor->GrayLevel[0]], 
                                  StyleBox["/.",
                                    FontColor->GrayLevel[0]], 
                                  RowBox[{
                                    StyleBox["{",
                                      FontColor->GrayLevel[0]], 
                                    RowBox[{
                                      StyleBox[\(x \[Rule] \ x1\_m\),
                                        FontColor->GrayLevel[0]], 
                                      StyleBox[",",
                                        FontColor->GrayLevel[0]], 
                                      RowBox[{
                                        StyleBox["y",
                                        FontColor->GrayLevel[0]], "\[Rule]", 
                                        " ", \(y1\_n\)}]}], "}"}]}], 
                                StyleBox[")",
                                  FontColor->GrayLevel[0]]}], 
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(SincX[m, x]\),
                                FontColor->GrayLevel[0]], 
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(LagrY[n, y]\),
                                FontColor->GrayLevel[0]]}], 
                            StyleBox[")",
                              FontColor->GrayLevel[0]]}]}]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{
                  StyleBox["If",
                    FontColor->GrayLevel[0]], 
                  StyleBox["[",
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    StyleBox[\(TypeX === Sinc\  && \ TypeY === Sinc\),
                      FontColor->GrayLevel[0]], 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    RowBox[{\(InitValue[x_, y_]\), ":=", 
                      RowBox[{\(\[Sum]\+\(m = 1\)\%NodesX\), 
                        RowBox[{
                          StyleBox[\(\[Sum]\+\(n = 1\)\%NodesY\),
                            FontColor->GrayLevel[0]], 
                          RowBox[{
                            StyleBox["(",
                              FontColor->GrayLevel[0]], 
                            RowBox[{
                              RowBox[{
                                StyleBox["(",
                                  FontColor->GrayLevel[0]], 
                                RowBox[{
                                  StyleBox[\(\[CurlyPhi][x, y]\),
                                    FontColor->GrayLevel[0]], 
                                  StyleBox["/.",
                                    FontColor->GrayLevel[0]], 
                                  RowBox[{
                                    StyleBox["{",
                                      FontColor->GrayLevel[0]], 
                                    RowBox[{
                                      StyleBox[\(x \[Rule] \ x1\_m\),
                                        FontColor->GrayLevel[0]], 
                                      StyleBox[",",
                                        FontColor->GrayLevel[0]], 
                                      RowBox[{
                                        StyleBox["y",
                                        FontColor->GrayLevel[0]], "\[Rule]", 
                                        " ", \(y1\_n\)}]}], "}"}]}], 
                                StyleBox[")",
                                  FontColor->GrayLevel[0]]}], 
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(SincX[m, x]\),
                                FontColor->GrayLevel[0]], 
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(SincY[n, y]\),
                                FontColor->GrayLevel[0]]}], 
                            StyleBox[")",
                              FontColor->GrayLevel[0]]}]}]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\t",
                  FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Print["\<Initial condition \
interpolation:\>"]\), ";", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Plot3D[
                  Evaluate[InitValue[x, y]], {x, 0, 1}, {y, 0, 1}, 
                  PlotRange \[Rule] All]\), ";", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Print["\<Don't worry! I'm \
working\>"]\), ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", 
                RowBox[{
                  StyleBox["(*",
                    FontColor->GrayLevel[0]], 
                  StyleBox[\(\(\(**\)\(\ \)\(Derivative\)\)\ matrices\)], 
                  StyleBox[" "], 
                  StyleBox["***)"]}], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[0, 0, 1]], \(If[
                  TypeX === Lagrange, \[IndentingNewLine]FDMX[j_, i_] := 
                    Which[i == 
                        j, \[Sum]\+\(k = 1\)\%NodesX If[k == i, 0, 
                          1\/\(x1\_i - x1\_k\)], 
                      i != j, \(\[Product]\+\(p = 1\)\%NodesX\((If[p \[Equal] \
i, 1, x1\_i - x1\_p])\)\)\/\(\((x1\_i - x1\_j)\) \(\[Product]\+\(p = \
1\)\%NodesX\((If[p \[Equal] j, 1, x1\_j - x1\_p])\)\)\)]; \[IndentingNewLine]\
\[IndentingNewLine]FirstDerX = 
                    Table[FDMX[j, i], {j, 1, NodesX}, {i, 1, 
                        NodesX}]; \[IndentingNewLine]SecondDerX = 
                    Table[If[i \[NotEqual] j, 
                        2 \((FirstDerX[\([j, i]\)]*FirstDerX[\([i, i]\)] - 
                              FirstDerX[\([j, i]\)]\/\(x1\_i - x1\_j\))\), 
                        0], {j, 1, NodesX}, {i, 1, 
                        NodesX}]; \[IndentingNewLine]Do[
                    SecondDerX[\([i, 
                          i]\)] = \(-\(\[Sum]\+\(k = 1\)\%NodesX 
                            SecondDerX[\([k, i]\)]\)\), {i, 1, NodesX}]]\), 
                ";", 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[0, 0, 1]], \(If[
                  TypeY === Lagrange, \[IndentingNewLine]FDMY[j_, i_] := 
                    Which[i == 
                        j, \[Sum]\+\(k = 1\)\%NodesY If[k == i, 0, 
                          1\/\(y1\_i - y1\_k\)], 
                      i != j, \(\[Product]\+\(p = 1\)\%NodesY\((If[p \[Equal] \
i, 1, y1\_i - y1\_p])\)\)\/\(\((y1\_i - y1\_j)\) \(\[Product]\+\(p = \
1\)\%NodesY\((If[p \[Equal] j, 1, y1\_j - y1\_p])\)\)\)]; \[IndentingNewLine]\
\[IndentingNewLine]FirstDerY = 
                    Table[FDMY[j, i], {j, 1, NodesY}, {i, 1, 
                        NodesY}]; \[IndentingNewLine]SecondDerY = 
                    Table[If[i \[NotEqual] j, 
                        2 \((FirstDerY[\([j, i]\)]*FirstDerY[\([i, i]\)] - 
                              FirstDerY[\([j, i]\)]\/\(y1\_i - y1\_j\))\), 
                        0], {j, 1, NodesY}, {i, 1, 
                        NodesY}]; \[IndentingNewLine]Do[
                    SecondDerY[\([i, 
                          i]\)] = \(-\(\[Sum]\+\(k = 1\)\%NodesY 
                            SecondDerY[\([k, i]\)]\)\), {i, 1, NodesY}]]\), 
                ";", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(If[
                  TypeX === Sinc, \[IndentingNewLine]FDMX[j_, i_] := 
                    Which[i != 
                        j, \((\(-1\))\)\^\(i - j\)\/\(hhX*\((i - j)\)\), 
                      i == j, 0]; \[IndentingNewLine]SDMX[j_, i_] := 
                    Which[i != 
                        j, \(2*\((\(-1\))\)\^\(i - j + 1\)\)\/\(hhX\^2*\((i - \
j)\)\^2\), i == j, \(-\(\[Pi]\^2\/\(3*
                              hhX\^2\)\)\)]; \[IndentingNewLine]\
\[IndentingNewLine]FirstDerX = 
                    Table[FDMX[j, i], {j, 1, NodesX}, {i, 1, 
                        NodesX}]; \[IndentingNewLine]SecondDerX = 
                    Table[SDMX[j, i], {j, 1, NodesX}, {i, 1, NodesX}]]\), ";",
                 "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(If[
                  TypeY === Sinc, \[IndentingNewLine]FDMY[j_, i_] := 
                    Which[i != 
                        j, \((\(-1\))\)\^\(i - j\)\/\(hhY*\((i - j)\)\), 
                      i == j, 0]; \[IndentingNewLine]SDMY[j_, i_] := 
                    Which[i != 
                        j, \(2*\((\(-1\))\)\^\(i - j + 1\)\)\/\(hhY\^2*\((i - \
j)\)\^2\), i == j, \(-\(\[Pi]\^2\/\(3*
                              hhY\^2\)\)\)]; \[IndentingNewLine]FirstDerY = 
                    Table[FDMY[j, i], {j, 1, NodesY}, {i, 1, 
                        NodesY}]; \[IndentingNewLine]SecondDerY = 
                    Table[SDMY[j, i], {j, 1, NodesY}, {i, 1, NodesY}]]\), ";",
                 "\[IndentingNewLine]", 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[0, 0, 1]], 
                "\[IndentingNewLine]", \( (*\(\(**\)\(\ \)\(Nodal\)\)\ \
Equations\ ***) \), 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{\(NdEq[i_, j_]\), 
                  StyleBox[":=",
                    FontColor->GrayLevel[0]], 
                  
                  StyleBox[
                    " "], \(\(C\_\(i, j\)'\)[
                        t] == \(1\/\[Pi]\^2\) \((\((\[Sum]\+\(k = 1\)\%NodesX 
                                    SecondDerX[\([k, i]\)]*
                                  C\_\(k, j\)[
                                    t])\) + \((\[Sum]\+\(k = 1\)\%NodesY 
                                    SecondDerY[\([k, j]\)]*
                                  C\_\(i, k\)[t])\))\) /. {x -> \ x1\_i, 
                      y -> \ y1\_j}\)}], ";", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Eq0X = 
                  Flatten[
                    Table[\(C\_\(1, j\)'\)[t] \[Equal] 
                          D[InitBoundDataX[\([1]\)], t] /. 
                        y \[Rule] y1\_j, {j, 1, NodesY}]]\), ";", 
                "\[IndentingNewLine]", \(EqMX = 
                  Flatten[
                    Table[\(C\_\(NodesX, j\)'\)[t] \[Equal] 
                          D[InitBoundDataX[\([3]\)], t] /. 
                        y \[Rule] y1\_j, {j, 1, NodesY}]]\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Eq0Y = 
                  Flatten[
                    Table[\(C\_\(i, 1\)'\)[t] \[Equal] 
                          D[InitBoundDataY[\([1]\)], t] /. 
                        x \[Rule] x1\_i, {i, 2, NodesX - 1}]]\), ";", 
                "\[IndentingNewLine]", \(EqMY = 
                  Flatten[
                    Table[\(C\_\(i, NodesY\)'\)[t] \[Equal] 
                          D[InitBoundDataY[\([3]\)], t] /. 
                        x \[Rule] x1\_i, {i, 2, NodesX - 1}]]\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(cEq0X = 
                  Flatten[
                    Table[C\_\(1, j\)[0] \[Equal] \[CurlyPhi][x, 
                            y] /. {x \[Rule] \ x1\_1, y \[Rule] \ y1\_j}, {j, 
                        1, NodesY}]]\), ";", 
                "\[IndentingNewLine]", \(cEqMX = 
                  Flatten[
                    Table[C\_\(NodesX, j\)[0] \[Equal] \[CurlyPhi][x, 
                            y] /. {x \[Rule] \ x1\_NodesX, 
                          y \[Rule] \ y1\_j}, {j, 1, NodesY}]]\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(cEq0Y = 
                  Flatten[
                    Table[C\_\(i, 1\)[0] \[Equal] \[CurlyPhi][x, 
                            y] /. {x \[Rule] \ x1\_i, y \[Rule] \ y1\_1}, {i, 
                        2, NodesX - 1}]]\), ";", 
                "\[IndentingNewLine]", \(cEqMY = 
                  Flatten[
                    Table[C\_\(i, NodesY\)[0] \[Equal] \[CurlyPhi][x, 
                            y] /. {x \[Rule] \ x1\_i, 
                          y \[Rule] \ y1\_NodesY}, {i, 2, NodesX - 1}]]\), 
                ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(EqsSys = 
                  Flatten[
                    Table[{NdEq[i, j], 
                        C\_\(i, j\)[
                            0] == \((\[CurlyPhi][x, y] /. {x \[Rule] \ x1\_i, 
                                y \[Rule] \ y1\_j})\)}, {i, 2, 
                        NodesX - 1}, {j, 2, NodesY - 1}]]\), ";", 
                "\[IndentingNewLine]", \(NdEqsSys = 
                  Join[EqsSys, Eq0X, EqMX, Eq0Y, EqMY, cEq0X, cEqMX, cEq0Y, 
                    cEqMY]\), ";", 
                "\[IndentingNewLine]", \(UnKnown = 
                  Flatten[
                    Join[Table[
                        C\_\(i, j\), {i, 1, NodesX}, {j, 1, NodesY}]]]\), ";",
                 "\[IndentingNewLine]", \(NumSol = 
                  NDSolve[NdEqsSys, UnKnown, {t, 0, 1}, \ 
                      MaxSteps \[Rule] 10000000] // Flatten\), ";", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \( (*\(**\)\(\ \)\(Solution\)\ ***) \),
                 "\[IndentingNewLine]", \(aa = Partition[NumSol, NodesY]\), 
                ";", "\[IndentingNewLine]", 
                RowBox[{
                  StyleBox["If",
                    FontColor->GrayLevel[0]], 
                  StyleBox["[",
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    
                    StyleBox[\(TypeX === Lagrange\  && \ TypeY === Lagrange\),
                      
                      FontColor->GrayLevel[0]], 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    RowBox[{
                      RowBox[{
                        StyleBox["TotSol",
                          FontColor->GrayLevel[0]], "[", \(x_, y_, t_\), 
                        "]"}], ":=", 
                      RowBox[{\(\[Sum]\+\(m = 1\)\%NodesX\), 
                        RowBox[{
                          StyleBox[\(\[Sum]\+\(n = 1\)\%NodesY\),
                            FontColor->GrayLevel[0]], 
                          RowBox[{
                            StyleBox["(",
                              FontColor->GrayLevel[0]], 
                            RowBox[{
                              RowBox[{
                                RowBox[{
                                  StyleBox["aa",
                                    FontColor->GrayLevel[0]], 
                                  "[", \([m, n, 2]\), "]"}], "[", "t", "]"}], 
                              
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(LagrX[m, x]\),
                                FontColor->GrayLevel[0]], 
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(LagrY[n, y]\),
                                FontColor->GrayLevel[0]]}], 
                            StyleBox[")",
                              FontColor->GrayLevel[0]]}]}]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{
                  StyleBox["If",
                    FontColor->GrayLevel[0]], 
                  StyleBox["[",
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    StyleBox[\(TypeX === Lagrange\  && \ TypeY === Sinc\),
                      FontColor->GrayLevel[0]], 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    RowBox[{
                      RowBox[{
                        StyleBox["TotSol",
                          FontColor->GrayLevel[0]], "[", \(x_, y_, t_\), 
                        "]"}], ":=", 
                      RowBox[{\(\[Sum]\+\(m = 1\)\%NodesX\), 
                        RowBox[{
                          StyleBox[\(\[Sum]\+\(n = 1\)\%NodesY\),
                            FontColor->GrayLevel[0]], 
                          RowBox[{
                            StyleBox["(",
                              FontColor->GrayLevel[0]], 
                            RowBox[{
                              RowBox[{
                                RowBox[{
                                  StyleBox["aa",
                                    FontColor->GrayLevel[0]], 
                                  "[", \([m, n, 2]\), "]"}], "[", "t", "]"}], 
                              
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(LagrX[m, x]\),
                                FontColor->GrayLevel[0]], 
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(SincY[n, y]\),
                                FontColor->GrayLevel[0]]}], 
                            StyleBox[")",
                              FontColor->GrayLevel[0]]}]}]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{
                  StyleBox["If",
                    FontColor->GrayLevel[0]], 
                  StyleBox["[",
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    StyleBox[\(TypeX === Sinc\  && \ TypeY === Lagrange\),
                      FontColor->GrayLevel[0]], 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    RowBox[{
                      RowBox[{
                        StyleBox["TotSol",
                          FontColor->GrayLevel[0]], "[", \(x_, y_, t_\), 
                        "]"}], ":=", 
                      RowBox[{\(\[Sum]\+\(m = 1\)\%NodesX\), 
                        RowBox[{
                          StyleBox[\(\[Sum]\+\(n = 1\)\%NodesY\),
                            FontColor->GrayLevel[0]], 
                          RowBox[{
                            StyleBox["(",
                              FontColor->GrayLevel[0]], 
                            RowBox[{
                              RowBox[{
                                RowBox[{
                                  StyleBox["aa",
                                    FontColor->GrayLevel[0]], 
                                  "[", \([m, n, 2]\), "]"}], "[", "t", "]"}], 
                              
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(SincX[m, x]\),
                                FontColor->GrayLevel[0]], 
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(LagrY[n, y]\),
                                FontColor->GrayLevel[0]]}], 
                            StyleBox[")",
                              FontColor->GrayLevel[0]]}]}]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->GrayLevel[0]], 
                RowBox[{
                  StyleBox["If",
                    FontColor->GrayLevel[0]], 
                  StyleBox["[",
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    StyleBox[\(TypeX === Sinc\  && \ TypeY === Sinc\),
                      FontColor->GrayLevel[0]], 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    RowBox[{
                      RowBox[{
                        StyleBox["TotSol",
                          FontColor->GrayLevel[0]], "[", \(x_, y_, t_\), 
                        "]"}], ":=", 
                      RowBox[{\(\[Sum]\+\(m = 1\)\%NodesX\), 
                        RowBox[{
                          StyleBox[\(\[Sum]\+\(n = 1\)\%NodesY\),
                            FontColor->GrayLevel[0]], 
                          RowBox[{
                            StyleBox["(",
                              FontColor->GrayLevel[0]], 
                            RowBox[{
                              RowBox[{
                                RowBox[{
                                  StyleBox["aa",
                                    FontColor->GrayLevel[0]], 
                                  "[", \([m, n, 2]\), "]"}], "[", "t", "]"}], 
                              
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(SincX[m, x]\),
                                FontColor->GrayLevel[0]], 
                              StyleBox["*",
                                FontColor->GrayLevel[0]], 
                              StyleBox[\(SincY[n, y]\),
                                FontColor->GrayLevel[0]]}], 
                            StyleBox[")",
                              FontColor->GrayLevel[0]]}]}]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[0, 0, 1]], \(Print["\<Solution:\>"]\), 
                ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"Plot3D", "[", 
                  
                  RowBox[{\(Evaluate[TotSol[x, y, 1]]\), ",", \({x, 0, 1}\), 
                    ",", \({y, 0, 1}\), 
                    ",", \(PlotRange \[Rule] {Automatic, 
                        Automatic, {\(-1\), 1}}\), ",", 
                    RowBox[{"AxesLabel", "\[Rule]", 
                      RowBox[{"TraditionalForm", "/@", 
                        RowBox[{"{", 
                          RowBox[{
                            StyleBox["x",
                              FontSlant->"Italic"], ",", 
                            StyleBox["y",
                              FontSlant->"Italic"], ",", "\"\<\!\(\*
StyleBox[\"u\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"(\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"x\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\",\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"y\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\")\",\nFontSlant->\"Italic\"]\)\>\""}], "}"}]}]}], 
                    ",", \(Ticks \[Rule] {{0, 1}, {0, 1}, {\(-1\), 0, 1}}\), 
                    ",", \(PlotPoints \[Rule] 51\)}], "]"}], ";"}]}], 
            "\[IndentingNewLine]", "]"}]}], ";"}], 
      "\[IndentingNewLine]"}]], "Input"],

Cell[BoxData[{
    \(\({NodesX, NodesY} = {11, 11};\)\), "\[IndentingNewLine]", 
    \(\(Anal[x_, y_, t_] := 
        Exp[\(-\(t\/2\)\)] Cos[\(\[Pi]\/2\) \((x + y)\)] + 
          Exp[\(-2\) t] Sin[\[Pi] \((x - y)\)];\)\), "\[IndentingNewLine]", 
    \(\(conciniz = Anal[x, y, 0];\)\), "\n", 
    \(\(concBoundX0 = Anal[0, y, t];\)\), "\[IndentingNewLine]", 
    \(\(concBoundX1 = Anal[1, y, t];\)\), "\[IndentingNewLine]", 
    \(\(concBoundY0 = Anal[x, 0, t];\)\), "\[IndentingNewLine]", 
    \(\(concBoundY1 = Anal[x, 1, t];\)\), "\[IndentingNewLine]", 
    \(\(IBDataX = {concBoundX0, conciniz, concBoundX1};\)\), "\n", 
    \(\(IBDataY = {concBoundY0, conciniz, concBoundY1};\)\)}], "Input"],

Cell[BoxData[
    \(HeatTwoDim[IBDataX, IBDataY, NodesX, NodesY, Lagrange, 
      Lagrange]\)], "Input"]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1280}, {0, 701}},
Evaluator->"Local",
WindowSize->{1229, 621},
WindowMargins->{{3, Automatic}, {12, Automatic}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowCellLabel->False,
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 1652, 25, 204, "Input"],
Cell[3409, 78, 194, 3, 52, "Input"],
Cell[3606, 83, 35861, 709, 3121, "Input"],
Cell[39470, 794, 696, 11, 214, "Input"],
Cell[40169, 807, 104, 2, 33, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

