(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     18884,        383]*)
(*NotebookOutlinePosition[     19645,        410]*)
(*  CellTagsIndexPosition[     19601,        406]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\( (*\(\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\)\(*\)***********) \)\(\[IndentingNewLine]\)\( (*\ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( \
(*\ Generalized\ Collocation\ \(Methods : 
          Solutions\ to\ Nonlinear\ Problems\)\ \
*) \)\(\[IndentingNewLine]\)\( (*\ Bellomo, \(\(N\)\(.\)\), 
      Lods, \(\(B\)\(.\)\), Revelli, \(\(R\)\(.\)\), 
      Ridolfi, \(\(L\)\(.\)\)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
*) \)\(\[IndentingNewLine]\)\( (*\ 
      A\ Birkh\[ADoubleDot]user\ book\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\
\[IndentingNewLine]\)\( (*\ 
      ISBN : 978 - 0 - 8176 - 4525 - 
          0\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ 
      Program\ KdVIII\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( \
(*\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\
\[IndentingNewLine]\)\( (*******************************************************************) \
\)\)\)], "Input"],

Cell[BoxData[{
    \(\($TextStyle = {FontFamily -> "\<Times\>", 
          FontSize \[Rule] 12};\)\), "\[IndentingNewLine]", 
    \(Off[General::"\<spell\>", General::"\<spell1\>"]\)}], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{\(KdVIII[InitBoundData_, Nodes_, \[Mu]_, mreact_, Type_]\), ":=",
           
          RowBox[{"Module", "[", 
            
            RowBox[{\({}\), ",", 
              "\[IndentingNewLine]", \( (*\(\(**\)\(\ \)\(INITIAL\)\)\ \
CONDITION\ ***) \), "\[IndentingNewLine]", 
              
              RowBox[{\(\[CurlyPhi][x_] := InitBoundData[\([2]\)]\), ";", 
                "\[IndentingNewLine]", \(hh = 1\/\(Nodes - 1\)\), ";", 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[1, 0, 0]], 
                RowBox[{"Which", "[", 
                  
                  RowBox[{\(Type === Sinc\), 
                    ",", \(x1\_i_ := \((i - 1)\)*hh\), 
                    ",", \(Type === Lagrange\), ",", 
                    
                    StyleBox[\(x1\_i_ := \(-\(1\/2. \)\) \((Cos[\((i - 
                                      1)\)*\[Pi]\/\(Nodes - 1\)] - 1)\)\),
                      FontColor->GrayLevel[0]]}], "]"}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                  RowBox[{\(Type === Lagrange\), ",", 
                    RowBox[{
                      
                      StyleBox[\(Lagr[j_, 
                            x_] := \[Product]\+\(p = 1\)\%Nodes\((If[
                                p \[NotEqual] 
                                  j, \(x - x1\_p\)\/\(x1\_j - x1\_p\), 
                                1])\)\),
                        FontColor->GrayLevel[0]], 
                      StyleBox[";",
                        FontColor->GrayLevel[0]], 
                      RowBox[{\(InitValue[x_]\), ":=", 
                        
                        StyleBox[\(\[Sum]\+\(k = 1\)\%Nodes\((\[CurlyPhi][x] /. 
                                  x \[Rule] \ x1\_k)\)*Lagr[k, x]\),
                          FontColor->GrayLevel[0]]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\t",
                  FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                  RowBox[{\(Type === Sinc\), ",", 
                    RowBox[{
                      StyleBox[\(Sinc[j_, x_] := 
                          Which[0 \[LessEqual] x \[LessEqual] 1\  && \ 
                              x \[NotEqual] \((j - 1)\)*hh, 
                            Sin[\(\[Pi]*\((x - \((j - 1)\)*hh)\)\)\/hh]/\((\(\
\[Pi]*\((x - \((j - 1)\)*hh)\)\)\/hh)\), x == \((j - 1)\)*hh, \ 1]\),
                        FontColor->GrayLevel[0]], 
                      StyleBox[";",
                        FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
                      StyleBox[
                        RowBox[{\(InitValue[x_]\), ":=", 
                          RowBox[{\(\[Sum]\+\(k = 1\)\%Nodes\), 
                            RowBox[{
                              RowBox[{"(", 
                                RowBox[{\(\[CurlyPhi][x]\), "/.", 
                                  RowBox[{"x", "->", 
                                    SubscriptBox[
                                      StyleBox[
                                        RowBox[{"x", 
                                        StyleBox["1",
                                        FontColor->GrayLevel[0]]}]], "k"]}]}],
                                 ")"}], "*", \(Sinc[k, x]\)}]}]}],
                        FontColor->GrayLevel[0]]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], "\t", 
                "\[IndentingNewLine]", \(Print["\<Initial condition \
interpolation:\>"]\), ";", 
                "\[IndentingNewLine]", \(Plot[
                  Evaluate[{\[CurlyPhi][x], InitValue[x]}], {x, 0, 1}, 
                  PlotRange \[Rule] \ All, 
                  PlotStyle \[Rule] {GrayLevel[0], Dashing[{0.15, 0.05}]}, 
                  AxesLabel \[Rule] \ {x, u[x, 0]}, 
                  AxesOrigin \[Rule] \ {0, 0}]\), ";", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Print["\<Don't worry! I'm \
working\>"]\), ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{
                  StyleBox["(*",
                    FontColor->GrayLevel[0]], 
                  StyleBox[\(\(\(**\)\(\ \)\(DERIVATIVE\)\)\ MATRICES\)], 
                  StyleBox[" "], 
                  StyleBox["***)"]}], "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(If[
                  Type === Lagrange, \[IndentingNewLine]FDM[j_, i_] := 
                    Which[i == 
                        j, \[Sum]\+\(k = 1\)\%Nodes If[k == i, 0, 
                          1\/\(x1\_i - x1\_k\)], 
                      i != j, \(\[Product]\+\(p = 1\)\%Nodes\((If[p \[Equal] \
i, 1, x1\_i - x1\_p])\)\)\/\(\((x1\_i - x1\_j)\) \(\[Product]\+\(p = \
1\)\%Nodes\((If[p \[Equal] j, 1, x1\_j - x1\_p])\)\)\)]; \[IndentingNewLine]\
\[IndentingNewLine]FirstDer = 
                    Table[FDM[j, i], {j, 1, Nodes}, {i, 1, 
                        Nodes}]; \[IndentingNewLine]SecondDer = 
                    Table[If[i \[NotEqual] j, 
                        2 \((FirstDer[\([j, i]\)]*FirstDer[\([i, i]\)] - 
                              FirstDer[\([j, i]\)]\/\(x1\_i - x1\_j\))\), 
                        0], {j, 1, Nodes}, {i, 1, 
                        Nodes}]; \[IndentingNewLine]Do[
                    SecondDer[\([i, 
                          i]\)] = \(-\(\[Sum]\+\(k = 1\)\%Nodes 
                            SecondDer[\([k, i]\)]\)\), {i, 1, 
                      Nodes}]; \[IndentingNewLine]ThirdDer = 
                    Table[If[i \[NotEqual] j, 
                        3 \((FirstDer[\([j, i]\)]*SecondDer[\([i, i]\)] - 
                              SecondDer[\([j, i]\)]\/\(x1\_i - x1\_j\))\), 
                        0], {j, 1, Nodes}, {i, 1, 
                        Nodes}]; \[IndentingNewLine]Do[
                    ThirdDer[\([i, 
                          i]\)] = \(-\(\[Sum]\+\(k = 1\)\%Nodes 
                            ThirdDer[\([k, i]\)]\)\), {i, 1, Nodes}]]\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(If[
                  Type === Sinc, \[IndentingNewLine]FDM[j_, i_] := 
                    Which[i != 
                        j, \((\(-1\))\)\^\(i - j\)\/\(hh*\((i - j)\)\), 
                      i == j, 0]; \[IndentingNewLine]SDM[j_, i_] := 
                    Which[i != 
                        j, \(2*\((\(-1\))\)\^\(i - j + 1\)\)\/\(hh\^2*\((i - \
j)\)\^2\), i == j, \(-\(\[Pi]\^2\/\(3*hh\^2\)\)\)]; \[IndentingNewLine]TDM[
                      j_, i_] := 
                    Which[i != 
                        j, \(\((\(-1\))\)\^\(i - j\)\/hh\^3\) \((6\/\((i - j)\
\)\^3 - \[Pi]\^2\/\(i - j\))\), i == j, 0]; \[IndentingNewLine]FirstDer = 
                    Table[FDM[j, i], {j, 1, Nodes}, {i, 1, 
                        Nodes}]; \[IndentingNewLine]SecondDer = 
                    Table[SDM[j, i], {j, 1, Nodes}, {i, 1, 
                        Nodes}]; \[IndentingNewLine]ThirdDer = 
                    Table[TDM[j, i], {j, 1, Nodes}, {i, 1, Nodes}]]\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \( (*\(\(**\)\(\ \)\(Nodal\)\)\ \
Equations\ ***) \), "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{\(NdEq[i_]\), 
                  StyleBox[":=",
                    FontColor->GrayLevel[0]], 
                  StyleBox[" ",
                    FontColor->GrayLevel[
                    0]], \(\(C\_i'\)[
                        t] == \((\((\(-\(\(T1 - T0\)\/\(X1 - 
                                      X0\)\)\))\)*\((\[Sum]\+\(k = 1\)\%Nodes 
                                    FirstDer[\([k, i]\)]*C\_k[t])\)*
                            C\_i[t]\^mreact + \((\(-\(\(\[Mu] \((T1 - 
                                        T0)\)\)\/\((X1 - X0)\)\^3\)\))\)*\((\
\[Sum]\+\(k = 1\)\%Nodes ThirdDer[\([k, i]\)]*C\_k[t])\))\) /. 
                    x -> \ x1\_i\)}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(EqsSys = 
                  Flatten[
                    Table[{NdEq[i], 
                        C\_i[0] == \((\[CurlyPhi][x] /. 
                              x \[Rule] \ x1\_i)\)}, {i, 2, Nodes - 1}]]\), 
                ";", "\[IndentingNewLine]", \(NdEqsSys = 
                  Join[EqsSys, {\(C\_1'\)[t] \[Equal] 
                        D[InitBoundData[\([1]\)], t], 
                      C\_1[0] == \((\[CurlyPhi][x] /. 
                            x \[Rule] \ x1\_1)\), \(C\_Nodes'\)[t] \[Equal] 
                        D[InitBoundData[\([3]\)], t], 
                      C\_Nodes[
                          0] == \((\[CurlyPhi][x] /. 
                            x \[Rule] \ x1\_Nodes)\)}]\), ";", 
                "\[IndentingNewLine]", \(UnKnown = 
                  Join[Table[C\_i, {i, 1, Nodes}]]\), ";", 
                "\[IndentingNewLine]", \(NumSol = 
                  NDSolve[NdEqsSys, UnKnown, {t, 0, 1}, \ 
                      MaxSteps \[Rule] 10000000] // Flatten\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \( (*\(**\)\(\ \)\(Solution\)\ ***) \),
                 "\[IndentingNewLine]", \(Which[Type === Sinc, 
                  TotSol[x_, 
                      t_] := \[Sum]\+\(k = 1\)\%Nodes\( NumSol[\([k, 2]\)]\)[
                          t]*Sinc[k, x], Type === Lagrange, 
                  TotSol[x_, 
                      t_] := \[Sum]\+\(k = 1\)\%Nodes\( NumSol[\([k, 2]\)]\)[
                          t]*Lagr[k, x]]\), ";", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Print["\<Solution:\>"]\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Plot3D[
                  Evaluate[TotSol[x, t]], {x, 0, 1}, {t, 0, 1}, 
                  PlotPoints \[Rule] \ 81, Boxed \[Rule] \ True, 
                  AxesLabel \[Rule] \ {x, t, u}, PlotRange \[Rule] All]\), 
                ";"}]}], " ", "\[IndentingNewLine]", "]"}]}], ";"}], 
      "\[IndentingNewLine]"}]], "Input"],

Cell[BoxData[
    \(\(\( (*\ 
      One\ Soliton\ Solution\ *) \)\(\[IndentingNewLine]\)\(\
\[IndentingNewLine]\)\(\({T0, T1, X0, X1} = {0, 40, \(-30\), 30};\)\n
    \({Nodes, m, \[Mu], k, x0} = {51, 1, 1. , 0.3, 0};\)\[IndentingNewLine]
    \({A, \[Omega]} = {2 \((m + 1)\) \((m + 2)\) \(m\^\(-2\)\) \[Mu]\ k\^2, 
          4\ \[Mu]\ \(k\^3\) m\^\(-2\)};\)\n
    \(InitCond = \((A\ Sech[k\ \((\((X1 - X0)\) x + X0)\) - \[Omega]\ \((T1 - \
T0)\) t]\^2 - x0)\)\^\(1/m\) //. t \[Rule] 0;\)\n
    \(Bound0Cond = \((A\ Sech[k\ \((\((X1 - X0)\) x + X0)\) - \[Omega]\ \((T1 \
- T0)\) t]\^2 - x0)\)\^\(1/m\) //. x \[Rule] 0;\)\n
    \(Bound1Cond = \((A\ Sech[k\ \((\((X1 - X0)\) x + X0)\) - \[Omega]\ \((T1 \
- T0)\) t]\^2 - x0)\)\^\(1/m\) //. x \[Rule] 1;\)\[IndentingNewLine]
    \(IBData = {Bound0Cond, InitCond, Bound1Cond};\)\)\)\)], "Input"],

Cell[BoxData[
    \(\(KdVIII[IBData, Nodes, \[Mu], m, Sinc];\)\)], "Input"],

Cell[BoxData[
    \(\(\( (*\(\(**\)\(\ \)\(Invariants\)\)\ Calculus\ \((Only\ for\ Sinc\ \
function)\)\ ***) \)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\(tt = {0, 
          0.25, 0.5, 0.75, 1};\)\)\)], "Input"],

Cell[BoxData[
    \(Inv1 = \((X1 - 
            X0)\) \(\[Sum]\+\(i = 1\)\%Nodes\((\(NumSol[\([i, 2]\)]\)[
                tt]*\(\[Sum]\+\(j = 1\)\%Nodes hh*
                  Sinc[i, x1\_j]\))\)\)\)], "Input"],

Cell[BoxData[
    \(Inv2 = \(\(\((X1 - X0)\) 
              hh\)\/2\) \(\[Sum]\+\(j = 1\)\%Nodes\((\[Sum]\+\(i = 1\)\%Nodes\
\((\(NumSol[\([i, 2]\)]\)[tt]*Sinc[i, x1\_j])\))\)\^2\)\)], "Input"],

Cell[BoxData[
    \(Inv3 = \((X1 - X0)\) 
        hh \(\[Sum]\+\(j = 1\)\%Nodes\((\((\[Sum]\+\(i = \
1\)\%Nodes\((\(NumSol[\([i, 2]\)]\)[tt]*Sinc[i, x1\_j])\))\)\^3 + \
\(1\/\(\(2\)\(\ \)\)\) \((\[Sum]\+\(i = 1\)\%Nodes\((\(NumSol[\([i, \
2]\)]\)[tt]*FirstDer[\([i, j]\)]\/\((X1 - X0)\))\))\)\^2)\)\)\)], "Input"],

Cell[BoxData[
    \(Inv4 = \((X1 - X0)\) 
        hh \(\[Sum]\+\(j = 1\)\%Nodes\((5 \((\[Sum]\+\(i = \
1\)\%Nodes\((\(NumSol[\([i, 2]\)]\)[tt]*Sinc[i, x1\_j])\))\)\^4 + 
              10 \((\[Sum]\+\(i = 1\)\%Nodes\((\(NumSol[\([i, 2]\)]\)[tt]*
                        Sinc[i, 
                          x1\_j])\))\) \((\[Sum]\+\(i = \
1\)\%Nodes\((\(NumSol[\([i, 2]\)]\)[tt]*FirstDer[\([i, j]\)]\/\((X1 - \
X0)\))\))\)\^2 + \((\[Sum]\+\(i = 1\)\%Nodes\((\(NumSol[\([i, \
2]\)]\)[tt]*SecondDer[\([i, j]\)]\/\((X1 - X0)\)\^2)\))\)\^2)\)\)\)], "Input"],

Cell[BoxData[
    \(Inv5 = \((X1 - X0)\) 
        hh \(\[Sum]\+\(j = 1\)\%Nodes\((21 \((\[Sum]\+\(i = \
1\)\%Nodes\((\(NumSol[\([i, 2]\)]\)[tt]*Sinc[i, x1\_j])\))\)\^5 + 
              105 \(\((\[Sum]\+\(i = 1\)\%Nodes\((\(NumSol[\([i, 2]\)]\)[tt]*
                            Sinc[i, 
                              x1\_j])\))\)\^2\) \((\[Sum]\+\(i = \
1\)\%Nodes\((\(NumSol[\([i, 2]\)]\)[tt]*FirstDer[\([i, j]\)]\/\((X1 - \
X0)\))\))\)\^2 + 
              21 \((\[Sum]\+\(i = 1\)\%Nodes\((\(NumSol[\([i, 2]\)]\)[tt]*
                        Sinc[i, 
                          x1\_j])\))\) \((\[Sum]\+\(i = \
1\)\%Nodes\((\(NumSol[\([i, 2]\)]\)[tt]*SecondDer[\([i, j]\)]\/\((X1 - \
X0)\)\^2)\))\)\^2 + \((\[Sum]\+\(i = 1\)\%Nodes\((\(NumSol[\([i, \
2]\)]\)[tt]*ThirdDer[\([i, j]\)]\/\((X1 - X0)\)\^3)\))\)\^2)\)\)\)], "Input"],

Cell[BoxData[
    \(\(\( (*\ 
      Two\ Soliton\ Solution\ *) \)\(\[IndentingNewLine]\)\(\({T0, T1, X0, 
          X1} = {0, 360, \(-70\), 70};\)\[IndentingNewLine]
    \({Nodes, m, \[Mu], k1, k2, x1, x2} = {81, 2, 1. , 0.3, 0.2, \(-2\), 
          3};\)\n
    \({A1, 
          A2, \[Omega]1, \[Omega]2} = {2 \((m + 1)\) \((m + 
                2)\) \(m\^\(-2\)\) \[Mu]\ k1\^2, 
          A2 = 2 \((m + 1)\) \((m + 2)\) \(m\^\(-2\)\) \[Mu]\ k2\^2, 
          4\ \[Mu]\ \(k1\^3\) m\^\(-2\), 4\ \[Mu]\ \(k2\^3\) m\^\(-2\)};\)\n
    \(InitCond = \((A1\ Sech[k1\ \((\((X1 - X0)\) x + X0)\) - \[Omega]1\ \
\((T1 - T0)\) t - x1]\^2)\)\^\(1/m\) + \((A2\ Sech[k2\ \((\((X1 - X0)\) x + \
X0)\) - \[Omega]2\ \((T1 - T0)\) t - x2]\^2)\)\^\(1/m\) //. 
          t \[Rule] 0;\)\[IndentingNewLine]
    \(Bound0Cond \[Equal] 0;\)\[IndentingNewLine]
    \(Bound1Cond = 0;\)\[IndentingNewLine]\[IndentingNewLine]
    \(IBData = {Bound0Cond, InitCond, Bound1Cond};\)\)\)\)], "Input"],

Cell[BoxData[
    \(\(KdVIII[IBData, Nodes, \[Mu], m, Sinc];\)\)], "Input"],

Cell[BoxData[
    \(\(\( (*\(\(**\)\(\ \)\(Invariants\)\)\ Calculus\ \((Only\ for\ Sinc\ \
function)\)\ ***) \)\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\(tt = {0, 
          0.25, 0.5, 0.75, 1};\)\)\)], "Input"],

Cell[BoxData[
    \(Inv1 = \((X1 - 
            X0)\) \(\[Sum]\+\(i = 1\)\%Nodes\((\(NumSol[\([i, 2]\)]\)[
                tt]*\(\[Sum]\+\(j = 1\)\%Nodes hh*
                  Sinc[i, x1\_j]\))\)\)\)], "Input"],

Cell[BoxData[
    \(Inv2 = \(\(\((X1 - X0)\) 
              hh\)\/2\) \(\[Sum]\+\(j = 1\)\%Nodes\((\[Sum]\+\(i = 1\)\%Nodes\
\((\(NumSol[\([i, 2]\)]\)[tt]*Sinc[i, x1\_j])\))\)\^2\)\)], "Input"]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1280}, {0, 701}},
Evaluator->"Local",
WindowSize->{1204, 565},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowCellLabel->False,
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 1656, 25, 204, "Input"],
Cell[3413, 78, 194, 3, 52, "Input"],
Cell[3610, 83, 10347, 192, 1747, "Input"],
Cell[13960, 277, 840, 13, 199, "Input"],
Cell[14803, 292, 75, 1, 33, "Input"],
Cell[14881, 295, 216, 3, 71, "Input"],
Cell[15100, 300, 210, 4, 76, "Input"],
Cell[15313, 306, 193, 3, 78, "Input"],
Cell[15509, 311, 313, 5, 79, "Input"],
Cell[15825, 318, 550, 9, 265, "Input"],
Cell[16378, 329, 826, 14, 337, "Input"],
Cell[17207, 345, 967, 17, 191, "Input"],
Cell[18177, 364, 75, 1, 33, "Input"],
Cell[18255, 367, 216, 3, 71, "Input"],
Cell[18474, 372, 210, 4, 76, "Input"],
Cell[18687, 378, 193, 3, 78, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

