(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     32574,        684]*)
(*NotebookOutlinePosition[     33363,        712]*)
(*  CellTagsIndexPosition[     33319,        708]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\( (*\(\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\)\(*\)***********) \)\(\[IndentingNewLine]\)\( (*\ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( \
(*\ Generalized\ Collocation\ \(Methods : 
          Solutions\ to\ Nonlinear\ Problems\)\ \
*) \)\(\[IndentingNewLine]\)\( (*\ Bellomo, \(\(N\)\(.\)\), 
      Lods, \(\(B\)\(.\)\), Revelli, \(\(R\)\(.\)\), 
      Ridolfi, \(\(L\)\(.\)\)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
*) \)\(\[IndentingNewLine]\)\( (*\ 
      A\ Birkh\[ADoubleDot]user\ book\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\
\[IndentingNewLine]\)\( (*\ 
      ISBN : 978 - 0 - 8176 - 4525 - 
          0\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ 
      Program\ OneDLaSiErr\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*******************************************************************) \
\)\)\)], "Input"],

Cell[BoxData[
    \(<< Graphics`MultipleListPlot`\)], "Input"],

Cell[BoxData[{
    \(\($TextStyle = {FontFamily -> "\<Times\>", 
          FontSize \[Rule] 12};\)\), "\[IndentingNewLine]", 
    \(Off[General::"\<spell\>", General::"\<spell1\>"]\)}], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[\(OneDLaSiErr[function_, nodes_, delta_]\),
          FontColor->GrayLevel[0]], 
        StyleBox[":=",
          FontColor->GrayLevel[0]], 
        StyleBox["\[IndentingNewLine]",
          FontColor->GrayLevel[0]], 
        RowBox[{
          StyleBox["Module",
            FontColor->GrayLevel[0]], 
          StyleBox["[",
            FontColor->GrayLevel[0]], 
          RowBox[{
            StyleBox[\({}\),
              FontColor->GrayLevel[0]], 
            StyleBox[",",
              FontColor->GrayLevel[0]], 
            StyleBox["\[IndentingNewLine]",
              FontColor->GrayLevel[0]], 
            RowBox[{
              StyleBox[\(\[CurlyPhi][x_] := function\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[
                0]], \( (*\(\(**\)\(\ \)\(Definition\)\)\ of\ the\ equispaced\
\ and\ Chebyshev\ collocation\ ***) \), "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              StyleBox[\(hh = 1\/\(nodes - 1\)\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox[\(x\_i_ := \((i - 1)\)*hh\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              
              StyleBox[\(x1\_i_ := \(-\(1\/2\)\) \((Cos[\((i - 
                                1)\)*\[Pi]\/\(nodes - 1\)] - 1)\)\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[
                0]], \( (*\(\(**\)\(\ \)\(Lagrange\)\)\ polynomial\ with\ \
Chebyshev\ collocation\ ***) \), "\[IndentingNewLine]", 
              StyleBox["\t",
                FontColor->GrayLevel[0]], 
              
              StyleBox[\(Lagr1[j_, 
                    x_] := \[Product]\+\(p = 1\)\%nodes\((If[
                        p \[NotEqual] j, \(x - x1\_p\)\/\(x1\_j - x1\_p\), 
                        1])\)\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\t",
                FontColor->GrayLevel[0]], 
              
              StyleBox[\(FunctionLagr1[
                    x_] := \[Sum]\+\(k = 1\)\%nodes\((\((\[CurlyPhi][x] /. 
                            x \[Rule] \ x1\_k)\)*\ Lagr1[k, x])\)\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[
                0]], \( (*\(\(**\)\(\ \)\(Sinc\)\)\ function\ ***) \), 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\t",
                FontColor->GrayLevel[0]], 
              
              StyleBox[\(Sinc[j_, x_] := 
                  Which[0 \[LessEqual] x \[LessEqual] 1\  && \ 
                      x \[NotEqual] \((j - 1)\)*hh, 
                    Sin[\(\[Pi]*\((x - \((j - \
1)\)*hh)\)\)\/hh]/\((\(\[Pi]*\((x - \((j - 1)\)*hh)\)\)\/hh)\), 
                    x == \((j - 1)\)*hh, \ 1]\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\t",
                FontColor->GrayLevel[0]], 
              
              StyleBox[\(FunctionSinc[
                    x_] := \[Sum]\+\(k = 1\)\%nodes\((\[CurlyPhi][x] /. 
                          x -> x\_k)\)*Sinc[k, x]\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[
                0]], \( (*\(\(**\)\(\ \)\(Error\)\)\ Evaluation\ ***) \), 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              RowBox[{
                StyleBox["ErrSinc",
                  FontColor->GrayLevel[0]], 
                "=", \(Table[
                  Evaluate[Abs[\[CurlyPhi][x] - FunctionSinc[x]]], {x, 0, 1, 
                    delta}]\)}], ";", "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["ErrLagr",
                  FontColor->GrayLevel[0]], 
                "=", \(Table[
                  Evaluate[Abs[\[CurlyPhi][x] - FunctionLagr1[x]]], {x, 0, 1, 
                    delta}]\)}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \({MaxSinc, MaxLagr} = {Max[ErrSinc], 
                  Max[ErrLagr]}\), ";", 
              "\[IndentingNewLine]", \({MeanSinc, MeanLagr} = {Mean[ErrSinc], 
                  Mean[ErrLagr]}\), ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(Print["\<Nodes \>", "\< MaxSinc \>", "\
\< MaxLagr \>", "\< MeanSinc \>", "\< MeanLagr \>"]\), 
              ";", \(Print[nodes, "\< \>", MaxSinc, "\< \>", 
                MaxLagr, "\< \>", MeanSinc, "\< \>", MeanLagr]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(ErrorMax[nodes] = {nodes, MaxSinc, 
                  MaxLagr}\), ";", 
              "\[IndentingNewLine]", \(ErrorMean[nodes] = {nodes, MeanSinc, 
                  MeanLagr}\), ";"}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
    \( (********************************************************) \)], "Input"],

Cell[BoxData[{
    \(\({function, MinNodes, MaxNodes, 
          delta} = {Exp[\(-2\) \((10  x - 5)\)\^2], 2, 41, 
          0.001};\)\), "\[IndentingNewLine]", 
    \(\(For[i = MinNodes, i < MaxNodes, OneDLaSiErr[function, i, delta]; 
        i = i + 1];\)\)}], "Input"],

Cell[BoxData[{
    \(\(SincMaxEven = 
        Table[{\(ErrorMax[j]\)[\([1]\)], \(ErrorMax[j]\)[\([2]\)]}, {j, 
            MinNodes, MaxNodes, 2}];\)\), "\[IndentingNewLine]", 
    \(\(LagrMaxEven = 
        Table[{\(ErrorMax[j]\)[\([1]\)], \(ErrorMax[j]\)[\([3]\)]}, {j, 
            MinNodes, MaxNodes, 2}];\)\), "\[IndentingNewLine]", 
    \(\(SincMeanEven = 
        Table[{\(ErrorMean[j]\)[\([1]\)], \(ErrorMean[j]\)[\([2]\)]}, {j, 
            MinNodes, MaxNodes, 2}];\)\), "\[IndentingNewLine]", 
    \(\(LagrMeanEven = 
        Table[{\(ErrorMean[j]\)[\([1]\)], \(ErrorMean[j]\)[\([3]\)]}, {j, 
            MinNodes, MaxNodes, 2}];\)\)}], "Input"],

Cell[BoxData[{
    \(\(SincMaxOdd = 
        Table[{\(ErrorMax[j]\)[\([1]\)], \(ErrorMax[j]\)[\([2]\)]}, {j, 
            MinNodes + 1, MaxNodes - 1, 2}];\)\), "\[IndentingNewLine]", 
    \(\(LagrMaxOdd = 
        Table[{\(ErrorMax[j]\)[\([1]\)], \(ErrorMax[j]\)[\([3]\)]}, {j, 
            MinNodes + 1, MaxNodes - 1, 2}];\)\), "\[IndentingNewLine]", 
    \(\(SincMeanOdd = 
        Table[{\(ErrorMean[j]\)[\([1]\)], \(ErrorMean[j]\)[\([2]\)]}, {j, 
            MinNodes + 1, MaxNodes - 1, 2}];\)\), "\[IndentingNewLine]", 
    \(\(LagrMeanOdd = 
        Table[{\(ErrorMean[j]\)[\([1]\)], \(ErrorMean[j]\)[\([3]\)]}, {j, 
            MinNodes + 1, MaxNodes - 1, 2}];\)\)}], "Input"],

Cell[BoxData[
    RowBox[{\( (*\(\(**\)\(\ \)\(Max\)\)\ \ Error\ for\ even\ number\ of\ \
nodes\ ***) \), "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
        RowBox[{
          RowBox[{"p1a", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "SincMaxEven", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      1.05}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {1, 1, 
                        0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", "\n", 
        RowBox[{
          RowBox[{"p1b", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "LagrMaxEven", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      1.05}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {1, 1, 
                        0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0], 
                    Dashing[{Dash, Dash}]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\n", 
        "\[IndentingNewLine]", \(p1 = 
            Show[{p1a, p1b}, 
              DisplayFunction \[Rule] $DisplayFunction];\)}]}]], "Input"],

Cell[BoxData[
    RowBox[{\( (*\(\(**\)\(\ \)\(Max\)\)\ \ Error\ for\ odd\ number\ of\ \
nodes\ ***) \), "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
        RowBox[{
          RowBox[{"p2a", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "SincMaxOdd", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      1.05}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {1, 1, 
                        0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\n", 
        RowBox[{
          RowBox[{"p2b", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "LagrMaxOdd", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      1.05}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {1, 1, 
                        0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0], 
                    Dashing[{Dash, Dash}]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", \(p2 = 
            Show[{p2a, p2b}, 
              DisplayFunction \[Rule] $DisplayFunction];\)}]}]], "Input"],

Cell[BoxData[
    RowBox[{\( (*\(\(**\)\(\ \)\(Mean\)\)\ \ Error\ for\ even\ number\ of\ \
nodes\ ***) \), "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
        RowBox[{
          RowBox[{"p3a", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "SincMeanEven", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      0.65}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {0.6, 
                        0.6, 0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\_1\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", 
        RowBox[{
          RowBox[{"p3b", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "LagrMeanEven", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      0.65}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {0.6, 
                        0.6, 0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0], 
                    Dashing[{Dash, Dash}]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\_1\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", \(p3 = 
            Show[{p3a, p3b}, 
              DisplayFunction \[Rule] $DisplayFunction];\)}]}]], "Input"],

Cell[BoxData[
    RowBox[{\( (*\(\(**\)\(\ \)\(Mean\)\)\ \ Error\ for\ odd\ number\ of\ \
nodes\ ***) \), "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
        RowBox[{
          RowBox[{"p4a", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "SincMeanOdd", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      0.65}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {0.6, 
                        0.6, 0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\_1\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", 
        RowBox[{
          RowBox[{"p4b", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "LagrMeanOdd", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      0.65}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {0.6, 
                        0.6, 0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0], 
                    Dashing[{Dash, Dash}]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\_1\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", \(p4 = 
            Show[{p4a, p4b}, 
              DisplayFunction \[Rule] $DisplayFunction];\)}]}]], "Input"],

Cell[BoxData[{
    \(\({function, MinNodes, MaxNodes, 
          delta} = {Tanh[10  x - 5. ] + 0.2  Sin[\[Pi]\ \((10  x - 5. )\)], 
          2, 41, 0.001};\)\), "\[IndentingNewLine]", 
    \(For[i = MinNodes, i < MaxNodes, OneDLaSiErr[function, i, delta]; 
      i = i + 1]\)}], "Input"],

Cell[BoxData[{
    \(\(SincMaxEven = 
        Table[{\(ErrorMax[j]\)[\([1]\)], \(ErrorMax[j]\)[\([2]\)]}, {j, 
            MinNodes, MaxNodes, 2}];\)\), "\[IndentingNewLine]", 
    \(\(LagrMaxEven = 
        Table[{\(ErrorMax[j]\)[\([1]\)], \(ErrorMax[j]\)[\([3]\)]}, {j, 
            MinNodes, MaxNodes, 2}];\)\), "\[IndentingNewLine]", 
    \(\(SincMeanEven = 
        Table[{\(ErrorMean[j]\)[\([1]\)], \(ErrorMean[j]\)[\([2]\)]}, {j, 
            MinNodes, MaxNodes, 2}];\)\), "\[IndentingNewLine]", 
    \(\(LagrMeanEven = 
        Table[{\(ErrorMean[j]\)[\([1]\)], \(ErrorMean[j]\)[\([3]\)]}, {j, 
            MinNodes, MaxNodes, 2}];\)\)}], "Input"],

Cell[BoxData[{
    \(\(SincMaxOdd = 
        Table[{\(ErrorMax[j]\)[\([1]\)], \(ErrorMax[j]\)[\([2]\)]}, {j, 
            MinNodes + 1, MaxNodes - 1, 2}];\)\), "\[IndentingNewLine]", 
    \(\(LagrMaxOdd = 
        Table[{\(ErrorMax[j]\)[\([1]\)], \(ErrorMax[j]\)[\([3]\)]}, {j, 
            MinNodes + 1, MaxNodes - 1, 2}];\)\), "\[IndentingNewLine]", 
    \(\(SincMeanOdd = 
        Table[{\(ErrorMean[j]\)[\([1]\)], \(ErrorMean[j]\)[\([2]\)]}, {j, 
            MinNodes + 1, MaxNodes - 1, 2}];\)\), "\[IndentingNewLine]", 
    \(\(LagrMeanOdd = 
        Table[{\(ErrorMean[j]\)[\([1]\)], \(ErrorMean[j]\)[\([3]\)]}, {j, 
            MinNodes + 1, MaxNodes - 1, 2}];\)\)}], "Input"],

Cell[BoxData[
    RowBox[{\( (*\(\(**\)\(\ \)\(Max\)\)\ \ Error\ for\ Sinc\ ***) \), 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
        RowBox[{
          RowBox[{"p1a", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "SincMaxEven", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      1.05}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {1, 1, 
                        0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", 
        RowBox[{
          RowBox[{"p1b", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "SincMaxOdd", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      1.05}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {1, 1, 
                        0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0], 
                    Dashing[{Dash, Dash}]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", \(p1 = 
            Show[{p1a, p1b}, 
              DisplayFunction \[Rule] $DisplayFunction];\)}]}]], "Input"],

Cell[BoxData[
    RowBox[{\( (*\(\(**\)\(\ \)\(Max\)\)\ \ Error\ for\ Lagrange\ ***) \), 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
        RowBox[{
          RowBox[{"p2a", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "LagrMaxEven", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      1.05}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {1, 1, 
                        0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", 
        RowBox[{
          RowBox[{"p2b", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "LagrMaxOdd", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      1.05}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {1, 1, 
                        0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0], 
                    Dashing[{Dash, Dash}]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\n", \(p2 = 
            Show[{p2a, p2b}, 
              DisplayFunction \[Rule] $DisplayFunction];\)}]}]], "Input"],

Cell[BoxData[
    RowBox[{\( (*\(\(**\)\(\ \)\(Mean\)\)\ \ Error\ for\ Sinc\ ***) \), 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
        RowBox[{
          RowBox[{"p3a", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "SincMeanEven", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      0.65}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {0.6, 
                        0.6, 0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\_1\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", 
        RowBox[{
          RowBox[{"p3b", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "SincMeanOdd", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      0.65}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {0.6, 
                        0.6, 0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0], 
                    Dashing[{Dash, Dash}]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\_1\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", \(p3 = 
            Show[{p3a, p3b}, 
              DisplayFunction \[Rule] $DisplayFunction];\)}]}]], "Input"],

Cell[BoxData[
    RowBox[{\( (*\(\(**\)\(\ \)\(Mean\)\)\ \ Error\ for\ Lagrange\ ***) \), 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
        RowBox[{
          RowBox[{"p4a", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "LagrMeanEven", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      0.65}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {0.6, 
                        0.6, 0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\_1\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", 
        RowBox[{
          RowBox[{"p4b", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "LagrMeanOdd", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      0.65}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {0.6, 
                        0.6, 0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0], 
                    Dashing[{Dash, Dash}]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\_1\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", \(p4 = 
            Show[{p4a, p4b}, 
              DisplayFunction \[Rule] $DisplayFunction];\)}]}]], "Input"]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1280}, {0, 701}},
WindowToolbars->"RulerBar",
Evaluator->"Local",
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowCellLabel->False,
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 1649, 24, 204, "Input"],
Cell[3406, 77, 62, 1, 33, "Input"],
Cell[3471, 80, 194, 3, 52, "Input"],
Cell[3668, 85, 6188, 139, 836, "Input"],
Cell[9859, 226, 93, 1, 33, "Input"],
Cell[9955, 229, 271, 5, 55, "Input"],
Cell[10229, 236, 655, 12, 90, "Input"],
Cell[10887, 250, 683, 12, 90, "Input"],
Cell[11573, 264, 2439, 47, 318, "Input"],
Cell[14015, 313, 2398, 46, 280, "Input"],
Cell[16416, 361, 2435, 46, 280, "Input"],
Cell[18854, 409, 2432, 46, 280, "Input"],
Cell[21289, 457, 288, 5, 52, "Input"],
Cell[21580, 464, 655, 12, 90, "Input"],
Cell[22238, 478, 683, 12, 90, "Input"],
Cell[22924, 492, 2403, 46, 280, "Input"],
Cell[25330, 540, 2390, 46, 280, "Input"],
Cell[27723, 588, 2420, 46, 280, "Input"],
Cell[30146, 636, 2424, 46, 280, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

