(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13354,        289]*)
(*NotebookOutlinePosition[     14143,        317]*)
(*  CellTagsIndexPosition[     14099,        313]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\( (*\(\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\)\(*\)***********) \)\(\[IndentingNewLine]\)\( (*\ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( \
(*\ Generalized\ Collocation\ \(Methods : 
          Solutions\ to\ Nonlinear\ Problems\)\ \
*) \)\(\[IndentingNewLine]\)\( (*\ Bellomo, \(\(N\)\(.\)\), 
      Lods, \(\(B\)\(.\)\), Revelli, \(\(R\)\(.\)\), 
      Ridolfi, \(\(L\)\(.\)\)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
*) \)\(\[IndentingNewLine]\)\( (*\ 
      A\ Birkh\[ADoubleDot]user\ book\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\
\[IndentingNewLine]\)\( (*\ 
      ISBN : 978 - 0 - 8176 - 4525 - 
          0\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ 
      Program\ OneDLaSiInt\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*******************************************************************) \
\)\)\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[\(OneDLaSiInt[function_, nodes_]\),
          FontColor->GrayLevel[0]], 
        StyleBox[":=",
          FontColor->GrayLevel[0]], 
        StyleBox["\[IndentingNewLine]",
          FontColor->GrayLevel[0]], 
        RowBox[{
          StyleBox["Module",
            FontColor->GrayLevel[0]], 
          StyleBox["[",
            FontColor->GrayLevel[0]], 
          RowBox[{
            StyleBox[\({}\),
              FontColor->GrayLevel[0]], 
            StyleBox[",",
              FontColor->GrayLevel[0]], 
            StyleBox["\[IndentingNewLine]",
              FontColor->GrayLevel[0]], 
            RowBox[{
              StyleBox[\(\[CurlyPhi][x_] := function\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[
                0]], \( (*\(\(**\)\(\ \)\(Definition\)\)\ of\ the\ equispaced\
\ and\ Chebyshev\ collocation\ ***) \), "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              StyleBox[\(hh = 1\/\(nodes - 1\)\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox[\(x\_i_ := \((i - 1)\)*hh\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              
              StyleBox[\(x1\_i_ := \(-\(1\/2\)\) \((Cos[\((i - 
                                1)\)*\[Pi]\/\(nodes - 1\)] - 1)\)\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[
                0]], \( (*\(\(**\)\(\ \)\(Lagrange\)\)\ polynomial\ with\ \
Chebyshev\ collocation\ ***) \), "\[IndentingNewLine]", 
              StyleBox["\t",
                FontColor->GrayLevel[0]], 
              
              StyleBox[\(Lagr1[j_, 
                    x_] := \[Product]\+\(p = 1\)\%nodes\((If[
                        p \[NotEqual] j, \(x - x1\_p\)\/\(x1\_j - x1\_p\), 
                        1])\)\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\t",
                FontColor->GrayLevel[0]], 
              
              StyleBox[\(FunctionLagr1[
                    x_] := \[Sum]\+\(k = 1\)\%nodes\((\((\[CurlyPhi][x] /. 
                            x \[Rule] \ x1\_k)\)*\ Lagr1[k, x])\)\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[
                0]], \( (*\(\(**\)\(\ \)\(Sinc\)\)\ function\ ***) \), 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\t",
                FontColor->GrayLevel[0]], 
              
              StyleBox[\(Sinc[j_, x_] := 
                  Which[0 \[LessEqual] x \[LessEqual] 1\  && \ 
                      x \[NotEqual] \((j - 1)\)*hh, 
                    Sin[\(\[Pi]*\((x - \((j - \
1)\)*hh)\)\)\/hh]/\((\(\[Pi]*\((x - \((j - 1)\)*hh)\)\)\/hh)\), 
                    x == \((j - 1)\)*hh, \ 1]\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\t",
                FontColor->GrayLevel[0]], 
              
              StyleBox[\(FunctionSinc[
                    x_] := \[Sum]\+\(k = 1\)\%nodes\((\[CurlyPhi][x] /. 
                          x -> x\_k)\)*Sinc[k, x]\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[
                0]], \( (*\(\(**\)\(\ \)\(Derivative\)\)\ Values\ ***) \), 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(Initder1Lagr1[
                  x_] := \((\[Sum]\+\(k = 1\)\%nodes\((\((\[CurlyPhi][x] /. 
                            x -> x1\_k)\)*D[Lagr1[k, x], \ x])\))\)\), ";", 
              "\[IndentingNewLine]", \(Initder2Lagr1[
                  x_] := \((\[Sum]\+\(k = 1\)\%nodes\((\((\[CurlyPhi][x] /. 
                            x -> x1\_k)\)*D[Lagr1[k, x], {x, 2}])\))\)\), ";",
               "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(Initder1Sinc[
                  x_] := \((\[Sum]\+\(k = 1\)\%nodes\((\((\[CurlyPhi][x] /. 
                            x -> x\_k)\)*D[Sinc[k, x], x])\))\)\), ";", 
              "\[IndentingNewLine]", \(Initder2Sinc[
                  x_] := \((\[Sum]\+\(k = 1\)\%nodes\((\((\[CurlyPhi][x] /. 
                            x -> x\_k)\)*D[Sinc[k, x], {x, 2}])\))\)\), ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              RowBox[{"Plot", "[", 
                
                RowBox[{\(Evaluate[{\[CurlyPhi][x], FunctionLagr1[x], 
                      FunctionSinc[x]}]\), ",", \({x, 0, 1}\), 
                  ",", \(PlotRange \[Rule] \ All\), 
                  ",", \(PlotStyle \[Rule] {Dashing[{0.0}], {Dashing[{0.001, 
                            0.005}]}, {Dashing[{0.02, 0.008}]}}\), ",", 
                  RowBox[{"FrameLabel", "\[Rule]", " ", 
                    RowBox[{"{", 
                      RowBox[{"\"\<\!\(\*
StyleBox[\"x\",\nFontSlant->\"Italic\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"v\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"(\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"x\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\")\",\nFontSlant->\"Italic\"]\)\>\""}], "}"}]}], 
                  ",", \(AxesOrigin \[Rule] \ {0, \(-1.12\)}\), 
                  ",", \(Frame \[Rule] True\), 
                  ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {0.5, 
                          0.5,  .02}, {1, 1, 
                          0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {1, 
                          1, 0.02}}, None, None}\)}], "]"}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"Plot", "[", 
                
                RowBox[{\(Evaluate[{\((\[PartialD]\_x \[CurlyPhi][x])\), 
                      Initder1Lagr1[x], Initder1Sinc[x]}]\), 
                  ",", \({x, 0, 1}\), ",", \(PlotRange \[Rule] All\), 
                  ",", \(PlotStyle \[Rule] {Dashing[{0.0}], 
                      Dashing[{0.001, 0.005}], Dashing[{0.02, 0.008}]}\), ",",
                   
                  RowBox[{"FrameLabel", "\[Rule]", " ", 
                    RowBox[{"{", 
                      RowBox[{"\"\<\!\(\*
StyleBox[\"x\",\nFontSlant->\"Italic\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\(v\_x\),\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"(\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"x\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\")\",\nFontSlant->\"Italic\"]\)\>\""}], "}"}]}], 
                  ",", \(Frame \[Rule] True\), 
                  ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {0.5, 
                          0.5,  .02}, {1, 1, 
                          0.02}}, {{\(-10\), \(-10\),  .02}, {0, 
                          0,  .02}, {10, 10, 0.02}}, None, None}\)}], "]"}], 
              ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"Plot", "[", 
                
                RowBox[{\(Evaluate[{\((\[PartialD]\_\(x, x\)\[CurlyPhi][
                            x])\), Initder2Lagr1[x], Initder2Sinc[x]}]\), 
                  ",", \({x, 0, 1}\), 
                  ",", \(PlotRange \[Rule] {{\(-0.01\), 1}, {\(-410\), 
                        410}}\), 
                  ",", \(PlotStyle \[Rule] {Dashing[{0.0}], 
                      Dashing[{0.001, 0.005}], Dashing[{0.02, 0.008}]}\), ",",
                   
                  RowBox[{"FrameLabel", "\[Rule]", " ", 
                    RowBox[{"{", 
                      RowBox[{"\"\<\!\(\*
StyleBox[\"x\",\nFontSlant->\"Italic\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\(v\_xx\),\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"(\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"x\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\")\",\nFontSlant->\"Italic\"]\)\>\""}], "}"}]}], 
                  ",", \(Frame \[Rule] True\), 
                  ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {0.5, 
                          0.5,  .02}, {1, 1, 
                          0.02}}, {{\(-400\), \(-400\),  .02}, {0, 
                          0,  .02}, {400, 400, 0.02}}, None, None}\)}], "]"}],
               ";"}]}], 
          StyleBox["\[IndentingNewLine]",
            FontColor->GrayLevel[0]], 
          StyleBox["\[IndentingNewLine]",
            FontColor->GrayLevel[0]], "]"}]}], ";"}]], "Input"],

Cell[BoxData[{
    \(\({function, nodes} = {Exp[\(-2\) \((10  x - 5)\)\^2], 
          21};\)\), "\[IndentingNewLine]", 
    \(OneDLaSiInt[function, nodes]\)}], "Input"],

Cell[BoxData[{
    \(\({function, 
          nodes} = {Tanh[10  x - 5. ] + 0.2  Sin[\[Pi]\ \((10  x - 5. )\)], 
          21};\)\), "\[IndentingNewLine]", 
    \(OneDLaSiInt[function, nodes]\)}], "Input"]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1280}, {0, 701}},
WindowToolbars->"RulerBar",
Evaluator->"Local",
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowCellLabel->False,
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 1649, 24, 204, "Input"],
Cell[3406, 77, 9565, 199, 1311, "Input"],
Cell[12974, 278, 169, 3, 55, "Input"],
Cell[13146, 283, 204, 4, 52, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

