(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9559,        221]*)
(*NotebookOutlinePosition[     10343,        249]*)
(*  CellTagsIndexPosition[     10299,        245]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\( (*\(\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\)\(*\)***********) \)\(\[IndentingNewLine]\)\( (*\ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( \
(*\ Generalized\ Collocation\ \(Methods : 
          Solutions\ to\ Nonlinear\ Problems\)\ \
*) \)\(\[IndentingNewLine]\)\( (*\ Bellomo, \(\(N\)\(.\)\), 
      Lods, \(\(B\)\(.\)\), Revelli, \(\(R\)\(.\)\), 
      Ridolfi, \(\(L\)\(.\)\)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
*) \)\(\[IndentingNewLine]\)\( (*\ 
      A\ Birkh\[ADoubleDot]user\ book\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\
\[IndentingNewLine]\)\( (*\ 
      ISBN : 978 - 0 - 8176 - 4525 - 
          0\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ 
      Program\ OneDLag\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\
\( (*******************************************************************) \)\)\
\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[\(OneDLag[function_, nodes_]\),
          FontColor->GrayLevel[0]], 
        StyleBox[":=",
          FontColor->GrayLevel[0]], 
        StyleBox["\[IndentingNewLine]",
          FontColor->GrayLevel[0]], 
        RowBox[{
          StyleBox["Module",
            FontColor->GrayLevel[0]], 
          StyleBox["[",
            FontColor->GrayLevel[0]], 
          RowBox[{
            StyleBox[\({}\),
              FontColor->GrayLevel[0]], 
            StyleBox[",",
              FontColor->GrayLevel[0]], 
            StyleBox["\[IndentingNewLine]",
              FontColor->GrayLevel[0]], 
            RowBox[{
              StyleBox[\(\[CurlyPhi][x_] := function\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[
                0]], \( (*\(\(**\)\(\ \)\(Definition\)\)\ of\ the\ equispaced\
\ and\ Chebyshev\ collocation\ ***) \), "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              StyleBox[\(hh = 1\/\(nodes - 1\)\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox[\(x\_i_ := \((i - 1)\)*hh\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              
              StyleBox[\(x1\_i_ := \(-\(1\/2\)\) \((Cos[\((i - 
                                1)\)*\[Pi]\/\(nodes - 1\)] - 1)\)\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[
                0]], \( (*\(\(**\)\(\ \)\(Lagrange\)\)\ polynomial\ with\ \
Chebyshev\ collocation\ ***) \), "\[IndentingNewLine]", 
              StyleBox["\t",
                FontColor->GrayLevel[0]], 
              
              StyleBox[\(Lagr1[j_, 
                    x_] := \[Product]\+\(p = 1\)\%nodes\((If[
                        p \[NotEqual] j, \(x - x1\_p\)\/\(x1\_j - x1\_p\), 
                        1])\)\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\t",
                FontColor->GrayLevel[0]], 
              
              StyleBox[\(FuncLagr1[
                    x_] := \[Sum]\+\(k = 1\)\%nodes\((\((\[CurlyPhi][x] /. 
                            x \[Rule] \ x1\_k)\)*\ Lagr1[k, x])\)\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[
                0]], \( (*\(\(**\)\(\ \)\(Lagrange\)\)\ polynomial\ with\ \
equispaced\ collocation\ ***) \), 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\t",
                FontColor->GrayLevel[0]], 
              
              StyleBox[\(Lagr2[j_, 
                    x_] := \[Product]\+\(p = 1\)\%nodes\((If[
                        p \[NotEqual] j, \(x - x\_p\)\/\(x\_j - x\_p\), 
                        1])\)\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\t",
                FontColor->GrayLevel[0]], 
              
              StyleBox[\(FuncLagr2[
                    x_] := \[Sum]\+\(k = 1\)\%nodes\((\((\[CurlyPhi][x] /. 
                            x \[Rule] \ x\_k)\)*Lagr2[k, x])\)\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[
                0]], \( (*\(\(**\)\(\ \)\(Plot\)\)\ of\ the\ results\ ***) \),
               "\[IndentingNewLine]", 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              RowBox[{"Plot", "[", 
                
                RowBox[{\(Evaluate[{\[CurlyPhi][x], FuncLagr1[x], 
                      FuncLagr2[x]}]\), ",", \({x, 0, 1}\), 
                  ",", \(PlotRange \[Rule] \ All\), 
                  ",", \(PlotStyle \[Rule] {Dashing[{0.0}], {Dashing[{0.001, 
                            0.005}]}, {Dashing[{0.02, 0.008}]}}\), ",", 
                  RowBox[{"FrameLabel", "\[Rule]", " ", 
                    RowBox[{"{", 
                      RowBox[{"\"\<\!\(\*
StyleBox[\"x\",\nFontSlant->\"Italic\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"u\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"(\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"x\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\")\",\nFontSlant->\"Italic\"]\)\>\""}], "}"}]}], 
                  ",", \(AxesOrigin \[Rule] \ {0, 0}\), 
                  ",", \(Frame \[Rule] True\), 
                  ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {0.5, 
                          0.5,  .02}, {1, 1, 
                          0.02}}, {{\(-4\), \(-4\),  .02}, {0, 0,  .02}, {4, 
                          4, 0.02}}, None, None}\)}], "]"}], ";"}]}], 
          StyleBox["\[IndentingNewLine]",
            FontColor->GrayLevel[0]], 
          StyleBox["\[IndentingNewLine]",
            FontColor->GrayLevel[0]], "]"}]}], ";"}]], "Input"],

Cell[BoxData[{
    \(\({function, 
          nodes} = {Tanh[10  x - 5] + 0.2  Sin[\[Pi]\ \((10  x - 5. )\)], 
          21};\)\), "\[IndentingNewLine]", 
    \(OneDLag[function, nodes]\)}], "Input"]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1280}, {0, 701}},
WindowToolbars->"RulerBar",
Evaluator->"Local",
WindowSize->{1176, 635},
WindowMargins->{{Automatic, 19}, {-11, Automatic}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
ShowCellLabel->False,
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 1655, 25, 204, "Input"],
Cell[3412, 78, 5942, 135, 718, "Input"],
Cell[9357, 215, 198, 4, 52, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

