(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14650,        294]*)
(*NotebookOutlinePosition[     15403,        321]*)
(*  CellTagsIndexPosition[     15359,        317]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\( (*\(\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\)\(*\)***********) \)\(\[IndentingNewLine]\)\( (*\ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( \
(*\ Generalized\ Collocation\ \(Methods : 
          Solutions\ to\ Nonlinear\ Problems\)\ \
*) \)\(\[IndentingNewLine]\)\( (*\ Bellomo, \(\(N\)\(.\)\), 
      Lods, \(\(B\)\(.\)\), Revelli, \(\(R\)\(.\)\), 
      Ridolfi, \(\(L\)\(.\)\)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
*) \)\(\[IndentingNewLine]\)\( (*\ 
      A\ Birkh\[ADoubleDot]user\ book\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\
\[IndentingNewLine]\)\( (*\ 
      ISBN : 978 - 0 - 8176 - 4525 - 
          0\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ 
      Program\ Traffic1\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\
\( (*******************************************************************) \)\)\
\)], "Input"],

Cell[BoxData[{
    \(\($TextStyle = {FontFamily -> "\<Times\>", 
          FontSize \[Rule] 12};\)\), "\[IndentingNewLine]", 
    \(Off[General::"\<spell\>", General::"\<spell1\>"]\)}], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{\(Traffic1[InitBoundData_, Nodes_, \[Eta]_, Type_]\), ":=", 
          RowBox[{"Module", "[", 
            
            RowBox[{\({}\), ",", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \( (*\(\(**\)\(\ \)\(INITIAL\)\)\ \
CONDITION\ ***) \), "\[IndentingNewLine]", "\[IndentingNewLine]", 
              
              RowBox[{\(\[CurlyPhi][x_] := InitBoundData[\([2]\)]\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(hh = 1\/\(Nodes - 1\)\), ";", 
                StyleBox["\[IndentingNewLine]",
                  FontColor->RGBColor[1, 0, 0]], "\[IndentingNewLine]", 
                RowBox[{"Which", "[", 
                  
                  RowBox[{\(Type === Sinc\), 
                    ",", \(x1\_i_ := \((i - 1)\)*hh\), 
                    ",", \(Type === Lagrange\), ",", 
                    
                    StyleBox[\(x1\_i_ := \(-\(1\/2. \)\) \((Cos[\((i - 
                                      1)\)*\[Pi]\/\(Nodes - 1\)] - 1)\)\),
                      FontColor->GrayLevel[0]]}], "]"}], ";", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                  RowBox[{\(Type === Lagrange\), ",", 
                    RowBox[{
                      
                      StyleBox[\(Lagr[j_, 
                            x_] := \[Product]\+\(p = 1\)\%Nodes\((If[
                                p \[NotEqual] 
                                  j, \(x - x1\_p\)\/\(x1\_j - x1\_p\), 
                                1])\)\),
                        FontColor->GrayLevel[0]], 
                      StyleBox[";",
                        FontColor->GrayLevel[0]], 
                      RowBox[{\(InitValue[x_]\), ":=", 
                        
                        StyleBox[\(\[Sum]\+\(k = 1\)\%Nodes\((\[CurlyPhi][x] /. 
                                  x \[Rule] \ x1\_k)\)*Lagr[k, x]\),
                          FontColor->GrayLevel[0]]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\t",
                  FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                  RowBox[{\(Type === Sinc\), ",", 
                    RowBox[{
                      
                      StyleBox[\(Sinc[j_, x_] := 
                          Which[0 \[LessEqual] x \[LessEqual] 1\  && \ 
                              x \[NotEqual] \((j - 1)\)*hh, 
                            Sin[\(\[Pi]*\((x - \((j - 1)\)*hh)\)\)\/hh]/\((\(\
\[Pi]*\((x - \((j - 1)\)*hh)\)\)\/hh)\), x == \((j - 1)\)*hh, \ 1]\),
                        FontColor->GrayLevel[0]], 
                      StyleBox[";",
                        FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
                      StyleBox[
                        RowBox[{\(InitValue[x_]\), ":=", 
                          RowBox[{\(\[Sum]\+\(k = 1\)\%Nodes\), 
                            RowBox[{
                              RowBox[{"(", 
                                RowBox[{\(\[CurlyPhi][x]\), "/.", 
                                  RowBox[{"x", "->", 
                                    SubscriptBox[
                                      StyleBox[
                                        RowBox[{"x", 
                                        StyleBox["1",
                                        FontColor->GrayLevel[0]]}]], "k"]}]}],
                                 ")"}], "*", \(Sinc[k, x]\)}]}]}],
                        FontColor->GrayLevel[0]]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], "\t", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Print["\<Initial condition \
interpolation:\>"]\), ";", 
                "\[IndentingNewLine]", \(Plot[
                  Evaluate[{\[CurlyPhi][x], InitValue[x]}], {x, 0, 1}, 
                  PlotRange \[Rule] {Automatic, {0, 1}}, 
                  PlotStyle \[Rule] {GrayLevel[0], Dashing[{0.15, 0.05}]}, 
                  AxesLabel \[Rule] \ {x, u[x, 0]}]\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Print["\<Don't worry! I'm \
working\>"]\), ";", "\[IndentingNewLine]", 
                RowBox[{
                  StyleBox["(*",
                    FontColor->GrayLevel[0]], 
                  StyleBox[\(\(\(**\)\(\ \)\(DERIVATIVE\)\)\ MATRICES\)], 
                  StyleBox[" "], 
                  StyleBox["***)"]}], "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(If[
                  Type === Lagrange, \[IndentingNewLine]FDM[j_, i_] := 
                    Which[i == 
                        j, \[Sum]\+\(k = 1\)\%Nodes If[k == i, 0, 
                          1\/\(x1\_i - x1\_k\)], 
                      i != j, \((\[Product]\+\(p = 1\)\%Nodes\((If[
                                p \[Equal] i, 1, 
                                x1\_i - x1\_p])\))\)/\((\((x1\_i - 
                                x1\_j)\) \(\[Product]\+\(p = 1\)\%Nodes\((If[
                                  p \[Equal] j, 1, 
                                  x1\_j - 
                                    x1\_p])\)\))\)]; \[IndentingNewLine]\
\[IndentingNewLine]FirstDer = 
                    Table[FDM[j, i], {j, 1, Nodes}, {i, 1, 
                        Nodes}]; \[IndentingNewLine]SecondDer = 
                    Table[If[i \[NotEqual] j, 
                        2 \((FirstDer[\([j, i]\)]*FirstDer[\([i, i]\)] - 
                              FirstDer[\([j, i]\)]\/\(x1\_i - x1\_j\))\), 
                        0], {j, 1, Nodes}, {i, 1, 
                        Nodes}]; \[IndentingNewLine]Do[
                    SecondDer[\([i, 
                          i]\)] = \(-\(\[Sum]\+\(k = 1\)\%Nodes 
                            SecondDer[\([k, i]\)]\)\), {i, 1, Nodes}]]\), ";",
                 "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(If[
                  Type === Sinc, \[IndentingNewLine]FDM[j_, i_] := 
                    Which[i != 
                        j, \((\(-1\))\)\^\(i - j\)\/\(hh*\((i - j)\)\), 
                      i == j, 0]; \[IndentingNewLine]SDM[j_, i_] := 
                    Which[i != 
                        j, \(2*\((\(-1\))\)\^\(i - j + 1\)\)\/\(hh\^2*\((i - \
j)\)\^2\), i == j, \(-\(\[Pi]\^2\/\(3*
                              hh\^2\)\)\)]; \[IndentingNewLine]FirstDer = 
                    Table[FDM[j, i], {j, 1, Nodes}, {i, 1, 
                        Nodes}]; \[IndentingNewLine]SecondDer = 
                    Table[SDM[j, i], {j, 1, Nodes}, {i, 1, Nodes}]]\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \( (*\(\(**\)\(\ \)\(Nodal\)\)\ \
Equations\ ***) \), "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(NdEq[
                    i_] := \ \(C\_i'\)[
                        t] == \((2  C\_i[t] - 
                              1)\)*\((\[Sum]\+\(k = 1\)\%Nodes 
                                  FirstDer[\([k, i]\)]*
                                C\_k[t])\) + \[Eta]\ \(\((C\_i[
                                  t])\)\^2\) \((1 - 
                              C\_i[t])\) \((\[Sum]\+\(k = 1\)\%Nodes 
                                  SecondDer[\([k, i]\)]*
                                C\_k[t])\) + \[Eta] \((C\_i[t])\) \((2 - 
                              3  C\_i[
                                  t])\) \((\[Sum]\+\(k = 1\)\%Nodes FirstDer[\
\([k, i]\)]*C\_k[t])\)\^2 /. x -> \ x1\_i\), ";", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(EqsSys = 
                  Flatten[
                    Table[{NdEq[i], 
                        C\_i[0] == \((\[CurlyPhi][x] /. 
                              x \[Rule] \ x1\_i)\)}, {i, 2, Nodes - 1}]]\), 
                ";", "\[IndentingNewLine]", \(NdEqsSys = 
                  Join[EqsSys, {\(C\_1'\)[t] \[Equal] 
                        D[InitBoundData[\([1]\)], t], 
                      C\_1[0] == \((\[CurlyPhi][x] /. 
                            x \[Rule] \ x1\_1)\), \(C\_Nodes'\)[t] \[Equal] 
                        D[InitBoundData[\([3]\)], t], 
                      C\_Nodes[
                          0] == \((\[CurlyPhi][x] /. 
                            x \[Rule] \ x1\_Nodes)\)}]\), ";", 
                "\[IndentingNewLine]", \(UnKnown = 
                  Join[Table[C\_i, {i, 1, Nodes}]]\), ";", 
                "\[IndentingNewLine]", \(NumSol = 
                  NDSolve[NdEqsSys, UnKnown, {t, 0, 1}, \ 
                      MaxSteps \[Rule] 10000000] // Flatten\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \( (*\(**\)\(\ \)\(Solution\)\ ***) \),
                 "\[IndentingNewLine]", \(Which[Type === Sinc, 
                  TotSol[x_, 
                      t_] := \[Sum]\+\(k = 1\)\%Nodes\( NumSol[\([k, 2]\)]\)[
                          t]*Sinc[k, x], Type === Lagrange, 
                  TotSol[x_, 
                      t_] := \[Sum]\+\(k = 1\)\%Nodes\( NumSol[\([k, 2]\)]\)[
                          t]*Lagr[k, x]]\), ";", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Print["\<Solution:\>"]\), ";", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"Plot3D", "[", 
                  
                  RowBox[{\(Evaluate[TotSol[x, t]]\), ",", \({x, 0, 1}\), 
                    ",", \({t, 0, 1}\), 
                    ",", \(PlotRange \[Rule] {{0, 1}, {0, 1}, {0.2, 0.4}}\), 
                    ",", 
                    RowBox[{"AxesLabel", "\[Rule]", 
                      RowBox[{"TraditionalForm", "/@", 
                        RowBox[{"{", 
                          RowBox[{
                            StyleBox["x",
                              FontSlant->"Italic"], ",", 
                            StyleBox["t",
                              FontSlant->"Italic"], ",", "\"\<\!\(\*
StyleBox[\"u\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"(\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"x\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\",\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"t\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\")\",\nFontSlant->\"Italic\"]\)\>\""}], "}"}]}]}], 
                    ",", \(Ticks \[Rule] {{0, 1}, {0, 1}, {0.2, 0.4}}\), 
                    ",", \(PlotPoints \[Rule] 101\)}], "]"}], ";"}]}], 
            "\[IndentingNewLine]", " ", "]"}]}], ";"}], 
      "\[IndentingNewLine]"}]], "Input"],

Cell[BoxData[{
    \(\({Nodes, \[Eta]} = {11,  .2};\)\), "\n", 
    \(\(InitCond = 0.2;\)\), "\n", 
    \(\(Bound0Cond = 0.5 - 0.3  \[ExponentialE]\^\(-t\);\)\), "\n", 
    \(\(Bound1Cond = 0.2;\)\), "\[IndentingNewLine]", 
    \(\(IBData = {Bound0Cond, InitCond, Bound1Cond};\)\)}], "Input"],

Cell[BoxData[
    \(\(Traffic1[IBData, Nodes, \[Eta], Lagrange];\)\)], "Input"]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1280}, {0, 701}},
Evaluator->"Local",
WindowSize->{1235, 683},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
ShowCellLabel->False,
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 1654, 25, 204, "Input"],
Cell[3411, 78, 194, 3, 52, "Input"],
Cell[3608, 83, 10661, 199, 1717, "Input"],
Cell[14272, 284, 292, 5, 111, "Input"],
Cell[14567, 291, 79, 1, 33, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

