(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     19143,        377]*)
(*NotebookOutlinePosition[     19896,        404]*)
(*  CellTagsIndexPosition[     19852,        400]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\( (*\(\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\)\(*\)***********) \)\(\[IndentingNewLine]\)\( (*\ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( \
(*\ Generalized\ Collocation\ \(Methods : 
          Solutions\ to\ Nonlinear\ Problems\)\ \
*) \)\(\[IndentingNewLine]\)\( (*\ Bellomo, \(\(N\)\(.\)\), 
      Lods, \(\(B\)\(.\)\), Revelli, \(\(R\)\(.\)\), 
      Ridolfi, \(\(L\)\(.\)\)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
*) \)\(\[IndentingNewLine]\)\( (*\ 
      A\ Birkh\[ADoubleDot]user\ book\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\
\[IndentingNewLine]\)\( (*\ 
      ISBN : 978 - 0 - 8176 - 4525 - 
          0\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ 
      Program\ Traffic2\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\
\( (*******************************************************************) \)\(\
\($TextStyle = {FontFamily -> "\<Times\>", 
          FontSize \[Rule] 12};\)\[IndentingNewLine]
    Off[General::"\<spell\>", General::"\<spell1\>"]\)\)\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{\(Traffic2[InitBoundDataU_, InitBoundDataQ_, Nodes_, \[Eta]_, 
            Type_]\), ":=", 
          RowBox[{"Module", "[", 
            
            RowBox[{\({}\), ",", 
              "\[IndentingNewLine]", \( (*\(\(**\)\(\ \)\(INITIAL\)\)\ \
CONDITION\ ***) \), "\[IndentingNewLine]", 
              
              RowBox[{\(\[CurlyPhi]U[x_] := InitBoundDataU[\([2]\)]\), ";", 
                "\[IndentingNewLine]", \(\[CurlyPhi]Q[x_] := 
                  InitBoundDataQ[\([2]\)]\), ";", 
                "\[IndentingNewLine]", \(hh = 1\/\(Nodes - 1\)\), ";", 
                "\[IndentingNewLine]", 
                RowBox[{"Which", "[", 
                  
                  RowBox[{\(Type === Sinc\), 
                    ",", \(x1\_i_ := \((i - 1)\)*hh\), 
                    ",", \(Type === Lagrange\), ",", 
                    
                    StyleBox[\(x1\_i_ := \(-\(1\/2. \)\) \((Cos[\((i - 
                                      1)\)*\[Pi]\/\(Nodes - 1\)] - 1)\)\),
                      FontColor->GrayLevel[0]]}], "]"}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                  RowBox[{\(Type === Lagrange\), ",", 
                    RowBox[{
                      
                      StyleBox[\(Lagr[j_, 
                            x_] := \[Product]\+\(p = 1\)\%Nodes\((If[
                                p \[NotEqual] 
                                  j, \(x - x1\_p\)\/\(x1\_j - x1\_p\), 
                                1])\)\),
                        FontColor->GrayLevel[0]], 
                      StyleBox[";",
                        FontColor->GrayLevel[0]], 
                      RowBox[{\(InitValueU[x_]\), ":=", 
                        
                        StyleBox[\(\[Sum]\+\(k = 1\)\%Nodes\((\[CurlyPhi]U[
                                    x] /. x \[Rule] \ x1\_k)\)*Lagr[k, x]\),
                          FontColor->GrayLevel[0]]}], 
                      StyleBox[";",
                        FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
                      RowBox[{\(InitValueQ[x_]\), ":=", 
                        
                        StyleBox[\(\[Sum]\+\(k = 1\)\%Nodes\((\[CurlyPhi]Q[
                                    x] /. x \[Rule] \ x1\_k)\)*Lagr[k, x]\),
                          FontColor->GrayLevel[0]]}]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\t",
                  FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                  RowBox[{\(Type === Sinc\), ",", 
                    RowBox[{
                      
                      StyleBox[\(Sinc[j_, x_] := 
                          Which[0 \[LessEqual] x \[LessEqual] 1\  && \ 
                              x \[NotEqual] \((j - 1)\)*hh, 
                            Sin[\(\[Pi]*\((x - \((j - 1)\)*hh)\)\)\/hh]/\((\(\
\[Pi]*\((x - \((j - 1)\)*hh)\)\)\/hh)\), x == \((j - 1)\)*hh, \ 1]\),
                        FontColor->GrayLevel[0]], 
                      StyleBox[";",
                        FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
                      StyleBox[
                        RowBox[{\(InitValueU[x_]\), ":=", 
                          RowBox[{\(\[Sum]\+\(k = 1\)\%Nodes\), 
                            RowBox[{
                              RowBox[{"(", 
                                RowBox[{\(\[CurlyPhi]U[x]\), "/.", 
                                  RowBox[{"x", "->", 
                                    SubscriptBox[
                                      StyleBox[
                                        RowBox[{"x", 
                                        StyleBox["1",
                                        FontColor->GrayLevel[0]]}]], "k"]}]}],
                                 ")"}], "*", \(Sinc[k, x]\)}]}]}],
                        FontColor->GrayLevel[0]], 
                      StyleBox[";",
                        FontColor->GrayLevel[0]], 
                      StyleBox[
                        RowBox[{\(InitValueQ[x_]\), ":=", 
                          RowBox[{\(\[Sum]\+\(k = 1\)\%Nodes\), 
                            RowBox[{
                              RowBox[{"(", 
                                RowBox[{\(\[CurlyPhi]Q[x]\), "/.", 
                                  RowBox[{"x", "->", 
                                    SubscriptBox[
                                      StyleBox[
                                        RowBox[{"x", 
                                        StyleBox["1",
                                        FontColor->GrayLevel[0]]}]], "k"]}]}],
                                 ")"}], "*", \(Sinc[k, x]\)}]}]}],
                        FontColor->GrayLevel[0]]}]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], "\t", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Print["\<Initial condition \
interpolation:\>"]\), ";", 
                "\[IndentingNewLine]", \(Plot[
                  Evaluate[{\[CurlyPhi]U[x], InitValueU[x]}], {x, 0, 1}, 
                  PlotStyle \[Rule] {GrayLevel[0], Dashing[{0.15, 0.05}]}, 
                  AxesLabel \[Rule] \ {x, u[x, 0]}, 
                  PlotRange \[Rule] {Automatic, {0, 1}}]\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Plot[
                  Evaluate[{\[CurlyPhi]Q[x], InitValueQ[x]}], {x, 0, 1}, 
                  PlotStyle \[Rule] {GrayLevel[0], Dashing[{0.15, 0.05}]}, 
                  AxesLabel \[Rule] \ {x, q[x, 0]}, 
                  PlotRange \[Rule] {Automatic, {0, 1}}]\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Print["\<Don't worry! I'm \
working\>"]\), ";", "\[IndentingNewLine]", 
                RowBox[{
                  StyleBox["(*",
                    FontColor->GrayLevel[0]], 
                  StyleBox[\(\(\(**\)\(\ \)\(DERIVATIVE\)\)\ MATRICES\)], 
                  StyleBox[" "], 
                  StyleBox["***)"]}], 
                "\[IndentingNewLine]", \(If[
                  Type === Lagrange, \[IndentingNewLine]FDM[j_, i_] := 
                    Which[i == 
                        j, \[Sum]\+\(k = 1\)\%Nodes If[k == i, 0, 
                          1\/\(x1\_i - x1\_k\)], 
                      i != j, \((\[Product]\+\(p = 1\)\%Nodes\((If[
                                p \[Equal] i, 1, 
                                x1\_i - x1\_p])\))\)/\((\((x1\_i - 
                                x1\_j)\) \(\[Product]\+\(p = 1\)\%Nodes\((If[
                                  p \[Equal] j, 1, 
                                  x1\_j - 
                                    x1\_p])\)\))\)]; \[IndentingNewLine]\
\[IndentingNewLine]FirstDer = 
                    Table[FDM[j, i], {j, 1, Nodes}, {i, 1, 
                        Nodes}]; \[IndentingNewLine]SecondDer = 
                    Table[If[i \[NotEqual] j, 
                        2 \((FirstDer[\([j, i]\)]*FirstDer[\([i, i]\)] - 
                              FirstDer[\([j, i]\)]\/\(x1\_i - x1\_j\))\), 
                        0], {j, 1, Nodes}, {i, 1, 
                        Nodes}]; \[IndentingNewLine]Do[
                    SecondDer[\([i, 
                          i]\)] = \(-\(\[Sum]\+\(k = 1\)\%Nodes 
                            SecondDer[\([k, i]\)]\)\), {i, 1, Nodes}]]\), ";",
                 "\[IndentingNewLine]", \(If[
                  Type === Sinc, \[IndentingNewLine]FDM[j_, i_] := 
                    Which[i != 
                        j, \((\(-1\))\)\^\(i - j\)\/\(hh*\((i - j)\)\), 
                      i == j, 0]; \[IndentingNewLine]SDM[j_, i_] := 
                    Which[i != 
                        j, \(2*\((\(-1\))\)\^\(i - j + 1\)\)\/\(hh\^2*\((i - \
j)\)\^2\), i == j, \(-\(\[Pi]\^2\/\(3*
                              hh\^2\)\)\)]; \[IndentingNewLine]FirstDer = 
                    Table[FDM[j, i], {j, 1, Nodes}, {i, 1, 
                        Nodes}]; \[IndentingNewLine]SecondDer = 
                    Table[SDM[j, i], {j, 1, Nodes}, {i, 1, Nodes}]]\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \( (*\(\(**\)\(\ \)\(Nodal\)\)\ \
Equations\ ***) \), 
                "\[IndentingNewLine]", \(NdEqU[
                    i_] := \ \(U\_i'\)[
                        t] == \(-\((\[Sum]\+\(k = 1\)\%Nodes 
                                FirstDer[\([k, i]\)]*Q\_k[t])\)\) /. 
                    x -> \ x1\_i\), ";", 
                "\[IndentingNewLine]", \(NdEqQ[
                    i_] := \ \(Q\_i'\)[
                        t] == \((\((\((1 - 
                                    2  U\_i[t])\) + \[Eta] \((U\_i[
                                      t])\) \((2 - 
                                      3  U\_i[
                                        t])\)*\((\[Sum]\+\(k = 1\)\%Nodes 
                                        FirstDer[\([k, i]\)]*
                                        Q\_k[
                                        t])\))\) \((\[Sum]\+\(k = 1\)\%Nodes 
                                    FirstDer[\([k, i]\)]*
                                  Q\_k[t])\) + \[Eta]\ \((U\_i[t])\) \((1 - 
                                U\_i[t])\) \((\[Sum]\+\(k = 1\)\%Nodes 
                                    SecondDer[\([k, i]\)]*Q\_k[t])\))\) /. 
                    x -> \ x1\_i\), ";", 
                "\[IndentingNewLine]", \(Q1U[t_] := 
                  D[InitBoundDataU[\([1]\)], t]\), ";", 
                "\[IndentingNewLine]", \(QMU[t_] := 
                  D[InitBoundDataU[\([3]\)], t]\), ";", "\[IndentingNewLine]",
                 "\[IndentingNewLine]", \(Q1Q[t_] := 
                  D[InitBoundDataQ[\([1]\)], t]\), ";", 
                "\[IndentingNewLine]", \(QMQ[t_] := 
                  D[InitBoundDataQ[\([3]\)], t]\), ";", "\[IndentingNewLine]",
                 "\[IndentingNewLine]", \(Eq0Q = \(Q\_1'\)[t] \[Equal] 
                    Q1Q[t]\), ";", 
                "\[IndentingNewLine]", \(EqMQ = \(Q\_Nodes'\)[t] \[Equal] 
                    QMQ[t]\), ";", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(EqsSysU = 
                  Flatten[
                    Table[{NdEqU[i], 
                        U\_i[0] == \((\[CurlyPhi]U[x] /. 
                              x \[Rule] \ x1\_i)\)}, {i, 1, Nodes}]]\), ";", 
                "\[IndentingNewLine]", \(EqsSysQ = 
                  Flatten[
                    Table[{NdEqQ[i], 
                        Q\_i[0] == \((\[CurlyPhi]Q[x] /. 
                              x \[Rule] \ x1\_i)\)}, {i, 2, Nodes - 1}]]\), 
                ";", "\[IndentingNewLine]", \(NdEqsSys = 
                  Join[EqsSysU, 
                    EqsSysQ, {Eq0Q, 
                      Q\_1[0] == \((\[CurlyPhi]Q[x] /. x \[Rule] \ x1\_1)\), 
                      EqMQ, Q\_Nodes[
                          0] == \((\[CurlyPhi]Q[x] /. 
                            x \[Rule] \ x1\_Nodes)\)}]\), ";", 
                "\[IndentingNewLine]", \(UnKnown = 
                  Join[Table[U\_i, {i, 1, Nodes}], 
                    Table[Q\_i, {i, 1, Nodes}]]\), ";", 
                "\[IndentingNewLine]", \(NumSol = 
                  NDSolve[NdEqsSys, UnKnown, {t, 0, 1}, \ 
                      MaxSteps \[Rule] 10000000] // Flatten\), ";", 
                "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \( (*\(**\)\(\ \)\(Solution\)\ ***) \),
                 "\[IndentingNewLine]", \(Which[Type === Sinc, 
                  TotSolU[x_, 
                      t_] := \[Sum]\+\(k = 1\)\%Nodes\( NumSol[\([k, 2]\)]\)[
                          t]*Sinc[k, x], Type === Lagrange, 
                  TotSolU[x_, 
                      t_] := \[Sum]\+\(k = 1\)\%Nodes\( NumSol[\([k, 2]\)]\)[
                          t]*Lagr[k, x]]\), ";", 
                "\[IndentingNewLine]", \(Which[Type === Sinc, 
                  TotSolQ[x_, 
                      t_] := \[Sum]\+\(k = 1\)\%Nodes\( 
                            NumSol[\([k + Nodes, 2]\)]\)[t]*Sinc[k, x], 
                  Type === Lagrange, 
                  TotSolQ[x_, 
                      t_] := \[Sum]\+\(k = 1\)\%Nodes\( 
                            NumSol[\([k + Nodes, 2]\)]\)[t]*Lagr[k, x]]\), 
                ";", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Print["\<Solution:\>"]\), ";", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"Plot3D", "[", 
                  
                  RowBox[{\(Evaluate[TotSolU[x, t]]\), ",", \({x, 0, 1}\), 
                    ",", \({t, 0, 1}\), ",", \(PlotRange \[Rule] All\), ",", 
                    RowBox[{"AxesLabel", "\[Rule]", 
                      RowBox[{"TraditionalForm", "/@", 
                        RowBox[{"{", 
                          RowBox[{
                            StyleBox["x",
                              FontSlant->"Italic"], ",", 
                            StyleBox["t",
                              FontSlant->"Italic"], ",", "\"\<\!\(\*
StyleBox[\"u\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"(\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"x\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\",\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"t\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\")\",\nFontSlant->\"Italic\"]\)\>\""}], "}"}]}]}], 
                    ",", \(Ticks \[Rule] {{0, 1}, {0, 1}, {0.2, 0.4}}\), 
                    ",", \(PlotPoints \[Rule] 101\)}], "]"}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"Plot3D", "[", 
                  
                  RowBox[{\(Evaluate[TotSolQ[x, t]]\), ",", \({x, 0, 1}\), 
                    ",", \({t, 0, 1}\), 
                    ",", \(PlotRange \[Rule] {{0, 1}, {0, 1}, {0, 0.3}}\), 
                    ",", 
                    RowBox[{"AxesLabel", "\[Rule]", 
                      RowBox[{"TraditionalForm", "/@", 
                        RowBox[{"{", 
                          RowBox[{
                            StyleBox["x",
                              FontSlant->"Italic"], ",", 
                            StyleBox["t",
                              FontSlant->"Italic"], ",", "\"\<\!\(\*
StyleBox[\"q\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"(\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"x\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\",\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"t\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\")\",\nFontSlant->\"Italic\"]\)\>\""}], "}"}]}]}], 
                    ",", \(Ticks \[Rule] {{0, 1}, {0, 1}, {0.1, 0.3}}\), 
                    ",", \(PlotPoints \[Rule] 101\)}], "]"}], ";"}]}], " ", 
            "\[IndentingNewLine]", "]"}]}], ";"}], 
      "\[IndentingNewLine]"}]], "Input"],

Cell[BoxData[{
    \(\({Nodes, \[Eta]} = {11,  .1};\)\), "\[IndentingNewLine]", 
    \(\({InitCondU, InitCondQ} = {0.2, 0.16};\)\), "\n", 
    \(\({Bound0CondU, Bound0CondQ} = {0, 0.16};\)\), "\[IndentingNewLine]", 
    \(\({Bound1CondU, Bound1CondQ} = {0, 
          0.16 + 0.1 
               Sin[5  t]};\)\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(\(IBDataU = {Bound0CondU, InitCondU, 
          Bound1CondU};\)\), "\[IndentingNewLine]", 
    \(\(IBDataQ = {Bound0CondQ, InitCondQ, Bound1CondQ};\)\)}], "Input"],

Cell[BoxData[
    \(\(Traffic2[IBDataU, IBDataQ, Nodes, \[Eta], Lagrange];\)\)], "Input"]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1280}, {0, 701}},
Evaluator->"Local",
WindowSize->{1160, 523},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
ShowCellLabel->False,
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 1807, 27, 242, "Input"],
Cell[3564, 80, 14956, 281, 2138, "Input"],
Cell[18523, 363, 524, 9, 147, "Input"],
Cell[19050, 374, 89, 1, 33, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

