(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     15350,        317]*)
(*NotebookOutlinePosition[     16111,        344]*)
(*  CellTagsIndexPosition[     16067,        340]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\( (*\(\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\)\(*\)***********) \)\(\[IndentingNewLine]\)\( (*\ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( \
(*\ Generalized\ Collocation\ \(Methods : 
          Solutions\ to\ Nonlinear\ Problems\)\ \
*) \)\(\[IndentingNewLine]\)\( (*\ Bellomo, \(\(N\)\(.\)\), 
      Lods, \(\(B\)\(.\)\), Revelli, \(\(R\)\(.\)\), 
      Ridolfi, \(\(L\)\(.\)\)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
*) \)\(\[IndentingNewLine]\)\( (*\ 
      A\ Birkh\[ADoubleDot]user\ book\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\
\[IndentingNewLine]\)\( (*\ 
      ISBN : 978 - 0 - 8176 - 4525 - 
          0\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ 
      Program\ TwoDLaSiErr\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*******************************************************************) \
\)\)\)], "Input"],

Cell[BoxData[
    \(<< Graphics`MultipleListPlot`\)], "Input"],

Cell[BoxData[{
    \(\($TextStyle = {FontFamily -> "\<Times\>", 
          FontSize \[Rule] 12};\)\), "\[IndentingNewLine]", 
    \(Off[General::"\<spell\>", General::"\<spell1\>"]\)}], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(TwoDLaSiErr[function_, nodes_, deltax_, deltay_]\), ":=", 
        RowBox[{"Module", "[", 
          
          RowBox[{\({}\), ",", 
            "\[IndentingNewLine]", \( (*\(\(**\)\(\ \)\(INITIAL\)\)\ \
CONDITION\ ***) \), "\[IndentingNewLine]", 
            
            RowBox[{\({NodesX, NodesY} = {nodes, nodes}\), ";", 
              "\[IndentingNewLine]", \(\[CurlyPhi][x_, y_] := function\), ";",
               "\[IndentingNewLine]", \({hhX, hhY} = {1\/\(NodesX - 1\), 
                  1\/\(NodesY - 1\)}\), ";", 
              "\[IndentingNewLine]", \(x\_i_ := \((i - 1)\)*hhX\), ";", 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], \(y\_i_ := \((i - 1)\)*hhY\), ";", 
              "\[IndentingNewLine]", \(x1\_i_ := \(-\(1\/2\)\) \((Cos[\((i - 
                              1)\)*\[Pi]\/\(NodesX - 1\)] - 1)\)\), ";", 
              "\[IndentingNewLine]", \(y1\_i_ := \(-\(1\/2\)\) \((Cos[\((i - 
                              1)\)*\[Pi]\/\(NodesY - 1\)] - 1)\)\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \( (*\(\(**\)\(\ \)\(Lagrange\)\)\ \
polynomial\ definition\ ***) \), "\[IndentingNewLine]", "\[IndentingNewLine]",
               
              RowBox[{\(Lagr1X[j_, x_]\), ":=", 
                RowBox[{\(\[Product]\+\(p = 1\)\%NodesX\), 
                  RowBox[{"(", 
                    
                    StyleBox[\(If[
                        p \[NotEqual] j, \(x - x1\_p\)\/\(x1\_j - x1\_p\), 
                        1]\),
                      FontColor->GrayLevel[0]], 
                    StyleBox[")",
                      FontColor->GrayLevel[0]]}]}]}], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              RowBox[{\(Lagr1Y[j_, y_]\), ":=", 
                RowBox[{\(\[Product]\+\(p = 1\)\%NodesY\), 
                  RowBox[{"(", 
                    
                    StyleBox[\(If[
                        p \[NotEqual] j, \(y - y1\_p\)\/\(y1\_j - y1\_p\), 
                        1]\),
                      FontColor->GrayLevel[0]], 
                    StyleBox[")",
                      FontColor->GrayLevel[0]]}]}]}], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              "\[IndentingNewLine]", \(FunctionLagr1[x_, 
                  y_] := \[Sum]\+\(m = 1\)\%NodesY\(\[Sum]\+\(k = 1\)\%NodesX\
\((\((\[CurlyPhi][x, y] /. {x \[Rule] \ x1\_k, y \[Rule] \ y1\_m})\)*
                        Lagr1X[k, x]*Lagr1Y[m, y])\)\)\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \( (*\(\(**\)\(\ \)\(Sinc\)\)\ function\ \
definition\ ***) \), "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(SincX[j_, x_] := 
                Which[0 \[LessEqual] x \[LessEqual] 1\  && \ 
                    x != \((j - 1)\)*hhX, 
                  Sin[\(\[Pi]*\((x - \((j - \
1)\)*hhX)\)\)\/hhX]/\((\(\[Pi]*\((x - \((j - 1)\)*hhX)\)\)\/hhX)\), 
                  x == \((j - 1)\)*hhX, \ 1]\), ";", 
              "\[IndentingNewLine]", \(SincY[j_, y_] := 
                Which[0 \[LessEqual] y \[LessEqual] 1\  && \ 
                    y != \((j - 1)\)*hhY, 
                  Sin[\(\[Pi]*\((y - \((j - \
1)\)*hhY)\)\)\/hhY]/\((\(\[Pi]*\((y - \((j - 1)\)*hhY)\)\)\/hhY)\), 
                  y == \((j - 1)\)*hhY, \ 1]\), ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(FunctionSinc[x_, 
                  y_] := \[Sum]\+\(m = 1\)\%NodesY\(\[Sum]\+\(k = 1\)\%NodesX\
\((\[CurlyPhi][x, y] /. {x -> x\_k, y \[Rule] y\_m})\)*SincX[k, x]*
                      SincY[m, y]\)\), ";", 
              StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0, 1]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0, 
                1]], \( (*\(\(**\)\(\ \)\(Error\)\)\ Evaluation\ ***) \), 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              RowBox[{
                StyleBox["ErrSinc",
                  FontColor->GrayLevel[0]], 
                "=", \(Table[
                  Evaluate[
                    Abs[\(\[CurlyPhi][x, y] - FunctionSinc[x, y]\)\/1]], {x, 
                    0, 1, deltax}, {y, 0, 1, deltay}]\)}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["ErrLagr",
                  FontColor->GrayLevel[0]], 
                "=", \(Table[
                  Evaluate[
                    Abs[\(\[CurlyPhi][x, y] - FunctionLagr1[x, y]\)\/1]], {x, 
                    0, 1, deltax}, {y, 0, 1, deltay}]\)}], ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \({MaxSinc, 
                  MaxLagr} = {Max[Flatten[ErrSinc]], Max[Flatten[ErrLagr]]}\),
               ";", "\[IndentingNewLine]", \({MeanSinc, 
                  MeanLagr} = {Mean[Flatten[ErrSinc]], 
                  Mean[Flatten[ErrLagr]]}\), ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(Print["\<Nodes \>", "\< MaxSinc \>", "\
\< MaxLagr \>", "\< MeanSinc \>", "\< MeanLagr \>"]\), 
              ";", \(Print[nodes, "\< \>", MaxSinc, "\< \>", 
                MaxLagr, "\< \>", MeanSinc, "\< \>", MeanLagr]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(ErrorMax[NodesX] = {NodesX, MaxSinc, 
                  MaxLagr}\), ";", 
              "\[IndentingNewLine]", \(ErrorMean[NodesX] = {NodesX, MeanSinc, 
                  MeanLagr}\), ";"}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[{
    \(\({function, MinNodes, MaxNodes, deltax, 
          deltay} = {Exp[\(-25\) \((2  x - 1)\)\^2 - 25 \((2  y - 1)\)\^2], 
          2, 41, 0.05, 0.05};\)\), "\[IndentingNewLine]", 
    \(For[i = 2, i < MaxNodes, TwoDLaSiErr[function, i, deltax, deltay]; 
      i = i + 1]\)}], "Input"],

Cell[BoxData[{
    \(\(SincMaxOdd = 
        Table[{\(ErrorMax[j]\)[\([1]\)], \(ErrorMax[j]\)[\([2]\)]}, {j, 
            MinNodes + 1, MaxNodes - 1, 2}];\)\), "\[IndentingNewLine]", 
    \(\(LagrMaxOdd = 
        Table[{\(ErrorMax[j]\)[\([1]\)], \(ErrorMax[j]\)[\([3]\)]}, {j, 
            MinNodes + 1, MaxNodes - 1, 2}];\)\), "\[IndentingNewLine]", 
    \(\(SincMeanOdd = 
        Table[{\(ErrorMean[j]\)[\([1]\)], \(ErrorMean[j]\)[\([2]\)]}, {j, 
            MinNodes + 1, MaxNodes - 1, 2}];\)\), "\[IndentingNewLine]", 
    \(\(LagrMeanOdd = 
        Table[{\(ErrorMean[j]\)[\([1]\)], \(ErrorMean[j]\)[\([3]\)]}, {j, 
            MinNodes + 1, MaxNodes - 1, 2}];\)\)}], "Input"],

Cell[BoxData[
    RowBox[{\( (*\(\(**\)\(\ \)\(Max\)\)\ \ Error\ for\ odd\ number\ of\ \
nodes\ ***) \), "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
        RowBox[{
          RowBox[{"p2a", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "SincMaxOdd", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      1.05}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {1, 1, 
                        0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\n", 
        RowBox[{
          RowBox[{"p2b", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "LagrMaxOdd", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      1.05}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {1, 1, 
                        0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0], 
                    Dashing[{Dash, Dash}]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", \(p2 = 
            Show[{p2a, p2b}, 
              DisplayFunction \[Rule] $DisplayFunction];\)}]}]], "Input"],

Cell[BoxData[
    RowBox[{\( (*\(\(**\)\(\ \)\(Mean\)\)\ \ Error\ for\ odd\ number\ of\ \
nodes\ ***) \), "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
        RowBox[{
          RowBox[{"p4a", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "SincMeanOdd", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      0.65}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {0.6, 
                        0.6, 0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\_1\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", 
        RowBox[{
          RowBox[{"p4b", "=", 
            RowBox[{"ListPlot", "[", 
              RowBox[{
              "LagrMeanOdd", ",", \(PlotJoined \[Rule] True\), 
                ",", \(PlotRange \[Rule] {{\(-0.01\), 40}, {\(-0.02\), 
                      0.65}}\), ",", \(Frame \[Rule] True\), 
                ",", \(FrameTicks \[Rule] {{{0, 0,  .02}, {10, 
                        10,  .02}, {20, 20,  .02}, {30, 30,  .02}, {40, 40, 
                        0.02}}, {{\(-1\), \(-1\),  .02}, {0, 0,  .02}, {0.6, 
                        0.6, 0.02}}, None, None}\), 
                ",", \(PlotStyle \[Rule] {GrayLevel[0], 
                    Dashing[{Dash, Dash}]}\), ",", 
                RowBox[{"FrameLabel", "\[Rule]", 
                  RowBox[{"TraditionalForm", "/@", 
                    RowBox[{"{", 
                      RowBox[{"n", ",", 
                        StyleBox[\(\[ScriptCapitalE]\_1\^n\),
                          FontSlant->"Italic"]}], "}"}]}]}], 
                ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], ";"}], 
        "\[IndentingNewLine]", \(p4 = 
            Show[{p4a, p4b}, 
              DisplayFunction \[Rule] $DisplayFunction];\)}]}]], "Input"]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1280}, {0, 701}},
Evaluator->"Local",
WindowSize->{1272, 679},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowCellLabel->False,
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 1649, 24, 204, "Input"],
Cell[3406, 77, 62, 1, 33, "Input"],
Cell[3471, 80, 194, 3, 52, "Input"],
Cell[3668, 85, 5850, 113, 1120, "Input"],
Cell[9521, 200, 303, 5, 55, "Input"],
Cell[9827, 207, 683, 12, 90, "Input"],
Cell[10513, 221, 2398, 46, 204, "Input"],
Cell[12914, 269, 2432, 46, 223, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

