(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13513,        285]*)
(*NotebookOutlinePosition[     14273,        312]*)
(*  CellTagsIndexPosition[     14229,        308]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\( (*\(\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(\
**\)\(**\)\(**\)\(**\)\)\(*\)***********) \)\(\[IndentingNewLine]\)\( (*\ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( \
(*\ Generalized\ Collocation\ \(Methods : 
          Solutions\ to\ Nonlinear\ Problems\)\ \
*) \)\(\[IndentingNewLine]\)\( (*\ Bellomo, \(\(N\)\(.\)\), 
      Lods, \(\(B\)\(.\)\), Revelli, \(\(R\)\(.\)\), 
      Ridolfi, \(\(L\)\(.\)\)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
*) \)\(\[IndentingNewLine]\)\( (*\ 
      A\ Birkh\[ADoubleDot]user\ book\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\
\[IndentingNewLine]\)\( (*\ 
      ISBN : 978 - 0 - 8176 - 4525 - 
          0\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ 
      Program\ TwoDLaSiInt\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*\ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \)\(\[IndentingNewLine]\)\( (*******************************************************************) \
\)\)\)], "Input"],

Cell[BoxData[{
    \(\($TextStyle = {FontFamily -> "\<Times\>", 
          FontSize \[Rule] 12};\)\), "\[IndentingNewLine]", 
    \(Off[General::"\<spell\>", General::"\<spell1\>"]\)}], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[\(TwoDLaSiInt[function_, NodesX_, NodesY_]\),
          FontColor->GrayLevel[0]], 
        StyleBox[":=",
          FontColor->GrayLevel[0]], 
        RowBox[{"Module", "[", 
          RowBox[{\({}\), ",", 
            StyleBox["\[IndentingNewLine]",
              FontColor->GrayLevel[0]], 
            StyleBox[\( (*\(\(**\)\(\ \)\(INITIAL\)\)\ CONDITION\ ***) \),
              FontColor->GrayLevel[0]], 
            StyleBox["\[IndentingNewLine]",
              FontColor->GrayLevel[0]], 
            RowBox[{
              StyleBox[\(\[CurlyPhi][x_, y_] := function\),
                FontColor->GrayLevel[0]], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              RowBox[{
                RowBox[{
                  StyleBox["{",
                    FontColor->GrayLevel[0]], \(hhX, hhY\), "}"}], 
                "=", \({1\/\(NodesX - 1\), 1\/\(NodesY - 1\)}\)}], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0, 0]], \(x\_i_ := \((i - 1)\)*hhX\), 
              ";", 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], \(y\_i_ := \((i - 1)\)*hhY\), ";", 
              "\[IndentingNewLine]", \(x1\_i_ := \(-\(1\/2\)\) \((Cos[\((i - 
                              1)\)*\[Pi]\/\(NodesX - 1\)] - 1)\)\), ";", 
              "\[IndentingNewLine]", \(y1\_i_ := \(-\(1\/2\)\) \((Cos[\((i - 
                              1)\)*\[Pi]\/\(NodesY - 1\)] - 1)\)\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \( (*\(\(**\)\(\ \)\(Lagrange\)\)\ \
polynomial\ definition***) \), "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{\(Lagr1X[j_, x_]\), ":=", 
                RowBox[{\(\[Product]\+\(p = 1\)\%NodesX\), 
                  RowBox[{"(", 
                    StyleBox[\(If[
                        p \[NotEqual] j, \(x - x1\_p\)\/\(x1\_j - x1\_p\), 
                        1]\),
                      FontColor->GrayLevel[0]], 
                    StyleBox[")",
                      FontColor->GrayLevel[0]]}]}]}], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              RowBox[{\(Lagr1Y[j_, y_]\), ":=", 
                RowBox[{\(\[Product]\+\(p = 1\)\%NodesY\), 
                  RowBox[{"(", 
                    
                    StyleBox[\(If[
                        p \[NotEqual] j, \(y - y1\_p\)\/\(y1\_j - y1\_p\), 
                        1]\),
                      FontColor->GrayLevel[0]], 
                    StyleBox[")",
                      FontColor->GrayLevel[0]]}]}]}], 
              StyleBox[";",
                FontColor->GrayLevel[0]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
              "\[IndentingNewLine]", \(FunctionLagr1[x_, 
                  y_] := \[Sum]\+\(m = 1\)\%NodesY\(\[Sum]\+\(k = 1\)\%NodesX\
\((\((\[CurlyPhi][x, y] /. {x \[Rule] \ x1\_k, y \[Rule] \ y1\_m})\)*
                        Lagr1X[k, x]*Lagr1Y[m, y])\)\)\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \( (*\(\(**\)\(\ \)\(Sinc\)\)\ function\ \
definition\ ***) \), "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(SincX[j_, x_] := 
                Which[0 \[LessEqual] x \[LessEqual] 1\  && \ 
                    x != \((j - 1)\)*hhX, 
                  Sin[\(\[Pi]*\((x - \((j - \
1)\)*hhX)\)\)\/hhX]/\((\(\[Pi]*\((x - \((j - 1)\)*hhX)\)\)\/hhX)\), 
                  x == \((j - 1)\)*hhX, \ 1]\), ";", 
              "\[IndentingNewLine]", \(SincY[j_, y_] := 
                Which[0 \[LessEqual] y \[LessEqual] 1\  && \ 
                    y != \((j - 1)\)*hhY, 
                  Sin[\(\[Pi]*\((y - \((j - \
1)\)*hhY)\)\)\/hhY]/\((\(\[Pi]*\((y - \((j - 1)\)*hhY)\)\)\/hhY)\), 
                  y == \((j - 1)\)*hhY, \ 1]\), ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{\(FunctionSinc[x_, y_]\), ":=", 
                RowBox[{
                  StyleBox[\(\[Sum]\+\(m = 1\)\%NodesY\),
                    FontColor->GrayLevel[0]], 
                  RowBox[{\(\[Sum]\+\(k = 1\)\%NodesX\), 
                    RowBox[{
                      RowBox[{"(", 
                        RowBox[{\(\[CurlyPhi][x, y]\), "/.", 
                          RowBox[{"{", 
                            RowBox[{\(x -> x\_k\), ",", 
                              StyleBox[\(y \[Rule] y\_m\),
                                FontColor->GrayLevel[0]]}], 
                            StyleBox["}",
                              FontColor->GrayLevel[0]]}]}], ")"}], 
                      "*", \(SincX[k, x]\), "*", \(SincY[m, y]\)}]}]}]}], ";",
               
              StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0, 1]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0, 1]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0, 1]], 
              RowBox[{"Plot3D", "[", 
                
                RowBox[{\(Evaluate[FunctionSinc[x, y]]\), ",", \({x, 0, 1}\), 
                  ",", \({y, 0, 1}\), ",", \(PlotRange \[Rule] All\), ",", 
                  RowBox[{"AxesLabel", "\[Rule]", 
                    RowBox[{"TraditionalForm", "/@", 
                      RowBox[{"{", 
                        RowBox[{
                          StyleBox["x",
                            FontSlant->"Italic"], ",", 
                          StyleBox["y",
                            FontSlant->"Italic"], ",", "\"\<\!\(\*
StyleBox[\"w\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"(\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"x\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\",\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"y\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\")\",\nFontSlant->\"Italic\"]\)\>\""}], "}"}]}]}], 
                  ",", \(Ticks \[Rule] {{0, 1}, {0, 1}, {0, 1}}\), 
                  ",", \(PlotLabel -> "\<Sinc Interpolation\>"\), 
                  ",", \(PlotPoints \[Rule] 51\)}], "]"}], ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"Plot3D", "[", 
                
                RowBox[{\(Evaluate[FunctionLagr1[x, y]]\), ",", \({x, 0, 1}\),
                   ",", \({y, 0, 1}\), ",", \(PlotRange \[Rule] All\), ",", 
                  RowBox[{"AxesLabel", "\[Rule]", 
                    RowBox[{"TraditionalForm", "/@", 
                      RowBox[{"{", 
                        RowBox[{
                          StyleBox["x",
                            FontSlant->"Italic"], ",", 
                          StyleBox["y",
                            FontSlant->"Italic"], ",", "\"\<\!\(\*
StyleBox[\"w\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"(\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"x\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\",\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\"y\",\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\")\",\nFontSlant->\"Italic\"]\)\>\""}], "}"}]}]}], 
                  ",", \(Ticks \[Rule] {{0, 1}, {0, 1}, {0, 1}}\), 
                  ",", \(PlotPoints \[Rule] 51\), 
                  ",", \(PlotLabel -> "\<Lagrange Interpolation\>"\)}], "]"}],
               ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"Plot3D", "[", 
                
                RowBox[{\(Evaluate[
                    100000*Abs[\[CurlyPhi][x, y] - FunctionSinc[x, y]]]\), 
                  ",", \({x, 0, 1}\), ",", \({y, 0, 1}\), 
                  ",", \(PlotRange \[Rule] {{0, 1}, {0, 1}, {0, 1}}\), ",", 
                  RowBox[{"AxesLabel", "\[Rule]", 
                    RowBox[{"TraditionalForm", "/@", 
                      RowBox[{"{", 
                        RowBox[{
                          StyleBox["x",
                            FontSlant->"Italic"], ",", 
                          StyleBox["y",
                            FontSlant->"Italic"], ",", "\"\<\!\(\*
StyleBox[\(\[ScriptCapitalE]\^n\),\n\
FontSlant->\"Italic\"]\)*\!\(10\^5\)\>\""}], "}"}]}]}], 
                  ",", \(Ticks \[Rule] {{0, 1}, {0, 1}, {0, 1}}\), 
                  ",", \(PlotPoints \[Rule] 51\), 
                  ",", \(PlotLabel \[Rule] "\<Error (Sinc \
interpolation)\>"\)}], "]"}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"Plot3D", "[", 
                
                RowBox[{\(Evaluate[
                    1000*Abs[\[CurlyPhi][x, y] - FunctionLagr1[x, y]]]\), 
                  ",", \({x, 0, 1}\), ",", \({y, 0, 1}\), 
                  ",", \(PlotRange \[Rule] All\), ",", 
                  RowBox[{"AxesLabel", "\[Rule]", 
                    RowBox[{"TraditionalForm", "/@", 
                      RowBox[{"{", 
                        RowBox[{
                          StyleBox["x",
                            FontSlant->"Italic"], ",", 
                          StyleBox["y",
                            FontSlant->"Italic"], ",", "\"\<\!\(\*
StyleBox[\(\[ScriptCapitalE]\^n\),\n\
FontSlant->\"Italic\"]\)*\!\(10\^3\)\>\""}], "}"}]}]}], 
                  ",", \(Ticks \[Rule] {{0, 1}, {0, 1}, {0, 4}}\), 
                  ",", \(PlotPoints \[Rule] 51\), 
                  ",", \(PlotLabel \[Rule] "\<Error (Lagrange \
interpolation)\>"\)}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
      ";"}]], "Input"],

Cell[BoxData[{
    \(\({function, NodesX, 
          NodesY} = {Exp[\(-25\) \((2  x - 1)\)\^2 - 25 \((2  y - 1)\)\^2], 
          15, 15};\)\), "\[IndentingNewLine]", 
    \(TwoDLaSiInt[function, NodesX, NodesY]\)}], "Input"]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1280}, {0, 701}},
Evaluator->"Local",
WindowSize->{906, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowCellLabel->False,
Magnification->1.25
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 1649, 24, 204, "Input"],
Cell[3406, 77, 194, 3, 52, "Input"],
Cell[3603, 82, 9678, 195, 1245, "Input"],
Cell[13284, 279, 225, 4, 55, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

