% 3rd order SCIG-based WECS model
% data file for ord3mw2lin.mdl application
% SI units
clear

% turbine
% 2MW -> 10m/s
R= 45
i= 100
JHSS= 990

% electrical machine
% 960V / 50Hz
Rs= 0.0011
Rr= 0.0013
Lm= 2.9936e-3
Lsgm_s= 7e-5
Lsgm_r= 7.5e-5
Lss= Lsgm_s + Lm
Lrr= Lsgm_r + Lm
p= 2
rated_fp= 50
omg_e= 2*pi*rated_fp;
Dl= Lss*Lrr-Lm^2;
tau_sr= Rs*Lrr/Dl; tau_rm= Rr*Lm/Dl;
sigma_r= Lm/Lrr; sigma_s= Lm/Lss;
alpha= 1/(1+(omg_e/tau_sr)^2);

% flux -> currents transformation matrix (Relation 3.41)
M= [Lss 0 Lm 0; 0 Lss 0 Lm; Lm 0 Lrr 0; 0 Lm 0 Lrr];
Q= inv(M);

% initial system states
% [flux_d flux_q omg_h]
ist= [0 0 0]