% this program computes the WECS (rigid drive train) linearized model parameters ...
% around a steady-state operating pont -> at a given steady-state wind ...
% speed, "wind_st"

% input the wind velocity
df=num2str(wind_st);
wind={'Input the steady-state wind velocity:'};
tmp=inputdlg(wind,'!',1,{df});
if isempty(tmp)~=1; wind_st=[str2double(tmp)]; end
if isempty(wind_st) wind_st=7; end


% torque parameter computation
cg=[-4.54e-7 1.3027e-5 -6.5416e-5 -9.7477e-4 0.0081 -0.0013 0.0061];
cp=[cg 0];
for idx=1:length(cg),
   cpd(idx)=cg(idx)*(length(cg)-idx+1);
end;
gamma=polyval(cpd,lam_opt)*lam_opt/polyval(cp,lam_opt)-1


% steady-state operating point on the ORC
wmax=60; wcuant=0.05; w=0:wcuant:wmax; % rotational speed range
for ind=1:length(w)
 u=w(ind)*R/wind_st;      % tip speed ratio (lamda)
 cc=polyval(cg,u);        % actual torque coefficient value
 c(ind)=0.5*pi*1.25*wind_st*wind_st*(R^3)*cc; 
 p(ind)=c(ind)*w(ind);    % speed (w), torque (c) and power (p) characteristics for
                          % the steady-state value of the wind velocity (wind_st)
end;
 % maximum power points (MPP) constituting the ORC
   [pmx,poz]=max(p);
 % steady-state speed value coresponding to MPP
   omg=w(poz)
 % steady-state torque value coresponding to MPP
   cpl=c(poz)
 % steady-state power value coresponding to MPP  
   pmx
 
 % linearized model parameters computation
   JT=Jwt*omg/cpl        % uses the turbine rotor inertia
   Tw=Lt/wind_st         % uses the turbulence length
