% computes the estimator parameters [L1 L2 L3 L4]
% HF model state variables are targeted

% linearized system model
A=[0 0 1/JG 0; 0 0 -1/JT 1/JT; -KA KA -Bs*(1/JB+1/Jg) Bs/JB; 0 gam/Tw -gam/JT gam/JT-1/Tw]; 
B=[-1/JG; 0; Bs/Jg; 0];
C=[1 0 0 0];                 % output matrix... -> LSS rotational speed
D=[0];

% system matrix analysis
[m,n]=size(A);
poles=eig(A);
% characteristic polynomial of A
pc=poly(A);
% imposing transient response of the estimation
%poles_est=[15*poles(1:3)' 500*poles(4)];
poles_est=[10*poles(1) 10*poles(2) 5*poles(3) 25*poles(4)];
% characteristic polynomial of the estimation loop
coef=poly(poles_est);

% estimator computing procedure
L=(coef(2:n+1)-pc(2:n+1))';
Co=[1 0 0 0];
Ao=[-pc(2:n+1)' [eye(n-1); zeros(1,n-1)]];
omx=obsv(Ao, Co);
omz=obsv(A, C);
P=inv(omz)*omx;
% estimator matrices
A_est=A-P*L*C;
C_est=C;

% estimation parameters
% to be used flexible_2LPSF_ctrl.mdl file, in block named
% "2LFSP control" -> "controller /HFL" -> "state estimator"
xxl=P*L;
L1=xxl(1)
L2=xxl(2)
L3=xxl(3)
L4=xxl(4)
