% data file for LQ_RST_ctrl.mdl application
% SI units
clear all

% loading precomputed wind sequece from 'vntu.mat'  (selection is 4)
load vntu, tt=1:length(vK); tt=tt'; vK=vK';

% aerodynamic parameters 
ro= 1.25, R= 2.5
cp_m= 0.47, lam_opt= 7     % maximum values of power coefficient, tip speed ratio 
tC_opt= cp_m/lam_opt       % and torque coefficient
Jwt= 3,                    % rotor inertia 
sT= 0                      % static (or supplimentary) component torque

% mech. transmission parameters
i=6.25, eta=0.95           % multiplication ratio and efficiency
ks =75, bs =2              % stiffness and damping
                           % no supplimentary inertias of transmission


% SCIG parameters
% 220V / 50Hz
% 157 rad/s
% 6kW
Rs = 1.265, Rr = 1.430      % stator & rotor resistance, inductance etc
Ls = 0.1452, Lr = 0.1452
Lm = 0.1397, p = 2
sgm=1-Lm^2/Lr/Ls, Tr=Lr/Rr
emTmax = 50                 % maximum torque value
Jg = 0.01                   % IM inertia

% control law parameters
Ts = 0.01                   % sample time
                            % other control parameters... to be generated

disp('Parameters loaded!')
